/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.SignConstants;

/**
 * 对象相关工具类
 * 
 * @version v1.0.0 @author zouzhigang 2014-2-27 新建与整理
 */
@AnAlias("Objects")
public class Objects implements SignConstants
{
    /**************************************************************/
    //V1.5.1计算删除
    /**************************************************************/
    
    @Deprecated /** 请使用copy方法，该方法V1.5.1将删除 */
    public static <T> T copyPropertis(Object src, T dst)
    {
        return copy(src, dst);
    }
    
    @Deprecated /** 请使用copyDeep方法，该方法V1.5.1将删除 */
    public static <T> T copyPropertisDeep(Object src, T dst)
    {
        return copyDeep(src, dst);
    }
    
    @Deprecated /** 请使用copySrcDeep方法，该方法V1.5.1将删除 */
    public static <T> T copyPropertisSrcDeep(Object src, T dst)
    {
        return copySrcDeep(src, dst);
    }
    
    @Deprecated /** 请使用copyDstDeep方法，该方法V1.5.1将删除 */
    public static <T> T copyPropertisDestDeep(Object src, T dst)
    {
        return copySrcDeep(src, dst);
    }
    /**************************************************************/
    //拷贝属性方法
    /**************************************************************/
    
    /**
     * 浅拷贝属性,静态和临时两种属性不拷贝,父类的属性不拷贝
     * 
     * @param src   原对象
     * @param dst   目标对象
     * @return      目标对象
     */
    public static <T> T copy(Object src, T dst)
    {
        Asserts.notNull(src, _SRC_);
        Asserts.notNull(dst, _DST_);
        
        copyFields(src, dst, src.getClass(), dst.getClass());
        return dst;
    }
    
    /**
     * 对源和目标对象进行深度拷贝,静态和临时两种属性不拷贝
     * 
     * @param src   原对象
     * @param dst   目标对象
     * @return      目标对象
     */
    public static <T> T copyDeep(Object src, T dst)
    {
        Asserts.notNull(src, _SRC_);
        Asserts.notNull(dst, _DST_);
        
        Class<?> superSrcClass = src.getClass();
        while (superSrcClass != null && superSrcClass != Object.class)
        {
            Class<?> superDestClass = dst.getClass();
            while (superDestClass != null && superDestClass != Object.class)
            {
                copyFields(src, dst, superSrcClass, superDestClass);
                superDestClass = superDestClass.getSuperclass();
            }
            
            superSrcClass = superSrcClass.getSuperclass();
        }
        return dst;
    }
    
    /**
     * 根据原类深属性拷贝(父类的循环查找拷贝),静态和临时两种属性不拷贝
     * 
     * @param src   原对象
     * @param dst   目标对象
     * @return      目标对象
     */
    public static <T> T copySrcDeep(Object src, T dst)
    {
        Asserts.notNull(src, _SRC_);
        Asserts.notNull(dst, _DST_);
        
        copyFields(src, dst, src.getClass(), dst.getClass());
        Class<?> superSrcClass = src.getClass().getSuperclass();
        while (superSrcClass != null && superSrcClass != Object.class)
        {
            copyFields(src, dst, superSrcClass, dst.getClass());
            
            superSrcClass = superSrcClass.getSuperclass();
        }
        return dst;
    }
    
    /**
     * 根据目标类深属性拷贝(父类的循环查找拷贝),静态和临时两种属性不拷贝
     * 
     * @param src 原对象
     * @param dst 目标对象
     */
    public static <T> T copyDstDeep(Object src, T dst)
    {
        Asserts.notNull(src, _SRC_);
        Asserts.notNull(dst, _DST_);
        
        copyFields(src, dst, src.getClass(), dst.getClass());
        Class<?> superDestClass = dst.getClass().getSuperclass();
        while (superDestClass != null && superDestClass != Object.class)
        {
            copyFields(src, dst, src.getClass(), superDestClass);
            
            superDestClass = superDestClass.getSuperclass();
        }
        return dst;
    }
    
    /**
     * 当前对象内属性拷贝,静态和临时两种属性不拷贝
     * 
     * @param src 原对象
     * @param dst 目标对象
     */
    private static void copyFields(Object src, Object dst, Class<?> sClass, Class<?> dClass)
    {
        try
        {
            Field[] sFields = sClass.getDeclaredFields();
            Field[] dFields = dClass.getDeclaredFields();
            for (int i=0;i<dFields.length;i++)
            {
                Field dField = dFields[i];
                int mod = dField.getModifiers();
                if (Modifier.isStatic(mod) || Modifier.isTransient(mod))
                    continue;//静态和临时两种属性不拷贝
                
                for (int j=0;j<sFields.length;j++)
                {
                    Field sField = sFields[j];
                    int modj = sField.getModifiers();
                    if (Modifier.isStatic(modj) || Modifier.isTransient(modj))
                        continue;
                    
                    if (dField.getName().equals(sField.getName()))
                    {
                        sField.setAccessible(true);
                        Object value = sField.get(src);
                        dField.setAccessible(true);
                        dField.set(dst, value);
                        break;
                    }
                }
            }
        }
        catch(Exception e)
        {
            e.printStackTrace();
            //异常不处理
        }
    }
    
}
