/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.util;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;

import org.zhiqim.kernel.annotation.AnNullable;

/**
 * Linux相关工具类
 *
 * @version v1.0.0 @author zouzhigang 2014-2-27 新建与整理
 */
public class Linux
{
    /***************************************************************/
    //Linux的 /bin/sh 命令操作
    /***************************************************************/
    
    /**
     * 执行shell命令，无返回结果，调用/bin/sh -c;
     * 
     * @param cmd           命令，多个用分号隔开
     * @throws IOException  异常
     */
    public static void shell(String cmd) throws IOException
    {
        Asserts.as(Systems.isLinux()?null:"不是Linux系统，不支持调用shell命令");
        Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", cmd});
    }
    
    /**
     * 执行shell命令，返回字符串列表，调用/bin/sh -c;
     * 
     * @param cmd           命令行
     * @param encoding      编码
     * @throws IOException  异常
     */
    public static String shell(String cmd, String encoding) throws IOException
    {
        Asserts.as(Systems.isLinux()?null:"不是Linux系统，不支持调用shell命令");
        return Runtimes.exec(new String[]{"/bin/sh", "-c", cmd}, Charset.forName(encoding));
    }
    
    /**
     * 执行shell命令，返回字符串列表，调用/bin/sh -c;
     * 
     * @param cmd           命令行
     * @param encoding      编码
     * @param maxLineNum    返回行数,0表示所有行,>0表示返回该行数即结束
     * @throws IOException  异常
     */
    public static List<String> shell(String cmd, String encoding, int maxLineNum) throws IOException
    {
        Asserts.as(Systems.isLinux()?null:"不是Linux系统，不支持调用shell命令");
        return Runtimes.exec(new String[]{"/bin/sh", "-c", cmd}, encoding, maxLineNum);
    }
    
    /***************************************************************/
    //Linux的 /bin/sh 命令操作
    /***************************************************************/
    
    /**
     * 执行ifconfig命令，得到结果字符串
     * 
     * @param encoding      编码
     * @return              结果
     * @throws IOException  IO异常
     */
    public static String ifconfig(String encoding) throws IOException
    {
        return shell("ifconfig", encoding);
    }
    
    /**
     * 执行ifconfig命令，得到结果字符串
     * 
     * @param arguments     参数
     * @param encoding      编码
     * @return              结果
     * @throws IOException  IO异常
     */
    public static String ifconfig(String arguments, String encoding) throws IOException
    {
        return shell(Validates.isEmpty(arguments)?"ifconfig":"ifconfig "+arguments, encoding);
    }
    
    /**
     * 获取第一个MAC地址，结果为null表示未找到
     * 
     * @param encoding      编码
     * @return              MAC地址
     * @throws IOException  IO异常
     */
    @AnNullable
    public static String getFirstMacAddress(String encoding) throws IOException
    {
        String result = ifconfig(encoding);
        if (Validates.isEmptyBlank(result))
            return null;
        
        String[] lines = Arrays.toStringArray(result, "\n");
        for(String line : lines)
        {      
            line = line.trim();
            if (line.indexOf("HWaddr") >= 0)
            {
                String mac = line.substring(line.length() - 17);
                return mac.replaceAll("-", ":");
            }
        }   
        
        return null;
    }
}
