/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

import javax.imageio.ImageIO;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.SignConstants;

/**
 * 图片工具类
 *
 * @version v1.0.0 @author zouzhigang 2017-6-1 新建与整理
 */
@AnAlias("Images")
public class Images implements SignConstants
{
    /**
     * 图片压缩成PNG格式
     * 
     * @param data　        图片数据
     * @param width         压缩后宽度
     * @param height        压缩后高度
     * @throws IOException  IO异常
     */
    public static byte[] resizePNG(byte[] data, int width, int height) throws IOException
    {
        Asserts.notNull(data);
        
        ByteArrayInputStream input = new ByteArrayInputStream(data);
        BufferedImage src = ImageIO.read(input);
        
        BufferedImage buffImg = null;   
        if(src.isAlphaPremultiplied())//判断alpha通道是否需要变为透明的
            buffImg = new BufferedImage(width, height, BufferedImage.TRANSLUCENT);  
        else  
            buffImg = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);  
     
        Image image = src.getScaledInstance(width, height, Image.SCALE_SMOOTH);//压缩时作平滑处理
        
        Graphics2D  g = (Graphics2D) buffImg.getGraphics();
        g.drawImage(image, 0, 0, width, height, Color.white, null); //Color.white防止背景有时变黑
        g.dispose();
         
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ImageIO.write(buffImg, _PNG_, output);
        
        return output.toByteArray();
    }
}
