/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.util;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.HtmlConstants;

/**
 * HTML相关工具类
 *
 * @version v1.0.0 @author zouzhigang 2014-2-27 新建与整理
 */
@AnAlias("Htmlx")
public class Htmlx implements HtmlConstants
{
    /**
     * 显示HTML内容格式标签
     * 
     * @param charset 编码
     * @return <meta http-equiv="Content-Type" content="text/html; charset=${charset}">
     */
    public static String toContentType(String charset)
    {
        return "<meta http-equiv=\"Content-Type\" content=\"text/html; charset="+charset+"\">\r\n";
    }
    
    /**
     * 显示HTML标题标签
     * 
     * @param title 标题信息
     * @return <title>${title}</title>
     */
    public static String toTitle(String title)
    {
        return "<title>"+title+"</title>\r\n";
    }
    
    /**
     * 显示Form表单或href通过iframe调用
     * 
     * @return <iframe name="zCallFrame" style="display:none;"></iframe>
     */
    public static String toCallFrame()
    {
        return "<iframe name=\"zCallFrame\" style=\"display:none;\"></iframe>";
    }
}
