/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.paging;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnGlobal;
import org.zhiqim.kernel.util.Validates;

/**
 * 只有上一页&下一页的分页显示，支持显示如下：<br>
 * 1、上一页<br>
 * 2、下一页<br>
 *
 * @version v1.0.0 @author zouzhigang 2017-11-16 新建与整理
 */
@AnAlias("PagingUD")
@AnGlobal
public class PagingUD implements Paging
{
    /**
     * 提供传入的是URL链接的分页显示
     * 
     * @param result        结果集
     * @return              分页显示HTML
     */
    public String toHtmlLink(PageResult<?> result)
    {
        return toHtmlLink(result, null);
    }
    
    /**
     * 提供传入的是URL链接的分页显示
     * 
     * @param result        结果集
     * @param link          URL链接
     * @return              分页显示HTML
     */
    public String toHtmlLink(PageResult<?> result, String link)
    {
        if (result == null)
            result = PageBuilder.newResult(20);
        
        if (link == null)
            link = "";
        
        String condition = result.getConditionUrl();
        if (Validates.isNotEmpty(condition))
            link += condition + "&";
        else
            link += "?";
        
        StringBuilder strb = new StringBuilder();
        strb.append("<div class=\"z-relative-center z-text-center\">");
        
        if (result.hasPrevious())
            strb.append("<span class=\"z-button z-mg-r3\" onclick=\"location.href='" + link + "page=" + (result.pageNo() - 1) + "'\">上一页</span>");
        else
            strb.append("<span class=\"z-button z-mg-r3 z-readonly\">上一页</span>");
    
        if (result.hasNext())
            strb.append("<span class=\"z-button z-mg-r3\" onclick=\"location.href='" + link + "page=" + (result.pageNo() + 1) + "'\">下一页</span>");
        else
            strb.append("<span class=\"z-button z-mg-r3 z-readonly\">下一页</span>");
    
        strb.append("</div>");
        return strb.toString();
    }
    
    /**
     * 提供传入的是Js函数名的分页显示
     * 
     * @param result        结果集
     * @param jsMethod      Js函数
     * @return              分页显示HTML
     */
    public String toHtmlClick(PageResult<?> result, String jsMethod)
    {
        if (result == null)
            result = PageBuilder.newResult(20);
        
        StringBuilder strb = new StringBuilder();
        strb.append("<div class=\"z-relative-center z-text-center\">");
        
        if (result.hasPrevious())
            strb.append("<span class=\"z-button z-mg-r3\" onclick=\""+jsMethod+"('"+(result.pageNo() - 1) + "');\">上一页</span>");
        else
            strb.append("<span class=\"z-button z-mg-r3 z-readonly\">上一页</span>");
    
        if (result.hasNext())
            strb.append("<span class=\"z-button z-mg-r3\" onclick=\""+jsMethod+"('"+(result.pageNo() + 1) + "');\">下一页</span>");
        else
            strb.append("<span class=\"z-button z-mg-r3 z-readonly\">下一页</span>");
    
        strb.append("</div>");
        return strb.toString();
    }
}
