/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.logging;

import org.zhiqim.kernel.constants.CodeConstants;

/**
 * 日志常量定义
 *
 * @version v1.0.0 @author zouzhigang 2016-1-8 新建与整理
 */
public interface LogConstants extends CodeConstants
{
    /******************************************************************/
    //日志配置
    /******************************************************************/
    
    public String MUST_NAME                = "must.name";
    public String MUST_CLASS               = "must.class";
    public String CONSOLE_OUT              = "console.out";
    public String CONSOLE_PATTERN          = "console.pattern";
    public String FILE_OUT                 = "file.out";
    public String FILE_PATH                = "file.path";
    public String FILE_PATTERN             = "file.pattern";
    public String FILE_ENCODING            = "file.encoding";
    public String FILE_MAX_NUM             = "file.maxNum";
    public String FILE_MAX_SIZE            = "file.maxSize";
    public String FILE_LOGGER              = "file.logger";
    
    /** 默认格式 */
    public String PATTERN_DEFAULT          = "%d [%t] %l - %m%n";
    
    /******************************************************************/
    //日志等级相关常量
    /******************************************************************/
    
    //日志等级
    public int UNKNOWN                     = 0;
    public int DEBUG                       = 1;
    public int INFO                        = 2;
    public int ERROR                       = 3;
    public int WARN                        = 4;
    public int FATAL                       = 5;
    
    //日志等级字符串
    public String UNKNOWN_STR              = "UNDNOWN";
    public String DEBUG_STR                = "DEBUG";
    public String INFO_STR                 = "INFO";
    public String ERROR_STR                = "ERROR";
    public String WARN_STR                 = "WARN";
    public String FATAL_STR                = "FATAL";
    
    /******************************************************************/
    //log4j日志器常量
    /******************************************************************/
    
    public String LOG4J_LOGGER_CLASS       = "org.apache.log4j.Logger";
    public String LOG4J_LOGGER_METHOD      = "getLogger";
    public String LOG4J_LOGGER_DEBUG       = "debug";
    public String LOG4J_LOGGER_INFO        = "info";
    public String LOG4J_LOGGER_ERROR       = "error";
    public String LOG4J_LOGGER_WARN        = "warn";
    public String LOG4J_LOGGER_FATAL       = "fatal";
    public String LOG4J_LOGGER_IS_DEBUG    = "isDebugEnabled";
    public String LOG4J_LOGGER_IS_INFO     = "isInfoEnabled";
    public String LOG4J_LOGGER_IS_ERROR    = "isErrorEnabled";
    public String LOG4J_LOGGER_IS_WARN     = "isWarnEnabled";
    public String LOG4J_LOGGER_IS_FATAL    = "isFatalEnabled";
}
