/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.json.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Map.Entry;

import org.zhiqim.kernel.extend.MapSS;
import org.zhiqim.kernel.json.Json;
import org.zhiqim.kernel.json.JsonParser;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.kernel.util.Validates;

/**
 * MapSS解析器
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class MapSSParser implements JsonParser
{
    
    @Override
    public JsonParser set(Json jsonMain)
    {
        return this;
    }
    
    @Override
    public String toString(Object obj)
    {
        MapSS map = (MapSS)obj;
        if (map.isEmpty())
            return "{}";
        
        StringBuilder strb = new StringBuilder("{");
        for (Entry<String, String> entry : map.entrySet())
        {
            String key = entry.getKey();
            String value = entry.getValue();
            strb.append("\"").append(key).append("\":\"").append(value).append("\"").append(",");
        }
        
        strb.setLength(strb.length() - 1);
        strb.append("}");
        return strb.toString();
    }

    @Override
    public Object toObject(String json, Class<?> cls)
    {
        MapSS map = Classes.newMapSS(cls);
        if (map == null)
        {//不支持的类型
            return null;
        }
        
        List<String> fieldList = toFieldList(json);
        for (String s : fieldList)
        {
            int ind = s.indexOf(":");
            String key = Jsons.removeStartEndQuotation(s.substring(0, ind));
            String value = s.substring(ind+1);
            
            if ("null".equals(value))
            {//对null进行判断
                map.put(key, null);
                continue;
            }
            
            if (Jsons.isStartEndQuotation(value))
            {//对前后的引号进行处理是字符串
                value = Jsons.removeStartEndQuotation(value);
            }
            
            //再对转义符进行处理
            value = Jsons.removeEscapeChar(value);
            map.put(key, value);
        }
        
        return map;
    }
    
    /** 折分成字符串数组 */
    public static List<String> toFieldList(String json)
    {
        if (Validates.isEmptyBlank(json))
            return new ArrayList<String>(0);
        
        if (!json.startsWith("{") || !json.endsWith("}"))
            return new ArrayList<String>(0);
        
        //去除{}
        json = json.substring(1, json.length()-1);
        return Jsons.getFieldList(json);
    }
}
