/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.httpclient;

import org.zhiqim.kernel.util.consts.Int;

/**
 * HTTP结果信息，用于把状态码和描述重新组装成一个对象返回
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class HttpResult
{
    private int responseStatus;
    private String responseText;
    
    private byte[] responseBytes;
    
    public HttpResult(int responseStatus, String responseText)
    {
        this.responseStatus = responseStatus;
        this.responseText = responseText;
    }

    public HttpResult(int responseStatus, String responseText, byte[] responseBytes)
    {
        this.responseStatus = responseStatus;
        this.responseText = responseText;
        this.responseBytes = responseBytes;
    }
    
    /** 获取状态码 */
    public int getResponseStatus()
    {
        return responseStatus;
    }

    /** 获取状态信息或响应内容 */
    public String getResponseText()
    {
        return responseText;
    }
    
    /** 获取状态信息或响应字节 */
    public byte[] getResponseBytes()
    {
        return responseBytes;
    }
    
    /** 获取指定的Int类型的调用结果 */
    public Int getResponseInt()
    {
        return new Int(responseStatus==200?0:responseStatus, responseText);
    }
    
    /** 判断是否成功 */
    public boolean isSuccess()
    {
        return responseStatus == 200;
    }
}
