/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.extend;

import java.util.Map;
import java.util.TreeMap;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnNew;

/**
 * 定义一个TreeMap<String, Object>参数和结果对象，但不要求<K, V>，比Map在ZML中new时不需要指定泛型
 *
 * @version v1.0.0 @author zouzhigang 2016-10-25 新建与整理
 */
@AnAlias("TreeMapSO")
@AnNew
public class TreeMapSO extends MapSO
{
    public TreeMapSO()
    {
        instance = new TreeMap<>();
    }
    
    public TreeMapSO(String key, Object value)
    {
        instance = new TreeMap<>();
        instance.put(key, value);
    }
    
    public TreeMapSO(Map<String, Object> instance)
    {
        this.instance = new TreeMap<>(instance);
    }
    
    public TreeMapSO(TreeMap<String, Object> instance)
    {
        this.instance = new TreeMap<>(instance);
    }
    
    public TreeMapSO(MapSO instance)
    {
        this.instance = new TreeMap<>(instance.instance());
    }
    
    public TreeMapSO(TreeMapSO instance)
    {
        this.instance = new TreeMap<>(instance.instance());
    }
}
