/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.control;

/**
 * 事件处理器，通过冒泡方式处理，以支持一个事件多个事件处理器顺序执行
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public interface Eventer<E>
{
    /**
     * 显性提供事件类接口，用于事件注册到控制器中
     * 
     * @return 返回事件类
     */
    public Class<E> clazz();
    
    /** 
     * 事件处理器接口 
     * 
     * @param event 事件
     * @return      返加处理状态，=true表示处理完成，向上冒泡，=false表示处理终止，停止冒泡
     */
    public boolean process(E event);
}
