/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.constants;

import org.zhiqim.kernel.annotation.AnAlias;

/**
 * 符号常量定义
 *
 * @version v1.0.0 @author zouzhigang 2014-2-27 新建与整理
 */
@AnAlias("SignConstants")
public interface SignConstants extends AsciiConstants
{
    /****************************************************************************/
    //ID定义，13/16/19位
    /****************************************************************************/
    
    /** 13位数字 */
    public long ID13                            = 1000000000000L;
    
    /** 16位数字 */
    public long ID16                            = ID13 * 1000;
    
    /** 19位数字 */
    public long ID19                            = ID16 * 1000;
    
    /****************************************************************************/
    //字节长度定义，注意KiB和KB的区别
    /****************************************************************************/
    
    /** 千字节（kibibyte） */
    public int KiB                              = 1024;
    
    /** 兆字节（mebibyte） */
    public int MiB                              = 1 << 20;
    
    /** 吉字节（gibibyte） */
    public int GiB                              = 1 << 30;
    
    /** 太字节（tebibyte） */
    public int TiB                              = 1 << 40;
    
    /** pebibyte */
    public int PiB                              = 1 << 50;
    
    /** exbibyte */
    public int EiB                              = 1 << 60;
    
    /** zebibyte */
    public int ZiB                              = 1 << 70;
    
    /** yobibyte */
    public int YiB                              = 1 << 80;
    
    /** 千字节（kilobyte） */
    public int KB                               = 1000;
    
    /** 百万字节（megabyte） */
    public int MB                               = KB * 1000;
    
    /** 十亿字节（gigabyte） */
    public int GB                               = MB * 1000;
    
    /** 万亿字节（terabyte） */
    public int TB                               = GB * 1000;
    
    /** 千万亿字节（petabyte） */
    public int PB                               = TB * 1000;
    
    /** 百亿亿字节（exabyte） */
    public int EB                               = PB * 1000;
    
    /** 十万亿亿字节（zettabyte） */
    public int ZB                               = EB * 1000;
    
    /** 亿亿亿字节（yottabyte） */
    public int YB                               = ZB * 1000;
    
    /** 无究数（-1） */
    public int INFINITE                         = -1;
    
    /****************************************************************************/
    //常用字符串定义
    /****************************************************************************/
    
    /** true字符串 */
    public String _TRUE_                        = "true";
    
    /** false字符串 */
    public String _FALSE_                       = "false";
    
    /** 空字符串 */
    public String _EMPTY_                       = "";
    
    /** 一个空格字符串，也可以直接使用_SPACE_ */
    public String _ONE_                         = " ";
    
    /** 双空格字符串 */
    public String _TWO_                         = "  ";
    
    /** 四空格字符串 */
    public String _FOUR_                        = "    ";
    
    /** 制表符 */
    public String _TAB_                         = "\t";
    
    /** 回车符 */
    public String _LR_                          = "\r";
    
    /** 换行符 */
    public String _LN_                          = "\n";
    
    /** 回车换行 */
    public String _BR_                          = "\r\n";
    
    /** 只读 */
    public String _RO_                          = "r";
    
    /** 读写 */
    public String _RW_                          = "rw";
    
    /** ID */
    public String _ID_                          = "id";
    
    /** 名称 */
    public String _NAME_                        = "name";
    
    /** 键 */
    public String _KEY_                         = "key";
    
    /** 字段 */
    public String _FIELD_                       = "field";
    
    /** 值 */
    public String _VALUE_                       = "value";
    
    /** 类型 */
    public String _TYPE_                        = "type";
    
    /** 页 */
    public String _PAGE_                        = "page";
    
    /** 版本 */
    public String _VERSION_                     = "version";
    
    /** 类 */
    public String _CLASS_                       = "class";
    
    /** 类路径 */
    public String _CLASSPATH_                   = "classpath";
    
    /** 目录 */
    public String _DIRECTORY_                   = "directory";
    
    /** 源 */
    public String _SRC_                         = "src";
    
    /** 目标 */
    public String _DST_                         = "dst";
    
    /** 编码 */
    public String _ENCODING_                    = "encoding";
    
    /** 字符集 */
    public String _CHARSET_                     = "charset";
    
    /** 输入 */
    public String _INPUT_                       = "input";
    
    /** 输出 */
    public String _OUTPUT_                      = "output";
    
    /** 常用的PNG类型 */
    public String _PNG_                         = "png";
    
    /** 公开 */
    public String _PUBLIC_                      = "public";
    
    /** 保护 */
    public String _PROTECTED_                   = "protected";
    
    /** 私有 */
    public String _PRIVATE_                     = "private";
    
    /** 整型 */
    public String _INT_                         = "int";
    
    /** 长整型 */
    public String _LONG_                        = "long";
    
    /** 浮点型 */
    public String _FLOAT_                       = "float";
    
    /** 双点型 */
    public String _DOUBLE_                      = "double";
    
    /** 间隔 */
    public String _INTERVAL_                    = "Interval";
    
    /** Socket关闭 */
    public String _SOCKET_CLOSED_               = "Socket closed";
    
    /****************************************************************************/
    //常用字符组合定义
    /****************************************************************************/
    
    /** 数字 */
    public String _DIGITS_                      = "0123456789";
    
    /** 十六进制数字 */
    public String _DIGITS_HEX_                  = "0123456789abcdefABCDEF";
    
    /** 小写字母 */
    public String _LETTERS_LOWERCASE_           = "abcdefghijklmnopqrstuvwxyz";
    
    /**  小写字母+数字 */
    public String _LETTERS_LOWERCASE_DIGITS_   = "0123456789abcdefghijklmnopqrstuvwxyz";

    /** 大写字母 */
    public String _LETTERS_UPPERCASE_          = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";

    /** 大写字母+数字 */
    public String _LETTERS_UPPERCASE_DIGITS_   = _LETTERS_UPPERCASE_ + _DIGITS_;
    
    /** 全部字母 */
    public String _LETTERS_                    = _LETTERS_UPPERCASE_ + _LETTERS_LOWERCASE_;

    /** 全部字母数字 */
    public String _LETTERS_DIGITS_             = _LETTERS_ + _DIGITS_;
    
    /** 电话号码里允许的不是数字的chars ,两边括号,横线,空格*/
    public String _PHONE_NUMBER_DELIMITERS_    = "+()- ";
    
    /** 全球电话号码允许"+"号的chars*/
    public String _PHONE_NUMBER_CHARS          = _PHONE_NUMBER_DELIMITERS_ + _DIGITS_;
    
    /** 常用于账号和密码的9个特殊字符 */
    public String _SYMBOL_F_                   = ".`_~!@#$%";
    
    /****************************************************************************/
    //常用数组定义，更多的定义在EnumConstants中
    /****************************************************************************/
    
    /** 空字节数组 */
    public byte[] _EMPTY_B_                    = {};
    
    /** 空整型数组 */
    public int[] _EMPTY_I_                     = {};
    
    /** 空整型数组 */
    public long[] _EMPTY_L_                    = {};
    
    /** 空字符串数组 */
    public String[] _EMPTY_S_                  = {};
    
    /** 回车换行字节数组 */
    public byte[] _CRLF_                       = {_CR_, _LF_};
}
