/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel;

/**
 * 服务抽象类是采用适配器模式，对服务接口的一种抽象实现（部分实现和缺省实现），使得子类更容易编写
 * 1、实现了setId,getId,setIndex,getIndex方法，子类无需重写，可以直接调用
 * 2、提供缺省的destory,test,update的方法，子类可选重写
 * 3、子类必须实现create方法。 
 * 
 * @see Service
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public abstract class Servicer extends MultiInstancer implements Service
{
    protected String id;
    
    /*********************************************************/
    //服务编号
    /*********************************************************/
    
    /** 设置服务编号,对应conf/zhiqim.xml/service/key */
    public final void setId(String id)
    {
        this.id = id;
    }

    /** 获取服务编号 */
    public final String getId()
    {
        return id;
    }
    
    /*********************************************************/
    //服务创建和销毁
    /*********************************************************/
    
    /**
     * 服务创建接口，配置信息从Global中读取，子类必须实现
     * 
     * @return boolean =true,启动成功,=false,启动失败
     * @throws Exception Startup捕捉,打印日志,作失败处理
     */
    public abstract boolean create() throws Exception;

    /**
     * 服务销毁接口，配置信息从Global中读取，默认不处理，子类可选重写
     * 
     * @throws Exception Hook捕捉,打印日志,异常不处理，直接退出
     */
    public void destroy() throws Exception
    {
    }
    
    /*********************************************************/
    //更新和测试更新配置
    /*********************************************************/
    
    /**
     * 测试更新配置，默认支持更新配置
     * 
     * @return              =true表示可以更新，=false表示更新可能有问题
     * @throws Exception    异常时表示不可更新
     */
    public boolean test() throws Exception
    {
        return false;
    }
    
    /**
     * 服务更新配置，默认不处理更新配置
     * 
     * @throws Exception 出现更新异常通知配置端
     */
    public void update() throws Exception
    {
    }
}
