/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.zml.statement;

import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.zml.Expression;
import org.zhiqim.zml.ExpressionParser;
import org.zhiqim.zml.Statement;
import org.zhiqim.zml.ZmlVariable;
import org.zhiqim.zml.exception.ExpressionException;
import org.zhiqim.zml.exception.StatementException;

public class _Return
extends Statement {
    private Expression expression;

    @Override
    public boolean isNesting() {
        return false;
    }

    @Override
    public void parseStatement() throws StatementException {
        String s = Strings.trim((String)this.getStatement(), (String)"<#return", (String)"/>");
        if (Validates.isEmptyBlank((String)s)) {
            return;
        }
        try {
            this.expression = ExpressionParser.parseExpression(s);
        }
        catch (ExpressionException e) {
            throw new StatementException(this, "<#return>" + e.getMessage());
        }
    }

    @Override
    public String process(ZmlVariable variableMap) throws StatementException {
        return null;
    }

    public Object build(ZmlVariable variableMap) throws StatementException {
        try {
            return this.expression == null ? null : this.expression.build(variableMap);
        }
        catch (Exception e) {
            throw new StatementException(this, "@{}" + e.getMessage(), e);
        }
    }

    public static class ReturnException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private Object value = null;

        public ReturnException() {
        }

        public ReturnException(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean hasValue() {
            return this.value != null;
        }
    }
}

