/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.zml.loader;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.List;
import org.zhiqim.kernel.extend.HashMapSV;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.kernel.util.Watchs;
import org.zhiqim.zml.ZmlConstants;
import org.zhiqim.zml.ZmlEngine;

public class FileZmlWatcher
extends Thread
implements ZmlConstants {
    private static final Log log = LogFactory.getLog(FileZmlWatcher.class);
    private boolean isRunning;
    private final ZmlEngine engine;
    private final String pathPrefix;
    private final HashMapSV<Long> fileMap;
    private final HashMapSV<WatchKey> dirMap;
    private final HashMap<WatchKey, String> keyMap;
    private final WatchService watcher;

    public FileZmlWatcher(ZmlEngine engine, String rootPath) {
        this.engine = engine;
        this.pathPrefix = rootPath;
        this.fileMap = new HashMapSV();
        this.dirMap = new HashMapSV();
        this.keyMap = new HashMap();
        this.watcher = Watchs.getWatchService();
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastModified(String path) {
        if (this.fileMap.containsKey(path)) {
            return (Long)this.fileMap.get(path);
        }
        String dirPath = Files.getFileDirPath((String)path, (String)"/");
        File dir = new File(String.valueOf(this.pathPrefix) + dirPath);
        if (!(dir.exists() && dir.isDirectory() && dir.canRead())) {
            WatchKey key = (WatchKey)this.dirMap.get(dirPath);
            if (key != null) {
                this.keyMap.remove(key);
                this.dirMap.remove(dirPath);
                key.cancel();
                key = null;
            }
            this.fileMap.remove(path);
            return -1L;
        }
        File file = new File(String.valueOf(this.pathPrefix) + path);
        if (!(file.exists() && file.isFile() && file.canRead())) {
            this.fileMap.remove(path);
            return -1L;
        }
        if (!this.dirMap.containsKey(dirPath)) {
            HashMapSV<WatchKey> hashMapSV = this.dirMap;
            synchronized (hashMapSV) {
                if (!this.dirMap.containsKey(dirPath)) {
                    try {
                        Path dPath = dir.toPath();
                        WatchKey key = dPath.register(this.watcher, StandardWatchEventKinds.ENTRY_MODIFY);
                        this.dirMap.put(dirPath, (Object)key);
                        this.keyMap.put(key, dirPath);
                    }
                    catch (IOException e) {
                        log.error((Object)"\u76d1\u89c6\u6587\u4ef6\u5939\u7ebf\u7a0b\u6dfb\u52a0\u76d1\u89c6\u65f6\u5f02\u5e38", (Throwable)e, new Object[0]);
                    }
                }
            }
        }
        long fileModified = file.lastModified();
        this.fileMap.put(path, (Object)fileModified);
        return fileModified;
    }

    @Override
    public void run() {
        this.isRunning = true;
        while (this.isRunning) {
            try {
                WatchKey key = this.watcher.take();
                String dirPath = this.keyMap.get(key);
                List<WatchEvent<?>> eventList = key.pollEvents();
                for (WatchEvent<?> event : eventList) {
                    Path path = (Path)event.context();
                    String fileName = path.toFile().getName();
                    String filePath = String.valueOf(dirPath) + "/" + fileName;
                    if (!Validates.isMatch((String)filePath, (String[])this.engine.getPatterns())) continue;
                    File file = new File(String.valueOf(this.pathPrefix) + filePath);
                    if (!file.exists()) {
                        this.fileMap.remove(filePath);
                        continue;
                    }
                    this.fileMap.put(filePath, (Object)file.lastModified());
                }
                if (key.reset()) continue;
                this.keyMap.remove(key);
                this.dirMap.remove(dirPath);
                key.cancel();
            }
            catch (InterruptedException e) {
                log.error((Object)"\u76d1\u89c6\u6587\u4ef6\u5939\u7ebf\u7a0b\u88ab\u4e2d\u65ad\uff0c\u9000\u51fa", (Throwable)e, new Object[0]);
                this.isRunning = false;
            }
        }
    }
}

