/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.zml.expression.primitive;

import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.annotation.AnGlobal;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.zml.ZmlEngine;
import org.zhiqim.zml.ZmlVariable;
import org.zhiqim.zml.exception.ExpressionException;
import org.zhiqim.zml.exception.PropertNotExistException;
import org.zhiqim.zml.expression.Primitive;
import org.zhiqim.zml.expression.operator._Property;

public class _Variable
extends Primitive {
    private String value;
    private Class<?> cls;

    public _Variable(String value) {
        this.value = value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public Object build(ZmlVariable variableMap) throws ExpressionException {
        Object instance = variableMap.get(this.value);
        if (instance != null) {
            return instance;
        }
        Class cls = ZmlEngine.getJavaClass(this.value);
        if (cls != null) {
            this.cls = cls;
            return null;
        }
        cls = Global.getClass((String)this.value);
        if (cls != null) {
            return this.returnAliasInstance(cls);
        }
        int lastIndex = this.value.lastIndexOf(".");
        if (lastIndex != -1) {
            String name = this.value.substring(0, lastIndex);
            String prop = this.value.substring(lastIndex + 1);
            try {
                return new _Property(name, prop).build(variableMap);
            }
            catch (PropertNotExistException propertNotExistException) {}
        }
        if ((cls = Classes.forName((String)this.value)) != null) {
            return this.returnAliasInstance(cls);
        }
        return null;
    }

    public Class<?> buildClass() {
        return this.cls;
    }

    private Object returnAliasInstance(Class<?> cls) {
        if (cls.isAnnotationPresent(AnGlobal.class)) {
            return Global.getWithoutNew(cls);
        }
        this.cls = cls;
        return null;
    }

    @Override
    public String toString() {
        return this.value;
    }

    public String getValue() {
        return this.value;
    }
}

