/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.zml.expression.operator;

import org.zhiqim.kernel.util.Types;
import org.zhiqim.zml.Expression;
import org.zhiqim.zml.ZmlVariable;
import org.zhiqim.zml.exception.ExpressionException;
import org.zhiqim.zml.expression.Operator;

public class _Division
extends Operator {
    private final Expression left;
    private final Expression right;

    public _Division(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public int getType() {
        return 470;
    }

    @Override
    public Object build(ZmlVariable variableMap) throws ExpressionException {
        Object privous = this.left.build(variableMap);
        Object next = this.right.build(variableMap);
        if (!Types.isNumber((Object)privous) || !Types.isNumber((Object)next)) {
            throw new ExpressionException("\u9664\u6cd5\u8868\u8fbe\u5f0f{" + this + "}\uff0c\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u9664\u6570\u6216\u88ab\u9664\u6570\u4e0d\u662f\u6570\u503c\u578b");
        }
        Number dividend = (Number)privous;
        Number divisor = (Number)next;
        if (Types.isInteger((Object)privous)) {
            if (Types.isInteger((Object)next)) {
                return dividend.longValue() / divisor.longValue();
            }
            return (double)dividend.longValue() / divisor.doubleValue();
        }
        if (Types.isInteger((Object)next)) {
            return dividend.doubleValue() / (double)divisor.longValue();
        }
        return dividend.doubleValue() / divisor.doubleValue();
    }

    @Override
    public String toString() {
        return this.left + " / " + this.right;
    }
}

