/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.zml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.extend.LinkedMapSV;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.zml.StatementParser;
import org.zhiqim.zml.Zml;
import org.zhiqim.zml.ZmlConstants;
import org.zhiqim.zml.ZmlLoader;
import org.zhiqim.zml.ZmlPredefinded;
import org.zhiqim.zml.ZmlVarNotice;
import org.zhiqim.zml.ZmlVariable;
import org.zhiqim.zml.loader.ClassZmlLoader;
import org.zhiqim.zml.loader.FileZmlLoader;
import org.zhiqim.zml.statement._Function;
import org.zhiqim.zml.statement._Include;
import org.zhiqim.zml.statement._Var;

public class ZmlEngine
extends ZmlPredefinded
implements ZmlConstants {
    private ZmlVarNotice notice;
    private String encoding;
    private int maxIdleTime;
    private int maxKeepTime;
    private boolean isAscQuery;
    private String[] patterns;
    private ZmlLoader loader;
    private final LinkedMapSV<ZmlLoader> cLoaderMap;
    private final HashMapSO globalMap;
    private final LinkedHashMap<ConfigKey, Long> fileMap;
    private final LinkedHashMap<ConfigKey, LinkedMapSV<_Function>> functionMap;
    private final LinkedHashMap<ConfigKey, LinkedMapSV<_Var>> variableMap;

    public ZmlEngine() {
        this("UTF-8");
    }

    public ZmlEngine(String encoding) {
        this.encoding = encoding;
        this.patterns = ZML_PATTERN_DEFAULT;
        this.cLoaderMap = new LinkedMapSV();
        this.globalMap = new HashMapSO();
        this.fileMap = new LinkedHashMap();
        this.functionMap = new LinkedHashMap();
        this.variableMap = new LinkedHashMap();
    }

    public void setZmlVarNotice(ZmlVarNotice notice) {
        this.notice = notice;
    }

    public void setAscQuery(boolean isAscQuery) {
        this.isAscQuery = isAscQuery;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public void setMaxKeepTime(int maxKeepTime) {
        this.maxKeepTime = maxKeepTime;
    }

    public void setPatterns(String[] patterns) {
        this.patterns = patterns;
    }

    public void setPatterns(String patterns) {
        this.patterns = Arrays.toStringArray((String)patterns);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public int getMaxKeepTime() {
        return this.maxKeepTime;
    }

    public String[] getPatterns() {
        return this.patterns;
    }

    public void setZmlLoader(ZmlLoader loader) {
        this.loader = loader;
    }

    public void setClassZmlLoader(Class<?> clazz, String pathPrefix) {
        this.loader = new ClassZmlLoader(this, clazz, pathPrefix);
    }

    public void setFileZmlLoader(File dir) throws IOException {
        this.loader = new FileZmlLoader(this, dir.getCanonicalPath());
    }

    public void addComponentZmlLoader(Class<?> clazz, String pathPrefix) {
        this.cLoaderMap.put(pathPrefix, (Object)new ClassZmlLoader(this, clazz, pathPrefix));
    }

    public void addComponentZmlLoader(String componentPath, ZmlLoader loader) {
        this.cLoaderMap.put(componentPath, (Object)loader);
    }

    public ZmlLoader getLoader(ConfigKey ck) {
        return this.getLoader(ck.configPath, ck.componentPath);
    }

    public ZmlLoader getLoader(String contextPath, String componentPath) {
        return componentPath == null ? this.loader : (ZmlLoader)this.cLoaderMap.get(componentPath);
    }

    public void addGlobalVariable(String name, Object obj) {
        this.globalMap.put(name, obj);
    }

    public Object getGlobalVariable(String key) {
        return this.globalMap.get(key);
    }

    public HashMapSO getGlobalMap() {
        return this.globalMap;
    }

    public void addConfigZml(String configPath) {
        Asserts.as((String)(this.loader != null ? null : "\u672a\u8bbe\u7f6e\u52a0\u8f7d\u5668\u4e0a\u4e0d\u652f\u6301\u6dfb\u52a0\u4e0a\u4e0b\u6587\u914d\u7f6eZML"));
        this.loadConfigZml(new ConfigKey(configPath, null));
    }

    public void addConfigZml(String configPath, String componentPath) {
        Asserts.as((String)(this.cLoaderMap.containsKey(componentPath) ? null : "\u672a\u8bbe\u7f6e\u8be5\u7ec4\u4ef6\u52a0\u8f7d\u5668\u4e0a\u4e0d\u652f\u6301\u6dfb\u52a0\u7ec4\u4ef6\u4e0a\u4e0b\u6587\u914d\u7f6eZML"));
        this.loadConfigZml(new ConfigKey(configPath, componentPath));
    }

    public void chkCurConfigModified() {
        for (Map.Entry<ConfigKey, Long> entry : this.fileMap.entrySet()) {
            if (entry.getKey().componentPath != null) continue;
            try {
                long lastModified = this.getConfigLastModified(entry.getKey());
                if (lastModified == entry.getValue()) continue;
                this.loadConfigZml(entry.getKey());
            }
            catch (Exception e) {
                throw Asserts.exception((String)("\u52a0\u8f7d\u4e0a\u4e0b\u6587ZML[" + entry.getKey().configPath + "]\u5f02\u5e38"), (Exception)e);
            }
        }
    }

    private void chkAllConfigModified() {
        for (Map.Entry<ConfigKey, Long> entry : this.fileMap.entrySet()) {
            try {
                long lastModified = this.getConfigLastModified(entry.getKey());
                if (lastModified == entry.getValue()) continue;
                this.loadConfigZml(entry.getKey());
            }
            catch (Exception e) {
                throw Asserts.exception((String)("\u52a0\u8f7d\u4e0a\u4e0b\u6587ZML[" + entry.getKey().configPath + "]\u5f02\u5e38"), (Exception)e);
            }
        }
    }

    private long getConfigLastModified(ConfigKey ck) throws Exception {
        ZmlLoader loader = this.getLoader(ck);
        return loader.getLastModified(ck.configPath);
    }

    public LinkedMapSV<_Function> getFunctionMap(String contextPath, String componentPath) {
        return this.functionMap.get(new ConfigKey(contextPath, componentPath));
    }

    public LinkedMapSV<_Var> getVarMap(String contextPath, String componentPath) {
        return this.variableMap.get(new ConfigKey(contextPath, componentPath));
    }

    public _Function getFunction(String name) throws Exception {
        if (this.loader == null) {
            throw new Exception("\u672a\u5b9a\u4e49\u52a0\u8f7d\u5668\uff0c\u4e0d\u652f\u6301\u83b7\u53d6\u51fd\u6570\u8c03\u7528");
        }
        this.chkAllConfigModified();
        if (this.isAscQuery) {
            for (LinkedMapSV<_Function> fMap : this.functionMap.values()) {
                _Function _function = (_Function)fMap.get(name);
                if (_function == null) continue;
                return _function;
            }
        } else {
            _Function _function = null;
            for (LinkedMapSV<_Function> fMap : this.functionMap.values()) {
                if (!fMap.containsKey(name)) continue;
                _function = (_Function)fMap.get(name);
            }
            if (_function != null) {
                return _function;
            }
        }
        throw new Exception("\u52a0\u8f7d\u4e0a\u4e0b\u6587ZML\u5931\u8d25\uff0c\u4e0d\u652f\u6301\u83b7\u53d6\u51fd\u6570");
    }

    public _Var getVar(String name) {
        if (this.loader == null) {
            return null;
        }
        this.chkAllConfigModified();
        if (this.isAscQuery) {
            for (LinkedMapSV<_Var> vMap : this.variableMap.values()) {
                _Var _var = (_Var)vMap.get(name);
                if (_var == null) continue;
                return _var;
            }
        } else {
            _Var _var = null;
            for (LinkedMapSV<_Var> vMap : this.variableMap.values()) {
                if (!vMap.containsKey(name)) continue;
                _var = (_Var)vMap.get(name);
            }
            if (_var != null) {
                return _var;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasZml(String path) {
        Asserts.as((String)(this.loader != null ? null : "\u672a\u8bbe\u7f6e\u52a0\u8f7d\u5668\u4e0a\u4e0d\u652f\u6301\u589e\u901a\u8fc7\u5f15\u64ce\u83b7\u53d6ZML"));
        try {
            if (this.loader.hasZml(path)) {
                return true;
            }
            ArrayList list = new ArrayList(this.cLoaderMap.values());
            int i = list.size() - 1;
            while (true) {
                if (i < 0) {
                    return false;
                }
                ZmlLoader ld = (ZmlLoader)list.get(i);
                if (ld.hasZml(path)) {
                    return true;
                }
                --i;
            }
        }
        catch (Exception e) {
            throw Asserts.exception((String)("\u52a0\u8f7dZML\u6587\u4ef6[" + path + "]\u5f02\u5e38"), (Exception)e);
        }
    }

    public ZmlLoader getZmlLoader(String path) {
        Asserts.as((String)(this.loader != null ? null : "\u672a\u8bbe\u7f6e\u52a0\u8f7d\u5668\u4e0a\u4e0d\u652f\u6301\u589e\u901a\u8fc7\u5f15\u64ce\u83b7\u53d6ZML"));
        try {
            if (this.loader.hasZml(path)) {
                return this.loader;
            }
            ArrayList list = new ArrayList(this.cLoaderMap.values());
            int i = list.size() - 1;
            while (i >= 0) {
                ZmlLoader ld = (ZmlLoader)list.get(i);
                if (ld.hasZml(path)) {
                    return ld;
                }
                --i;
            }
            return null;
        }
        catch (Exception e) {
            throw Asserts.exception((String)("\u52a0\u8f7dZML\u6587\u4ef6[" + path + "]\u5f02\u5e38"), (Exception)e);
        }
    }

    public Zml getZml(String path) throws FileNotFoundException {
        Asserts.as((String)(this.loader != null ? null : "\u672a\u8bbe\u7f6e\u52a0\u8f7d\u5668\u4e0a\u4e0d\u652f\u6301\u589e\u901a\u8fc7\u5f15\u64ce\u83b7\u53d6ZML"));
        try {
            Zml zml = this.loader.loadZml(path);
            if (zml != null) {
                return zml;
            }
            ArrayList list = new ArrayList(this.cLoaderMap.values());
            int i = list.size() - 1;
            while (i >= 0) {
                ZmlLoader ld = (ZmlLoader)list.get(i);
                zml = ld.loadZml(path);
                if (zml != null) {
                    return zml;
                }
                --i;
            }
        }
        catch (Exception e) {
            throw Asserts.exception((String)("\u52a0\u8f7dZML\u6587\u4ef6[" + path + "]\u5f02\u5e38"), (Exception)e);
        }
        throw Asserts.notFound((String)("\u672a\u627e\u5230ZML\u6587\u4ef6[" + path + "]"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfigZml(ConfigKey mk) {
        String configPath = mk.configPath;
        String componentPath = mk.componentPath;
        Zml zml = null;
        try {
            ZmlLoader theLoader = componentPath == null ? this.loader : (ZmlLoader)this.cLoaderMap.get(componentPath);
            zml = theLoader.loadZml(configPath);
            if (zml == null) {
                return;
            }
            this.fileMap.put(mk, zml.getLastModified());
        }
        catch (Exception e) {
            throw Asserts.exception((String)("\u52a0\u8f7d\u4e0a\u4e0b\u6587ZML[" + configPath + "]\u5f02\u5e38"), (Exception)e);
        }
        ArrayList<_Function> funcList = new ArrayList<_Function>();
        ArrayList<_Var> varList = new ArrayList<_Var>();
        ArrayList<_Include> includeList = new ArrayList<_Include>();
        try {
            StatementParser.parseContextZml(zml, funcList, varList, includeList);
        }
        catch (Exception e) {
            throw Asserts.exception((String)("\u52a0\u8f7d\u4e0a\u4e0b\u6587ZML[" + configPath + "]\u5f02\u5e38"), (Exception)e);
        }
        LinkedMapSV funcMap = null;
        LinkedMapSV linkedMapSV = this.functionMap;
        synchronized (linkedMapSV) {
            LinkedMapSV fMap = this.functionMap.get(mk);
            if (fMap == null) {
                fMap = new LinkedMapSV();
                this.functionMap.put(mk, (LinkedMapSV<_Function>)fMap);
            }
            funcMap = fMap;
        }
        linkedMapSV = funcMap;
        synchronized (linkedMapSV) {
            try {
                funcMap.clear();
                for (_Function func : funcList) {
                    String name = func.getName();
                    if (funcMap.containsKey(name)) {
                        throw Asserts.exception((String)("\u627e\u5230\u4e0a\u4e0b\u6587ZML\u6587\u4ef6[" + configPath + "]\u4e2d\u5168\u5c40\u51fd\u6570[" + name + "]\u6709\u91cd\u590d"));
                    }
                    funcMap.put(name, (Object)func);
                }
            }
            catch (Exception e) {
                throw Asserts.exception((String)("\u52a0\u8f7d\u4e0a\u4e0b\u6587ZML[" + configPath + "]\u5f02\u5e38"), (Exception)e);
            }
        }
        LinkedMapSV varMap = null;
        LinkedMapSV e = this.variableMap;
        synchronized (e) {
            LinkedMapSV vMap = this.variableMap.get(mk);
            if (vMap == null) {
                vMap = new LinkedMapSV();
                this.variableMap.put(mk, (LinkedMapSV<_Var>)vMap);
            }
            varMap = vMap;
        }
        e = varMap;
        synchronized (e) {
            try {
                varMap.clear();
                for (_Var var : varList) {
                    String name = var.getVariableName();
                    if (varMap.containsKey(name)) {
                        throw Asserts.exception((String)("\u627e\u5230\u4e0a\u4e0b\u6587ZML\u6587\u4ef6[" + configPath + "]\u4e2d\u5168\u5c40\u53d8\u91cf[" + name + "]\u6709\u91cd\u590d"));
                    }
                    varMap.put(name, (Object)var);
                }
                if (this.notice != null) {
                    this.notice.doUpdateVariable(zml, configPath, componentPath, (LinkedMapSV<_Var>)varMap);
                }
            }
            catch (Exception e2) {
                throw Asserts.exception((String)("\u52a0\u8f7d\u4e0a\u4e0b\u6587ZML[" + configPath + "]\u5f02\u5e38"), (Exception)e2);
            }
        }
        try {
            ZmlVariable variable = new ZmlVariable();
            for (_Include include : includeList) {
                String path = include.getIncludePath(variable);
                this.loadConfigZml(new ConfigKey(path, componentPath));
            }
        }
        catch (Exception e2) {
            throw Asserts.exception((String)("\u52a0\u8f7d\u4e0a\u4e0b\u6587ZML[" + configPath + "]\u5f02\u5e38"), (Exception)e2);
        }
    }

    private class ConfigKey {
        private String configPath;
        private String componentPath;

        public ConfigKey(String contextPath, String componentPath) {
            this.configPath = contextPath;
            this.componentPath = componentPath;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.componentPath == null ? 0 : this.componentPath.hashCode());
            result = 31 * result + (this.configPath == null ? 0 : this.configPath.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConfigKey other = (ConfigKey)obj;
            if (this.componentPath == null ? other.componentPath != null : !this.componentPath.equals(other.componentPath)) {
                return false;
            }
            return !(this.configPath == null ? other.configPath != null : !this.configPath.equals(other.configPath));
        }
    }
}

