/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.zml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import org.zhiqim.kernel.constants.SignConstants;
import org.zhiqim.kernel.extend.MapS;
import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.zml.Statement;
import org.zhiqim.zml.StatementNesting;
import org.zhiqim.zml.StatementParser;
import org.zhiqim.zml.ZmlEngine;
import org.zhiqim.zml.ZmlLineIndex;
import org.zhiqim.zml.ZmlVariable;
import org.zhiqim.zml.exception.StatementException;
import org.zhiqim.zml.statement._Define;
import org.zhiqim.zml.statement._Function;
import org.zhiqim.zml.statement._Include;
import org.zhiqim.zml.statement._Return;

public class Zml
implements StatementNesting,
SignConstants {
    private ZmlEngine engine;
    private Zml parent;
    private String path;
    private long lastModified;
    private String content;
    private boolean isParsed;
    private List<Statement> stmtList;
    private List<ZmlLineIndex> indexList;
    private long lastAccessed;

    public Zml(String content) {
        this(null, null, 0L, content);
    }

    public Zml(ZmlEngine engine, String content) {
        this(engine, null, 0L, content);
    }

    public Zml(ZmlEngine engine, String path, long lastModified, String content) {
        this.engine = engine;
        this.path = path;
        this.lastModified = lastModified;
        this.content = content;
        this.lastAccessed = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ZmlLineIndex> getIndexList() {
        if (this.indexList != null) {
            return this.indexList;
        }
        Zml zml = this;
        synchronized (zml) {
            if (this.indexList == null) {
                this.indexList = StatementParser.getIndexList(this.content);
            }
        }
        return this.indexList;
    }

    public void parse() throws StatementException {
        this.stmtList = StatementParser.parseStatementNesting(this);
        this.isParsed = true;
        this.content = null;
    }

    public void define(ZmlVariable variableMap) throws StatementException {
        if (!this.isParsed) {
            this.parse();
        }
        for (Statement statement : this.stmtList) {
            if (statement instanceof _Define) {
                ((_Define)statement).define(variableMap);
                continue;
            }
            if (!(statement instanceof _Include)) continue;
            ((_Include)statement).define(variableMap);
        }
    }

    public String process(ZmlVariable variableMap, Zml parent) throws StatementException {
        this.parent = parent;
        return this.process(variableMap);
    }

    public void process(OutputStream out, String encoding, MapSO pageVariableMap, MapS ... contextVariableMap) throws StatementException, IOException {
        ZmlVariable variableMap = new ZmlVariable();
        variableMap.setZml(this);
        variableMap.setVariableMap(pageVariableMap);
        variableMap.setContextMap(contextVariableMap);
        out.write(this.process(variableMap).getBytes(encoding));
    }

    public void process(Writer writer, MapSO pageVariableMap, MapS ... contextVariableMap) throws StatementException, IOException {
        ZmlVariable variableMap = new ZmlVariable();
        variableMap.setZml(this);
        variableMap.setVariableMap(pageVariableMap);
        variableMap.setContextMap(contextVariableMap);
        writer.write(this.process(variableMap));
    }

    private String process(ZmlVariable variableMap) throws StatementException {
        if (!this.isParsed) {
            this.parse();
        }
        this.define(variableMap);
        StringBuilder strb = new StringBuilder();
        try {
            StatementParser.processStatementList(this.stmtList, variableMap, strb);
            return strb.toString();
        }
        catch (_Return.ReturnException e) {
            return e.hasValue() ? String.valueOf(e.getValue()) : strb.toString();
        }
    }

    @Override
    public String getPrevStatement(Statement stmt) throws StatementException {
        List<Statement> statementList = this.getStatementList();
        int ind = statementList.indexOf(stmt);
        if (ind <= 0) {
            return null;
        }
        return statementList.get(ind - 1).getStatement();
    }

    @Override
    public String getNextStatement(Statement stmt) throws StatementException {
        List<Statement> statementList = this.getStatementList();
        int ind = statementList.indexOf(stmt);
        if (ind == -1 || ind >= statementList.size() - 1) {
            return null;
        }
        return statementList.get(ind + 1).getStatement();
    }

    public ZmlEngine getEngine() {
        return this.engine;
    }

    public List<Statement> getStatementList() throws StatementException {
        if (!this.isParsed) {
            this.parse();
        }
        return this.stmtList;
    }

    public _Function getFunction(String name) throws StatementException {
        for (Statement stmt : this.getStatementList()) {
            _Function function;
            if (!(stmt instanceof _Function) || !(function = (_Function)stmt).getName().equals(name)) continue;
            return function;
        }
        return null;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public long getLastAccessed() {
        return this.lastAccessed;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setLastAccessed() {
        this.lastAccessed = System.currentTimeMillis();
    }

    @Override
    public Zml getZml() {
        return this;
    }

    @Override
    public int getContentBeginIndex() {
        return 0;
    }
}

