/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.orm.dbo;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnNew;
import org.zhiqim.kernel.extend.HashMapSV;
import org.zhiqim.kernel.extend.LinkedMapSS;
import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Lists;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.orm.ORMException;
import org.zhiqim.orm.ZTable;
import org.zhiqim.orm.dbo.Condition;
import org.zhiqim.orm.dbo.Conditioner;
import org.zhiqim.orm.dbo.Dbo;
import org.zhiqim.orm.dbo.defined._Table;

@AnAlias(value={"Selector"})
@AnNew
public class Selector
extends Conditioner<Selector> {
    private static final long serialVersionUID = 1L;
    private static final String FIELD_FORMAT = " ,_ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz";
    private String fields = null;
    private String groupby = null;
    private LinkedMapSS orderbyMap = null;
    private HashMapSV<Selector> joinMap = null;

    public Selector() {
    }

    public Selector(String fields) {
        this.addFields(fields);
    }

    public Selector(String field, Object value) {
        this.addMust(field, value);
    }

    public Selector(String fields, String field, Object value) {
        this.addFields(fields);
        this.addMust(field, value);
    }

    public Selector(Condition condition) {
        this.addCondition(condition);
    }

    public Selector addFields(String fields) {
        if (!Validates.isScope((String)fields, (String)FIELD_FORMAT)) {
            return this;
        }
        fields = fields.trim();
        fields = Strings.trimLeft((String)fields, (String)",");
        if (Validates.isEmptyBlank((String)(fields = Strings.trimRight((String)fields, (String)",")))) {
            return this;
        }
        if (this.fields != null) {
            fields = String.valueOf(this.fields) + "," + fields;
        }
        String[] fieldArr = Arrays.toStringArray((String)fields);
        this.fields = Arrays.toFilterSameStr((String[])fieldArr);
        return this;
    }

    public Selector clearFields() {
        this.fields = null;
        return this;
    }

    public Selector addReplace(String key, String value) {
        this.addReplaceInner(key, value);
        return this;
    }

    public Selector addGroupbyFields(String fields) {
        if (!Validates.isScope((String)fields, (String)FIELD_FORMAT)) {
            return this;
        }
        fields = fields.trim();
        fields = Strings.trimLeft((String)fields, (String)",");
        if (Validates.isEmptyBlank((String)(fields = Strings.trimRight((String)fields, (String)",")))) {
            return this;
        }
        if (this.groupby != null) {
            fields = String.valueOf(this.groupby) + "," + fields;
        }
        String[] fieldArr = Arrays.toStringArray((String)fields);
        this.groupby = Arrays.toFilterSameStr((String[])fieldArr);
        return this;
    }

    public Selector clearGroupbyFields() {
        this.groupby = null;
        return this;
    }

    public Selector addJoin(String alias, Selector selector) {
        if (this.joinMap == null) {
            this.joinMap = new HashMapSV();
        }
        this.joinMap.put(alias, (Object)selector);
        return this;
    }

    public Selector addJoin(Class<?> clazz, Selector selector) {
        if (this.joinMap == null) {
            this.joinMap = new HashMapSV();
        }
        this.joinMap.put(clazz.getName(), (Object)selector);
        return this;
    }

    public String getJoinWhereSQL(ZTable fTable, String alias, String table, String tableAlias, MapSO paramMap) throws ORMException {
        if (this.joinMap == null) {
            return tableAlias;
        }
        _Table dbo = fTable.getTableByTableName(table);
        Selector selector = (Selector)this.joinMap.get(alias);
        if (selector == null) {
            selector = (Selector)this.joinMap.get(dbo.getName());
        }
        if (selector == null) {
            return tableAlias;
        }
        List conditionList = selector.getConditionList();
        if (conditionList == null || conditionList.isEmpty()) {
            return tableAlias;
        }
        StringBuilder whereSQL = new StringBuilder();
        whereSQL.append("(select ").append(selector.getFieldSQL(dbo)).append(" from ").append(table).append(" where ");
        whereSQL.append(((Condition)conditionList.get(0)).toSql(dbo, paramMap));
        int i = 1;
        while (i < conditionList.size()) {
            whereSQL.append(" and ").append(((Condition)conditionList.get(i)).toSql(dbo, paramMap));
            ++i;
        }
        whereSQL.append(") as ").append(alias);
        return whereSQL.toString();
    }

    public boolean hasOrderby() {
        return this.orderbyMap != null && !this.orderbyMap.isEmpty();
    }

    public LinkedMapSS getOrderby() {
        return this.orderbyMap;
    }

    public Selector addOrderbyAsc(String fields) {
        String[] fieldArr;
        if (this.orderbyMap == null) {
            this.orderbyMap = new LinkedMapSS(2);
        }
        String[] stringArray = fieldArr = Arrays.toStringArray((String)fields);
        int n = fieldArr.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            this.orderbyMap.put(field, "asc");
            ++n2;
        }
        return this;
    }

    public Selector addOrderbyDesc(String fields) {
        String[] fieldArr;
        if (this.orderbyMap == null) {
            this.orderbyMap = new LinkedMapSS(2);
        }
        String[] stringArray = fieldArr = Arrays.toStringArray((String)fields);
        int n = fieldArr.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            this.orderbyMap.put(field, "desc");
            ++n2;
        }
        return this;
    }

    public String getFields() {
        return this.fields;
    }

    public String getFieldSQL(Dbo dbo) throws ORMException {
        String[] fieldArr;
        if (Validates.isEmptyBlank((String)this.fields)) {
            return "*";
        }
        StringBuilder strb = new StringBuilder();
        String[] stringArray = fieldArr = Arrays.toStringArray((String)this.fields);
        int n = fieldArr.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            String column = dbo.getColumn(field);
            if (column != null) {
                strb.append(column).append(",");
            }
            ++n2;
        }
        if (strb.length() > 0) {
            strb.setLength(strb.length() - 1);
        }
        return strb.toString();
    }

    public String getOrderbySQL(Dbo dbo) throws ORMException {
        if (this.orderbyMap == null || this.orderbyMap.isEmpty()) {
            return "";
        }
        StringBuilder strb = new StringBuilder(" order by");
        for (Map.Entry entry : this.orderbyMap.entrySet()) {
            String field = (String)entry.getKey();
            if (!dbo.hasField(field)) {
                throw new ORMException("\u6620\u5c04\u914d\u7f6e\u5f02\u5e38,\u5728\u914d\u7f6e[" + dbo.getName() + "]\u4e2d\u672a\u627e\u5230[" + field + "]\u5b57\u6bb5");
            }
            String column = dbo.getColumn(field);
            strb.append(" ").append(column).append(" ").append((String)entry.getValue()).append(",");
        }
        strb.setLength(strb.length() - 1);
        return strb.toString();
    }

    public String getOrderbyReverseSQL(Dbo dbo) throws ORMException {
        if (this.orderbyMap == null || this.orderbyMap.isEmpty()) {
            return "";
        }
        ArrayList orderbyList = new ArrayList();
        for (Map.Entry entry : this.orderbyMap.entrySet()) {
            String field = (String)entry.getKey();
            if (!dbo.hasField(field)) {
                throw new ORMException("\u6620\u5c04\u914d\u7f6e\u5f02\u5e38,\u5728\u914d\u7f6e[" + dbo.getName() + "]\u4e2d\u672a\u627e\u5230[" + field + "]\u5b57\u6bb5");
            }
            orderbyList.add(new String[]{field, "asc".equals(entry.getValue()) ? "desc" : "asc"});
        }
        orderbyList = Lists.reverse(orderbyList);
        StringBuilder strb = new StringBuilder(" order by");
        for (String[] orderbyArr : orderbyList) {
            String field = orderbyArr[0];
            String value = orderbyArr[1];
            String column = dbo.getColumn(field);
            strb.append(" ").append(column).append(" ").append(value).append(",");
        }
        strb.setLength(strb.length() - 1);
        return strb.toString();
    }

    public String getGroupbySQL(Dbo dbo) throws ORMException {
        String[] fieldArr;
        if (Validates.isEmptyBlank((String)this.groupby)) {
            return "";
        }
        StringBuilder strb = new StringBuilder(" group by");
        String[] stringArray = fieldArr = Arrays.toStringArray((String)this.groupby);
        int n = fieldArr.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            String column = dbo.getColumn(field);
            if (column == null) {
                throw new ORMException("\u6620\u5c04\u914d\u7f6e\u5f02\u5e38,\u5728\u914d\u7f6e[" + dbo.getName() + "]\u4e2d\u672a\u627e\u5230[" + field + "]\u5c5e\u6027");
            }
            strb.append(" ").append(column).append(",");
            ++n2;
        }
        strb.setLength(strb.length() - 1);
        return strb.toString();
    }
}

