/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.orm.config;

import java.io.InputStream;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.zhiqim.kernel.constants.XmlConstants;
import org.zhiqim.kernel.extend.LinkedMapSS;
import org.zhiqim.kernel.util.Sqls;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.kernel.xml.Xmls;
import org.zhiqim.orm.ORMConstants;
import org.zhiqim.orm.ORMException;
import org.zhiqim.orm.config.ZSQLResolver;

public class ZSQLConfig
implements ORMConstants,
XmlConstants {
    private String name;
    private LinkedMapSS sqlMap = new LinkedMapSS();

    public ZSQLConfig(String name) {
        this.name = name;
    }

    public String toString() {
        StringBuilder strb = new StringBuilder();
        strb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("\r\n");
        strb.append("<!DOCTYPE ZHIQIM-SQL PUBLIC \"-//ZHIQIM //DTD Zhiqim-Sql Configuration 1.5.0//EN\" \"http://zhiqim.org/xmldtds/zhiqim_sql_1_5_0.dtd\">").append("\r\n");
        strb.append("<zhiqim-sql>").append("\r\n").append("\r\n");
        for (Map.Entry entry : this.sqlMap.entrySet()) {
            strb.append("<sql id=\">").append((String)entry.getKey()).append("\">").append("\r\n");
            strb.append("<![CDATA[").append("\r\n");
            strb.append((String)entry.getValue()).append("\r\n");
            strb.append("]]>").append("\r\n");
            strb.append("</sql>").append("\r\n");
        }
        strb.append("\r\n");
        strb.append("</zhiqim-sql>");
        return strb.toString();
    }

    public void load(InputStream in) throws Exception {
        Document document = Xmls.buildDocument((InputStream)in, (EntityResolver)new ZSQLResolver());
        NodeList updateList = document.getElementsByTagName("sql");
        int i = 0;
        while (i < updateList.getLength()) {
            Node node = updateList.item(i);
            if (node.getNodeType() == 1) {
                String id = Xmls.getAttribute((Node)node, (String)"id");
                String sql = node.getTextContent();
                if (Validates.isEmptyBlank((String)sql)) {
                    throw new ORMException("\u4e0d\u5141\u8bb8SQL\u8bed\u53e5\u4e3a\u7a7a\u7684\u914d\u7f6e,[id=" + id + "]");
                }
                this.sqlMap.put(id, Sqls.formatSpace((String)sql));
            }
            ++i;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getSQL(String id) {
        return this.sqlMap.get(id);
    }

    public LinkedMapSS getSQLMap() {
        return this.sqlMap;
    }
}

