/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.orm;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.zhiqim.kernel.extend.HashMapCO;
import org.zhiqim.kernel.extend.HashMapCV;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.paging.PageBuilder;
import org.zhiqim.kernel.paging.PageResult;
import org.zhiqim.kernel.schedule.Scheduler;
import org.zhiqim.kernel.schedule.TaskThreader;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.kernel.util.Lists;
import org.zhiqim.kernel.util.Objects;
import org.zhiqim.orm.ORMException;
import org.zhiqim.orm.ORMServer;
import org.zhiqim.orm.ZTableImplement;
import org.zhiqim.orm.dbo.Comparator;
import org.zhiqim.orm.dbo.Condition;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.orm.dbo.defined._Table;

final class ZTableCache {
    private static final Log log = LogFactory.getLog(ZTableCache.class);
    private final ORMServer server;
    private final HashMapCO lockMap;
    private final HashMapCV<List<?>> cache;
    private final Scheduler scheduler;

    public ZTableCache(ORMServer server) {
        this.server = server;
        this.lockMap = new HashMapCO();
        this.cache = new HashMapCV();
        this.scheduler = new Scheduler();
        this.scheduler.create();
    }

    public void schedule() {
        for (TaskThreader task : this.server.getCacheMap().values()) {
            this.scheduler.addTask(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void cache(Class<?> clazz, List<T> list) throws ORMException, SQLException {
        Object lock;
        Object object = lock = this.lock(clazz);
        synchronized (object) {
            List oList = (List)this.cache.remove(clazz);
            if (oList != null) {
                oList.clear();
                oList = null;
            }
            this.cache.put(clazz, list);
        }
        log.info((Object)"\u5237\u65b0\u7f13\u5b58[%s]", new Object[]{clazz.getName()});
    }

    public <T> T item(Class<T> clazz, Object ... ids) throws ORMException, SQLException {
        _Table _table = ((ZTableImplement)this.server.table()).getTable(clazz);
        String[] keys = _table.getKeyArr();
        Selector selector = new Selector();
        int i = 0;
        while (i < keys.length) {
            String field = _table.getField(keys[i]).getField();
            selector.addMust(field, ids[i]);
            ++i;
        }
        return this.item(clazz, selector);
    }

    public <T> T item(Class<T> clazz) throws ORMException, SQLException {
        List<T> list = this.fetch(clazz, null);
        if (list.isEmpty()) {
            return null;
        }
        return (T)Objects.copy(list.get(0), (Object)Classes.newInstance(clazz));
    }

    public <T> T item(Class<T> clazz, Selector selector) throws ORMException, SQLException {
        List<T> list = this.fetch(clazz, selector);
        if (list.isEmpty()) {
            return null;
        }
        if (!selector.hasCondition()) {
            return (T)Objects.copy(list.get(0), (Object)Classes.newInstance(clazz));
        }
        for (T item : list) {
            if (!this.match(item, selector)) continue;
            return (T)Objects.copy(item, (Object)Classes.newInstance(clazz));
        }
        return null;
    }

    public <T> List<T> list(Class<T> clazz) throws ORMException, SQLException {
        return this.copyList(clazz, this.fetch(clazz, null));
    }

    public <T> List<T> list(Class<T> clazz, Selector selector) throws ORMException, SQLException {
        List<T> list = this.fetch(clazz, selector);
        if (list.isEmpty()) {
            return list;
        }
        if (!selector.hasCondition()) {
            return this.copyList(clazz, list);
        }
        ArrayList<Object> sList = new ArrayList<Object>();
        for (T item : list) {
            if (!this.match(item, selector)) continue;
            sList.add(Objects.copy(item, (Object)Classes.newInstance(clazz)));
        }
        return Lists.trim(sList);
    }

    public <T> List<T> list(Class<T> clazz, int pageNo, int pageSize) throws ORMException, SQLException {
        List<T> list = this.fetch(clazz, null);
        if (list.isEmpty()) {
            return list;
        }
        return PageBuilder.pageList((int)pageNo, (int)pageSize, this.copyList(clazz, list));
    }

    public <T> List<T> list(Class<T> clazz, int pageNo, int pageSize, Selector selector) throws ORMException, SQLException {
        List<T> list = this.fetch(clazz, selector);
        if (list.isEmpty()) {
            return list;
        }
        if (!selector.hasCondition()) {
            return PageBuilder.pageList((int)pageNo, (int)pageSize, this.copyList(clazz, list));
        }
        ArrayList<Object> sList = new ArrayList<Object>();
        for (T item : list) {
            if (!this.match(item, selector)) continue;
            sList.add(Objects.copy(item, (Object)Classes.newInstance(clazz)));
        }
        return PageBuilder.pageList((int)pageNo, (int)pageSize, sList);
    }

    public <T> PageResult<T> page(Class<T> clazz, int pageNo, int pageSize) throws ORMException, SQLException {
        List<T> list = this.fetch(clazz, null);
        if (list.isEmpty()) {
            return PageBuilder.newResult((int)0, (int)pageNo, (int)pageSize, list);
        }
        return PageBuilder.pageResult((int)pageNo, (int)pageSize, this.copyList(clazz, list));
    }

    public <T> PageResult<T> page(Class<T> clazz, int pageNo, int pageSize, Selector selector) throws ORMException, SQLException {
        List<T> list = this.fetch(clazz, selector);
        if (list.isEmpty()) {
            return PageBuilder.newResult((int)0, (int)pageNo, (int)pageSize, list);
        }
        if (!selector.hasCondition()) {
            return PageBuilder.pageResult((int)pageNo, (int)pageSize, this.copyList(clazz, list));
        }
        ArrayList<Object> sList = new ArrayList<Object>();
        for (T item : list) {
            if (!this.match(item, selector)) continue;
            sList.add(Objects.copy(item, (Object)Classes.newInstance(clazz)));
        }
        return PageBuilder.pageResult((int)pageNo, (int)pageSize, sList);
    }

    private <T> List<T> fetch(Class<T> clazz, Selector selector) throws ORMException, SQLException {
        List list = (List)this.cache.get(clazz);
        if (list == null) {
            this.server.table().cache(clazz);
            list = (List)this.cache.get(clazz);
        }
        if (selector == null || !selector.hasOrderby()) {
            return list;
        }
        ArrayList nList = new ArrayList(list);
        Collections.sort(nList, new Comparator(selector));
        return Lists.trim(nList);
    }

    private <T> boolean match(T item, Selector selector) {
        for (Condition c : selector.getConditionList()) {
            if (c.match(item)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object lock(Class<?> clazz) {
        ZTableCache zTableCache = this;
        synchronized (zTableCache) {
            Object lock = this.lockMap.get(clazz);
            if (lock == null) {
                lock = new Object();
                this.lockMap.put(clazz, lock);
            }
            return lock;
        }
    }

    private <T> List<T> copyList(Class<T> clazz, List<T> list) {
        if (list.isEmpty()) {
            return list;
        }
        ArrayList<Object> cList = new ArrayList<Object>(list.size());
        for (T item : list) {
            Object cItem = Objects.copy(item, (Object)Classes.newInstance(clazz));
            cList.add(cItem);
        }
        return Lists.trim(cList);
    }
}

