/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.orm;

import java.sql.SQLException;
import org.zhiqim.kernel.MultiInstancer;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.orm.ORMConstants;
import org.zhiqim.orm.ORMException;
import org.zhiqim.orm.ORMServer;
import org.zhiqim.orm.ZDDL;
import org.zhiqim.orm.ZSQL;

class ZDDLImplement
extends MultiInstancer
implements ZDDL,
ORMConstants {
    private ORMServer server;
    private ZSQL zSQL;

    public ZDDLImplement(ORMServer server) {
        this.server = server;
        this.zSQL = server.sql();
    }

    public ORMServer getServer() {
        return this.server;
    }

    @Override
    public String toColumnType(String type) {
        return this.server.getPolicy().toColumnType(type);
    }

    @Override
    public String toColumnType(String fieldType, String fieldLength) {
        return this.toColumnType(Validates.isEmptyBlank((String)fieldLength) ? fieldType : String.valueOf(fieldType) + "," + fieldLength);
    }

    @Override
    public void alterTableName(String table, String newTable) throws SQLException {
        this.zSQL.execute("alter table " + table + " rename to " + newTable.toUpperCase());
    }

    @Override
    public void alterColumnAdd(String table, String column, String columnType, boolean notNull) throws SQLException {
        this.zSQL.execute(this.server.getPolicy().toAlertColumnAdd(table, column, columnType, notNull));
    }

    @Override
    public void alterColumnDrop(String table, String column) throws ORMException, SQLException {
        this.server.getPolicy().executeAlertColumnDrop(table, column);
    }

    @Override
    public void alterColumnInfo(String table, String column, String newColumn, String newColumnType, boolean newNotNull) throws ORMException, SQLException {
        if (column.equalsIgnoreCase(newColumn)) {
            this.alterColumnType(table, column, newColumnType, newNotNull);
            return;
        }
        this.server.getPolicy().executeAlertColumnInfo(table, column, newColumn, newColumnType, newNotNull);
    }

    @Override
    public void alterColumnName(String table, String column, String newColumn) throws ORMException, SQLException {
        this.server.getPolicy().executeAlertColumnName(table, column, newColumn);
    }

    @Override
    public void alterColumnType(String table, String column, String newColumnType, boolean newNotNull) throws ORMException, SQLException {
        this.server.getPolicy().executeAlertColumnType(table, column, newColumnType, newNotNull);
    }

    @Override
    public void alertPrimaryKeyAdd(String table, String columns) throws ORMException, SQLException {
        this.server.getPolicy().executeAlertPrimaryKeyAdd(table, columns);
    }

    @Override
    public void alertPrimaryKeyDrop(String table) throws ORMException, SQLException {
        this.server.getPolicy().executeAlertPrimaryKeyDrop(table);
    }
}

