/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.orm;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.config.Group;
import org.zhiqim.kernel.extend.HashMapCV;
import org.zhiqim.kernel.extend.HashMapSS;
import org.zhiqim.kernel.extend.HashMapSV;
import org.zhiqim.kernel.extend.MapSS;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.schedule.ScheduleFactory;
import org.zhiqim.kernel.schedule.Task;
import org.zhiqim.kernel.schedule.TaskThreader;
import org.zhiqim.kernel.transaction.Transaction;
import org.zhiqim.kernel.transaction.TransactionManager;
import org.zhiqim.kernel.transaction.TransactionService;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Resources;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.orm.ORMConstants;
import org.zhiqim.orm.ORMException;
import org.zhiqim.orm.ORMParameter;
import org.zhiqim.orm.ORMPolicy;
import org.zhiqim.orm.ORMPredefinded;
import org.zhiqim.orm.ORMTransaction;
import org.zhiqim.orm.ORMType;
import org.zhiqim.orm.ZDDLImplement;
import org.zhiqim.orm.ZSQLImplement;
import org.zhiqim.orm.ZTableCacheTask;
import org.zhiqim.orm.ZTableImplement;
import org.zhiqim.orm.ZTablerImplement;
import org.zhiqim.orm.ZViewImplement;
import org.zhiqim.orm.config.ZSQLConfig;
import org.zhiqim.orm.datasource.ZDataSource;
import org.zhiqim.orm.dbo.defined._Table;

public class ORMServer
extends ORMPredefinded
implements TransactionService,
ORMConstants {
    private static final Log log = LogFactory.getLog(ORMServer.class);
    private ORMParameter parameter;
    private ORMPolicy policy;
    private ZDataSource dataSource;

    public boolean create() throws Exception {
        if (this.id == null) {
            return false;
        }
        Group group = Global.getGroup((String)this.id);
        if (group == null) {
            return false;
        }
        return this.create(new ORMParameter(group));
    }

    public boolean create(ORMParameter parameter) throws Exception {
        this.parameter = parameter;
        log.info((Object)"\u521d\u59cb\u5316[\u6570\u636e\u5e93\u6620\u5c04:%s]\u5f00\u59cb...", new Object[]{this.id});
        String dbType = parameter.getDbType();
        this.policy = ORMType.getDatabasePolicy(this, dbType);
        if (this.policy == null) {
            log.fatal((Object)"\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b[%s]", new Object[]{dbType});
            return false;
        }
        this.dataSource = parameter.newDatabase();
        if (!this.dataSource.open()) {
            log.fatal((Object)"\u521d\u59cb\u5316\u8fde\u63a5\u6c60\u5931\u8d25[%s]", new Object[]{dbType});
            return false;
        }
        super.open();
        if (!this.isInitSQLMapping()) {
            log.fatal((Object)"\u521d\u59cb\u5316DBO\u548cSQL\u5931\u8d25[%s]", new Object[]{dbType});
            return false;
        }
        this.zSQL = new ZSQLImplement(this);
        this.zDDL = new ZDDLImplement(this);
        this.zTabler = new ZTablerImplement(this);
        this.zTable = new ZTableImplement(this);
        this.zView = new ZViewImplement(this);
        this.initCacheConfig();
        TransactionManager.addTransactionService((TransactionService)this);
        if (!this.policy.chkKeepTime(parameter.getMaxKeepTime())) {
            log.info((Object)"\u521d\u59cb\u5316[\u6570\u636e\u5e93\u6620\u5c04:%s]\u68c0\u67e5\u5230\u4fdd\u6301\u65f6\u957f\u5c0f\u4e8e\u914d\u7f6e\u7684maxKeepTime+3\u5206\u949f", new Object[]{this.id});
            return false;
        }
        log.info((Object)"\u521d\u59cb\u5316[\u6570\u636e\u5e93\u6620\u5c04:%s]\u5b8c\u6210!!!\r\n", new Object[]{this.id});
        return true;
    }

    public void destroy() throws Exception {
        TransactionManager.removeTransactionService((TransactionService)this);
        super.close();
        if (this.dataSource != null) {
            this.dataSource.close();
            this.dataSource = null;
        }
    }

    private boolean isInitSQLMapping() throws Exception {
        HashMapSV<Integer> sqlConfigMap = this.parameter.getSqlConfig();
        block6: for (Map.Entry entry : sqlConfigMap.entrySet()) {
            String key = (String)entry.getKey();
            int type = (Integer)entry.getValue();
            switch (type) {
                case 0: {
                    this.addSQLConfig(key, new FileInputStream(key));
                    break;
                }
                case 1: {
                    File[] fileList;
                    File folder = new File(key);
                    File[] fileArray = fileList = folder.listFiles();
                    int n = fileList.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String name;
                        File file = fileArray[n2];
                        if (file.isFile() && file.canRead() && (name = Files.toLinuxPath((String)file.getPath())).endsWith(".sql.xml")) {
                            this.addSQLConfig(name, new FileInputStream(file));
                        }
                        ++n2;
                    }
                    continue block6;
                }
                case 2: {
                    this.addSQLConfig(key, Resources.getResourceStream(ORMServer.class, (String)key));
                    break;
                }
                case 3: {
                    List fileList = Resources.getResourceFileNameList(ORMServer.class, (String)key);
                    for (String name : fileList) {
                        if (!name.endsWith(".sql.xml")) continue;
                        String className = String.valueOf(Strings.addEndsWith((String)key, (String)"/")) + name;
                        this.addSQLConfig(className, Resources.getResourceStream(ORMServer.class, (String)className));
                    }
                    continue block6;
                }
            }
        }
        return true;
    }

    private void addSQLConfig(String name, InputStream is) throws Exception {
        ZSQLConfig sqlConfig = new ZSQLConfig(name);
        sqlConfig.load(is);
        for (Map.Entry sqlEntry : sqlConfig.getSQLMap().entrySet()) {
            if (this.sqlMap.containsKey((String)sqlEntry.getKey())) {
                throw new ORMException("\u6620\u5c04\u6587\u4ef6:[%s]\u914d\u7f6e\u5f02\u5e38\uff0c\u6709\u76f8\u540c\u7684ID[%s]\u5b58\u5728", name, sqlEntry.getKey());
            }
            this.sqlMap.put((String)sqlEntry.getKey(), (String)sqlEntry.getValue());
        }
        log.info((Object)"\u6620\u5c04\u6587\u4ef6[%s]\u52a0\u8f7d\u6210\u529f", new Object[]{name});
    }

    private void initCacheConfig() throws Exception {
        HashMapSS cacheConfigMap = this.parameter.getCacheConfig();
        for (String className : cacheConfigMap.keySet()) {
            Class clazz = Classes.forName((String)Global.getClassName((String)className));
            if (clazz == null) {
                throw new ORMException("\u7f13\u5b58\u7c7b[%s]\u914d\u7f6e\u5f02\u5e38\uff0c\u672a\u627e\u5230\u8be5\u7c7b", className);
            }
            _Table table = this.zTable.getTable(clazz);
            if (table == null) {
                throw new ORMException("\u7f13\u5b58\u7c7b[%s]\u914d\u7f6e\u5f02\u5e38\uff0c\u8be5\u7c7b\u4e0d\u662f\u6807\u51c6\u8868DBO\u5bf9\u8c61", className);
            }
            ZTableCacheTask task = new ZTableCacheTask(this.zTable, clazz);
            HashMapSS paramMap = Jsons.toMapSS((String)cacheConfigMap.get(className));
            TaskThreader taskThreader = ScheduleFactory.getTaskThreader((Task)task, (MapSS)paramMap);
            if (taskThreader == null) {
                throw new ORMException("\u7f13\u5b58\u7c7b[%s]\u914d\u7f6e\u5f02\u5e38\uff0c\u65f6\u949f\u683c\u5f0f\u4e0d\u6b63\u5e38", className);
            }
            this.cacheMap.put(clazz, (Object)taskThreader);
        }
        this.zTable.schedule();
    }

    public ORMParameter getParameter() {
        return this.parameter;
    }

    public int getDatabaseType() {
        return this.parameter.getDatabaseType();
    }

    public String getDatabaseName() {
        return this.parameter.getDbName();
    }

    public boolean isUpdateSqlLog() {
        return this.parameter.isUpdateSqlLog();
    }

    public boolean isQuerySqlLog() {
        return this.parameter.isQuerySqlLog();
    }

    public boolean isOracle() {
        return this.parameter.isOracle();
    }

    public boolean isMssql() {
        return this.parameter.isMssql();
    }

    public boolean isSqlite() {
        return this.parameter.isSqlite();
    }

    public boolean isHsql() {
        return this.parameter.isHsql();
    }

    public boolean isMysql() {
        return this.parameter.isMysql();
    }

    public ZDataSource getDateSource() {
        return this.dataSource;
    }

    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public ORMPolicy getPolicy() {
        return this.policy;
    }

    public boolean isCache(Class<?> clazz) {
        return this.cacheMap.containsKey(clazz);
    }

    public HashMapCV<TaskThreader> getCacheMap() {
        return this.cacheMap;
    }

    public Connection getTransactionInstance() throws SQLException {
        return this.getConnection();
    }

    public Transaction beginTransaction(Object instance) throws SQLException {
        return new ORMTransaction(this.id, (Connection)instance).begin();
    }
}

