/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.util;

import java.io.IOException;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import org.zhiqim.httpd.HttpResponse;
import org.zhiqim.httpd.context.ZmlContextConstants;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.logging.Log;

@AnAlias(value={"Responses"})
public class Responses
implements ZmlContextConstants {
    public static void doReturnMessage(HttpResponse response, int mode, HashMap<String, String> headerMap) throws IOException {
        if (mode != 1) {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                response.addHeader(entry.getKey(), entry.getValue());
            }
            response.sendHeader(200);
        } else {
            response.setContentType("text/plain; charset=UTF-8");
            StringBuilder strb = new StringBuilder("{");
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                strb.append("\"").append(entry.getKey()).append("\":\"").append(entry.getValue()).append("\"").append(",");
            }
            strb.setLength(strb.length() - 1);
            strb.append("}");
            response.print(strb.toString());
            response.commit();
        }
    }

    public static void printAndCommit(HttpResponse response, StringBuilder strb, Log log) throws SocketException {
        try {
            response.print(strb.toString());
            response.commit();
        }
        catch (SocketException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }
}

