/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.sessioner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpSession;
import org.zhiqim.httpd.HttpSessionManager;
import org.zhiqim.httpd.HttpSessionUser;
import org.zhiqim.httpd.sessioner.RmiSession;
import org.zhiqim.kernel.httpclient.HttpRMI;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.paging.PageBuilder;
import org.zhiqim.kernel.paging.PageResult;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.kernel.util.Ints;
import org.zhiqim.kernel.util.Lists;

public class RmiSessionManager
implements HttpSessionManager {
    private static final String SESSIONER = "sessioner";
    private HttpContext context;
    private String url;
    private String key;
    private String secret;
    private String sessionIdName;
    private int sessionTimeout;

    @Override
    public HttpSession newSession(String sessionId) {
        return new RmiSession().setSessionManager(this).setSessionId(sessionId);
    }

    @Override
    public HttpContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(HttpContext context) {
        this.context = context;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public void setSessionIdName(String sessionIdName) {
    }

    @Override
    public void setSessionTimeout(int sessionTimeout) {
    }

    @Override
    public void setSessionParameter(String sessionParameter) {
        String[] params = Arrays.toStringArray((String)sessionParameter);
        this.url = params[0];
        this.key = params[1];
        this.secret = params[2];
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public String getSessionIdName() {
        if (this.sessionIdName != null) {
            return this.sessionIdName;
        }
        HttpRMI conn = new HttpRMI(this.url);
        conn.setKeySecret(this.key, this.secret);
        conn.setServiceId(SESSIONER);
        conn.setMethodName("getSessionIdName");
        conn.execute();
        if (!conn.isResponseSuccess()) {
            throw Asserts.exception((String)conn.getResponseText());
        }
        this.sessionIdName = conn.getResponseText();
        return this.sessionIdName;
    }

    @Override
    public int getSessionTimeout() {
        if (this.sessionTimeout != 0) {
            return this.sessionTimeout;
        }
        HttpRMI conn = new HttpRMI(this.url);
        conn.setKeySecret(this.key, this.secret);
        conn.setServiceId(SESSIONER);
        conn.setMethodName("getSessionTimeout");
        conn.execute();
        if (!conn.isResponseSuccess()) {
            throw Asserts.exception((String)conn.getResponseText());
        }
        this.sessionTimeout = Ints.toInt((String)conn.getResponseText());
        return this.sessionTimeout;
    }

    @Override
    public void setSession(HttpSession session) {
        HttpRMI conn = new HttpRMI(this.url);
        conn.setKeySecret(this.key, this.secret);
        conn.setServiceId(SESSIONER);
        conn.setMethodName("setSession");
        conn.addParam((Object)Jsons.toString((Object)session));
        conn.execute();
        if (!conn.isResponseSuccess()) {
            throw Asserts.exception((String)conn.getResponseText());
        }
    }

    @Override
    public HttpSession getSession(String sessionId) {
        HttpRMI conn = new HttpRMI(this.url);
        conn.setKeySecret(this.key, this.secret);
        conn.setServiceId(SESSIONER);
        conn.setMethodName("getSession");
        conn.addParam((Object)sessionId);
        conn.execute();
        if (!conn.isResponseSuccess()) {
            throw Asserts.exception((String)conn.getResponseText());
        }
        String responseText = conn.getResponseText();
        RmiSession session = new RmiSession().setSessionManager(this);
        session.parse(responseText);
        return session;
    }

    @Override
    public boolean hasSession(String sessionId) {
        HttpRMI conn = new HttpRMI(this.url);
        conn.setKeySecret(this.key, this.secret);
        conn.setServiceId(SESSIONER);
        conn.setMethodName("hasSession");
        conn.addParam((Object)sessionId);
        conn.execute();
        if (!conn.isResponseSuccess()) {
            throw Asserts.exception((String)conn.getResponseText());
        }
        return "true".equals(conn.getResponseText());
    }

    @Override
    public void invalidateSession(String sessionId) {
        HttpRMI conn = new HttpRMI(this.url);
        conn.setKeySecret(this.key, this.secret);
        conn.setServiceId(SESSIONER);
        conn.setMethodName("invalidateSession");
        conn.addParam((Object)sessionId);
        conn.execute();
        if (!conn.isResponseSuccess()) {
            throw Asserts.exception((String)conn.getResponseText());
        }
    }

    @Override
    public void updateLastAccessed(String sessionId) {
        HttpRMI conn = new HttpRMI(this.url);
        conn.setKeySecret(this.key, this.secret);
        conn.setServiceId(SESSIONER);
        conn.setMethodName("updateLastAccessed");
        conn.addParam((Object)sessionId);
        conn.execute();
        if (!conn.isResponseSuccess()) {
            throw Asserts.exception((String)conn.getResponseText());
        }
    }

    @Override
    public void updateInfo(String sessionId, String sessionIp, String userAgent) {
        HttpRMI conn = new HttpRMI(this.url);
        conn.setKeySecret(this.key, this.secret);
        conn.setServiceId(SESSIONER);
        conn.setMethodName("updateInfo");
        conn.addParam((Object)sessionId);
        conn.addParam((Object)sessionIp);
        conn.addParam((Object)userAgent);
        conn.execute();
        if (!conn.isResponseSuccess()) {
            throw Asserts.exception((String)conn.getResponseText());
        }
    }

    @Override
    public int size() {
        HttpRMI conn = new HttpRMI(this.url);
        conn.setKeySecret(this.key, this.secret);
        conn.setServiceId(SESSIONER);
        conn.setMethodName("size");
        conn.execute();
        if (!conn.isResponseSuccess()) {
            throw Asserts.exception((String)conn.getResponseText());
        }
        return Ints.toInt((String)conn.getResponseText());
    }

    @Override
    public List<HttpSession> getSessionList() {
        HttpRMI conn = new HttpRMI(this.url);
        conn.setKeySecret(this.key, this.secret);
        conn.setServiceId(SESSIONER);
        conn.setMethodName("getSessionList");
        conn.execute();
        if (!conn.isResponseSuccess()) {
            throw Asserts.exception((String)conn.getResponseText());
        }
        List list = Jsons.toList((String)conn.getResponseText(), RmiSession.class);
        ArrayList<HttpSession> nList = new ArrayList<HttpSession>(list.size());
        for (HttpSession s : list) {
            nList.add(s);
        }
        return Collections.unmodifiableList(Lists.trim(nList));
    }

    @Override
    public PageResult<HttpSession> getSessionPage(int pageNo, int pageSize) {
        int size = this.size();
        if (size == 0) {
            return PageBuilder.newResult((int)pageNo, (int)pageSize);
        }
        HttpRMI conn = new HttpRMI(this.url);
        conn.setKeySecret(this.key, this.secret);
        conn.setServiceId(SESSIONER);
        conn.setMethodName("getSessionList");
        conn.addParam((Object)pageNo);
        conn.addParam((Object)pageSize);
        conn.execute();
        if (!conn.isResponseSuccess()) {
            throw Asserts.exception((String)conn.getResponseText());
        }
        List list = Jsons.toList((String)conn.getResponseText(), RmiSession.class);
        ArrayList<HttpSession> nList = new ArrayList<HttpSession>(list.size());
        for (HttpSession s : list) {
            nList.add(s);
        }
        return PageBuilder.newResult((int)size, (int)pageNo, (int)pageSize, nList);
    }

    @Override
    public int sizeUser() {
        HttpRMI conn = new HttpRMI(this.url);
        conn.setKeySecret(this.key, this.secret);
        conn.setServiceId(SESSIONER);
        conn.setMethodName("sizeUser");
        conn.execute();
        if (!conn.isResponseSuccess()) {
            throw Asserts.exception((String)conn.getResponseText());
        }
        return Ints.toInt((String)conn.getResponseText());
    }

    @Override
    public boolean hasSessionName(String sessionName) {
        Asserts.notNull((Object)sessionName, (String)"sessionName");
        HttpRMI conn = new HttpRMI(this.url);
        conn.setKeySecret(this.key, this.secret);
        conn.setServiceId(SESSIONER);
        conn.setMethodName("hasSessionName");
        conn.addParam((Object)sessionName);
        conn.execute();
        if (!conn.isResponseSuccess()) {
            throw Asserts.exception((String)conn.getResponseText());
        }
        return "true".equals(conn.getResponseText());
    }

    @Override
    public List<HttpSessionUser> getSessionUserList() {
        HttpRMI conn = new HttpRMI(this.url);
        conn.setServiceId(SESSIONER);
        conn.setKeySecret(this.key, this.secret);
        conn.setMethodName("getSessionUserList");
        conn.execute();
        if (!conn.isResponseSuccess()) {
            throw Asserts.exception((String)conn.getResponseText());
        }
        ArrayList<HttpSessionUser> list = new ArrayList<HttpSessionUser>();
        List strList = Jsons.toList((String)conn.getResponseText(), String.class);
        for (String str : strList) {
            String className = Jsons.getString((String)str, (String)"className");
            Class clazz = Classes.forName((String)className);
            if (clazz == null) continue;
            HttpSessionUser sessionUser = (HttpSessionUser)Jsons.toObject((String)str, (Class)clazz);
            list.add(sessionUser);
        }
        return Lists.trim(list);
    }

    @Override
    public PageResult<HttpSessionUser> getSessionUserPage(int pageNo, int pageSize) {
        int size = this.sizeUser();
        if (size == 0) {
            return PageBuilder.newResult((int)pageNo, (int)pageSize);
        }
        HttpRMI conn = new HttpRMI(this.url);
        conn.setKeySecret(this.key, this.secret);
        conn.setServiceId(SESSIONER);
        conn.setMethodName("getSessionUserList");
        conn.addParam((Object)pageNo);
        conn.addParam((Object)pageSize);
        conn.execute();
        if (!conn.isResponseSuccess()) {
            throw Asserts.exception((String)conn.getResponseText());
        }
        ArrayList<HttpSessionUser> list = new ArrayList<HttpSessionUser>();
        List strList = Jsons.toList((String)conn.getResponseText(), String.class);
        for (String str : strList) {
            String className = Jsons.getString((String)str, (String)"className");
            Class clazz = Classes.forName((String)className);
            if (clazz == null) continue;
            HttpSessionUser sessionUser = (HttpSessionUser)Jsons.toObject((String)str, (Class)clazz);
            list.add(sessionUser);
        }
        return PageBuilder.newResult((int)size, (int)pageNo, (int)pageSize, list);
    }
}

