/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.sessioner;

import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpSession;
import org.zhiqim.httpd.HttpSessionUser;
import org.zhiqim.httpd.sessioner.RmiSessionManager;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Ints;
import org.zhiqim.kernel.util.Longs;
import org.zhiqim.kernel.util.Strings;

public class RmiSession
implements HttpSession {
    private transient HttpContext context;
    private transient RmiSessionManager sessionManager;
    private String oldSessionId;
    private String sessionId;
    private long created;
    private long accessed;
    private int maxInactiveInterval;
    private String sessionIp;
    private String userAgent;
    private HttpSessionUser sessionUser;
    private HashMapSO attributes;

    public RmiSession() {
        this.accessed = this.created = System.currentTimeMillis();
        this.attributes = new HashMapSO();
    }

    public RmiSession setSessionManager(RmiSessionManager sessionManager) {
        this.sessionManager = sessionManager;
        this.context = sessionManager.getContext();
        this.maxInactiveInterval = sessionManager.getSessionTimeout();
        return this;
    }

    public RmiSession setSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @Override
    public void setSessionIp(String sessionIp) {
        this.sessionIp = sessionIp;
    }

    @Override
    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void parse(String json) {
        String className;
        Class clazz;
        this.oldSessionId = Jsons.getString((String)json, (String)"oldSessionId");
        this.sessionId = Jsons.getString((String)json, (String)"sessionId");
        this.created = Jsons.getLong((String)json, (String)"created");
        this.accessed = Jsons.getLong((String)json, (String)"accessed");
        this.maxInactiveInterval = Jsons.getInt((String)json, (String)"maxInactiveInterval");
        this.sessionIp = Jsons.getString((String)json, (String)"sessionIp");
        this.userAgent = Jsons.getString((String)json, (String)"userAgent");
        this.attributes = Jsons.toMapSO((String)Jsons.getString((String)json, (String)"attributes"));
        String sesionUserStr = Jsons.getString((String)json, (String)"sessionUser");
        if (sesionUserStr != null && (clazz = Classes.forName((String)(className = Jsons.getString((String)sesionUserStr, (String)"className")))) != null) {
            this.sessionUser = (HttpSessionUser)Jsons.toObject((String)sesionUserStr, (Class)clazz);
            this.sessionUser.setSession(this);
        }
    }

    @Override
    public void updateLastAccessed() {
        this.accessed = System.currentTimeMillis();
        this.sessionManager.updateLastAccessed(this.sessionId);
    }

    @Override
    public void updateInfo(String sessionIp, String userAgent) {
        this.accessed = System.currentTimeMillis();
        this.sessionIp = sessionIp;
        this.userAgent = userAgent;
        this.sessionManager.updateLastAccessed(this.sessionId);
    }

    @Override
    public void invalidate() {
        if (this.sessionUser != null) {
            this.sessionUser.setSession(null);
            this.sessionUser = null;
        }
        if (this.attributes != null) {
            this.attributes.clear();
            this.attributes = null;
        }
        if (this.oldSessionId != null) {
            this.sessionManager.invalidateSession(this.oldSessionId);
            this.oldSessionId = null;
        }
        if (this.sessionId != null) {
            this.sessionManager.invalidateSession(this.sessionId);
            this.sessionId = null;
        }
    }

    @Override
    public void setNewSessionId(String newSessionId) {
        if (newSessionId.equals(this.sessionId)) {
            return;
        }
        this.oldSessionId = this.sessionId;
        this.sessionId = newSessionId;
    }

    @Override
    public String getOldSessionId() {
        return this.oldSessionId;
    }

    @Override
    public void clearOldSessionId() {
        this.oldSessionId = null;
    }

    @Override
    public HttpContext getContext() {
        return this.context;
    }

    @Override
    public String getId() {
        return this.sessionId;
    }

    @Override
    public boolean isNew() {
        return this.created == this.accessed;
    }

    @Override
    public String getSessionIp() {
        return this.sessionIp;
    }

    @Override
    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    @Override
    public long getCreated() {
        return this.created;
    }

    @Override
    public String getCreateTime() {
        return DateTimes.toDateTimeString((long)this.created);
    }

    @Override
    public long getLastAccessed() {
        return this.accessed;
    }

    @Override
    public String getLastAccessTime() {
        return DateTimes.toDateTimeString((long)this.accessed);
    }

    @Override
    public long getRemainSecond() {
        long remain = System.currentTimeMillis() - this.getLastAccessed();
        return (long)this.maxInactiveInterval - remain / 1000L;
    }

    @Override
    public long getRemainMinute() {
        return this.getRemainSecond() / 60L;
    }

    @Override
    public long[] getRemainTime() {
        long time = this.getRemainSecond();
        long day = time / 86400L;
        long hour = time % 86400L / 3600L;
        long minute = time % 3600L / 60L;
        long second = time % 60L;
        return new long[]{day, hour, minute, second};
    }

    @Override
    public String getRemainTimeDesc() {
        long[] times = this.getRemainTime();
        StringBuilder strb = new StringBuilder();
        if (times[0] > 0L) {
            strb.append(times[0]).append("\u5929");
        }
        if (times[1] > 0L) {
            strb.append(times[1]).append("\u5c0f\u65f6");
        }
        if (times[2] > 0L) {
            strb.append(times[2]).append("\u5206");
        }
        strb.append(times[3]).append("\u79d2");
        return strb.toString();
    }

    @Override
    public void bindSessionUser(HttpSessionUser sessionUser) {
        if (this.sessionUser != null && !this.sessionUser.equals(sessionUser)) {
            this.sessionUser.setSession(null);
            this.sessionUser = null;
        }
        if (sessionUser != null) {
            this.sessionUser = sessionUser;
            this.sessionUser.setSession(this);
        }
        this.sessionManager.setSession(this);
    }

    @Override
    public void unbindSessionUser() {
        if (this.sessionUser == null) {
            return;
        }
        this.sessionUser.setSession(null);
        this.sessionUser = null;
        this.sessionManager.setSession(this);
    }

    @Override
    public boolean hasSessionUser() {
        return this.sessionUser != null;
    }

    @Override
    public HttpSessionUser getSessionUser() {
        return this.sessionUser;
    }

    @Override
    public <T extends HttpSessionUser> boolean hasSessionUser(Class<T> clazz) {
        return this.sessionUser != null && this.sessionUser.getClass() == clazz;
    }

    @Override
    public <T extends HttpSessionUser> T getSessionUser(Class<T> clazz) {
        return (T)(this.sessionUser == null ? null : (this.sessionUser.getClass() == clazz ? this.sessionUser : null));
    }

    @Override
    public String getSessionName() {
        return this.sessionUser == null ? null : this.sessionUser.getSessionName();
    }

    @Override
    public HashMapSO getAttributes() {
        return this.attributes;
    }

    @Override
    public Object removeAttribute(String name) {
        return this.attributes.remove(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Object getAttribute(String name, Object defaultValue) {
        Object value = this.attributes.get(name);
        return value == null ? defaultValue : value;
    }

    @Override
    public String getAttributeString(String name) {
        return this.getAttributeString(name, null);
    }

    @Override
    public String getAttributeString(String name, String defaultValue) {
        Object value = this.getAttribute(name);
        return value == null ? defaultValue : Strings.trim((String)String.valueOf(value));
    }

    @Override
    public int getAttributeInt(String name) {
        return this.getAttributeInt(name, -1);
    }

    @Override
    public int getAttributeInt(String name, int defaultValue) {
        return Ints.toInt((Object)this.attributes.get(name), (int)defaultValue);
    }

    @Override
    public long getAttributeLong(String name) {
        return this.getAttributeLong(name, -1L);
    }

    @Override
    public long getAttributeLong(String name, long defaultValue) {
        return Longs.toLong((Object)this.attributes.get(name), (long)defaultValue);
    }

    @Override
    public boolean getAttributeBoolean(String name, boolean defaultValue) {
        Object value = this.attributes.get(name);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return defaultValue;
    }

    public String toString() {
        return Jsons.toString((Object)this);
    }
}

