/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.nio;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.zhiqim.httpd.nio.HttpNioConnection;
import org.zhiqim.httpd.nio.HttpNioHeader;
import org.zhiqim.httpd.nio.HttpNioSslBuffer;
import org.zhiqim.httpd.nio.HttpNioSslListener;

public final class HttpNioSslConnection
extends HttpNioConnection {
    private SSLEngine sslEngine;
    private HttpNioSslBuffer buffer;

    public HttpNioSslConnection(HttpNioSslListener listener, SocketChannel channel, InetAddress remoteAddress, SSLEngine sslEngine) {
        super(listener, channel, remoteAddress);
        this.sslEngine = sslEngine;
        this.buffer = new HttpNioSslBuffer(sslEngine);
    }

    public SSLEngine getSSLEngine() {
        return this.sslEngine;
    }

    @Override
    protected void closeAfter() {
        if (this.sslEngine != null) {
            this.sslEngine.closeOutbound();
            try {
                this.sslEngine.closeInbound();
            }
            catch (SSLException sSLException) {}
            this.sslEngine = null;
        }
    }

    @Override
    protected void chkHeader() {
        if (this.header == null || this.header.isParsed()) {
            this.header = new HttpNioHeader(this, this.sslEngine);
        }
    }

    @Override
    protected int parseBuffer() {
        return this.buffer.parseBuffer(this.netBuf, this.header.getInputStream());
    }

    @Override
    public void write(byte[] data, int off, int len) throws IOException {
        ByteBuffer appBuf = ByteBuffer.wrap(data);
        ByteBuffer netBuf = ByteBuffer.allocate(this.sslEngine.getSession().getPacketBufferSize());
        while (appBuf.hasRemaining()) {
            netBuf.clear();
            this.sslEngine.wrap(appBuf, netBuf);
            netBuf.flip();
            super.write(netBuf);
        }
    }

    @Override
    public String toString() {
        return "HttpNioSslConnection[" + this.connId + "]";
    }
}

