/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.nio;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import org.zhiqim.httpd.HttpChannel;
import org.zhiqim.httpd.HttpConnection;
import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpListener;
import org.zhiqim.httpd.nio.HttpNioHeader;
import org.zhiqim.httpd.nio.HttpNioWebsocketConnection;
import org.zhiqim.kernel.util.Threads;

public class HttpNioConnection
implements HttpConnection,
HttpChannel,
Runnable {
    private static final LinkedList<Selector> selectorList = new LinkedList();
    private final HttpListener listener;
    private final SocketChannel socket;
    private final InetAddress remoteAddress;
    protected String connId;
    protected ByteBuffer netBuf;
    protected HttpNioHeader header;
    private volatile boolean closed;
    private volatile boolean locked;
    private volatile long lockTime;
    protected HttpNioWebsocketConnection websocket;

    public HttpNioConnection(HttpListener listener, SocketChannel channel, InetAddress remoteAddress) {
        this.listener = listener;
        this.socket = channel;
        this.remoteAddress = remoteAddress;
        this.connId = sequence.nextString();
        this.netBuf = ByteBuffer.allocate(listener.getSoRecvBuf());
        this.unlock();
    }

    protected void closeAfter() {
    }

    protected void chkHeader() {
        if (this.header == null || this.header.isParsed()) {
            this.header = new HttpNioHeader(this);
        }
    }

    protected int parseBuffer() {
        this.header.addBuffer(this.netBuf);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLock() {
        HttpNioConnection httpNioConnection = this;
        synchronized (httpNioConnection) {
            block4: {
                if (!this.locked) break block4;
                return false;
            }
            this.locked = true;
            this.lockTime = System.currentTimeMillis();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock() {
        HttpNioConnection httpNioConnection = this;
        synchronized (httpNioConnection) {
            this.locked = false;
            this.lockTime = System.currentTimeMillis();
        }
    }

    @Override
    public boolean isActive() {
        return this.locked;
    }

    @Override
    public boolean isOvertime() {
        if (this.websocket != null || !this.locked) {
            return false;
        }
        return System.currentTimeMillis() - this.lockTime > (long)this.listener.getSoIdleTimeMs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        HttpNioConnection httpNioConnection = this;
        synchronized (httpNioConnection) {
            return this.closed || !this.socket.isOpen();
        }
    }

    @Override
    public void run() {
        try {
            this.netBuf.clear();
            int count = this.socket.read(this.netBuf);
            if (count == -1) {
                this.closeSelfOrWebsocket();
            } else if (count == 0) {
                this.unlock();
            } else {
                this.executeSelfOrWebsocket();
            }
        }
        catch (Throwable e) {
            this.closeSelfOrWebsocketException(e);
        }
    }

    private void executeSelfOrWebsocket() {
        if (this.websocket != null) {
            int result = this.websocket.execute(this.netBuf);
            if (result == -1) {
                this.closeSelfOrWebsocket();
            } else {
                this.unlock();
            }
        } else {
            this.chkHeader();
            int result = this.parseBuffer();
            if (result == -1) {
                this.close();
                return;
            }
            if (result == 0) {
                this.unlock();
                return;
            }
            try {
                this.header.execute();
                this.unlock();
            }
            catch (Exception exception) {
                this.close();
            }
        }
    }

    private void closeSelfOrWebsocket() {
        if (this.websocket == null) {
            this.close();
        } else {
            this.websocket.close();
            this.websocket = null;
        }
    }

    private void closeSelfOrWebsocketException(Throwable e) {
        if (this.websocket == null) {
            this.close();
        } else {
            this.websocket.exception(e);
            this.websocket = null;
        }
    }

    @Override
    public int read(ByteBuffer buf) throws IOException {
        return this.socket.read(buf);
    }

    @Override
    public int write(ByteBuffer buf) throws IOException {
        int count = 0;
        while (buf.hasRemaining()) {
            int len = this.socket.write(buf);
            if (len < 0) {
                throw new EOFException();
            }
            if (len > 0) {
                count += len;
                continue;
            }
            this.writeSelection();
        }
        return count;
    }

    @Override
    public void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    @Override
    public void write(byte[] data, int off, int len) throws IOException {
        this.write(ByteBuffer.wrap(data, off, len));
    }

    private void writeSelection() throws IOException {
        Selector selector = HttpNioConnection.getSelector();
        SelectionKey key = null;
        try {
            key = this.socket.register(selector, 4);
            if (selector.select(this.listener.getSoTimeoutMs()) == 0) {
                throw new SocketTimeoutException();
            }
        }
        finally {
            if (key != null) {
                key.cancel();
                key = null;
            }
            selector.selectNow();
            HttpNioConnection.setSelector(selector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        HttpNioConnection httpNioConnection = this;
        synchronized (httpNioConnection) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.unlock();
        this.closeAfter();
        this.listener.remove(this);
        Threads.closeIgnoreException((AutoCloseable)this.socket);
    }

    @Override
    public boolean isWebsocket() {
        return this.websocket != null;
    }

    @Override
    public void doWebsocket(HttpContext context, String protocol, String sessionId) {
        this.websocket = new HttpNioWebsocketConnection(this, context, protocol, sessionId);
        this.websocket.open();
    }

    @Override
    public String getId() {
        return this.connId;
    }

    @Override
    public HttpListener getListener() {
        return this.listener;
    }

    @Override
    public String getRemoteAddr() {
        return this.remoteAddress.getHostAddress();
    }

    public String toString() {
        return "HttpNioConnection[" + this.connId + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Selector getSelector() throws IOException {
        LinkedList<Selector> linkedList = selectorList;
        synchronized (linkedList) {
            if (!selectorList.isEmpty()) {
                return selectorList.removeFirst();
            }
        }
        return Selector.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setSelector(Selector selector) {
        LinkedList<Selector> linkedList = selectorList;
        synchronized (linkedList) {
            selectorList.addLast(selector);
        }
    }
}

