/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.context.service;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpExecutor;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpResponse;
import org.zhiqim.httpd.context.ZmlBootstrap;
import org.zhiqim.httpd.context.ZmlContextConstants;
import org.zhiqim.httpd.context.annotation.AnIntercept;
import org.zhiqim.httpd.context.annotation.AnInterceptNot;
import org.zhiqim.httpd.context.config.ZActionPackageLoader;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.httpd.context.core.Context;
import org.zhiqim.httpd.context.core.Interceptor;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.Service;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnFilterNot;
import org.zhiqim.kernel.annotation.AnGlobal;
import org.zhiqim.kernel.annotation.AnNew;
import org.zhiqim.kernel.annotation.AnTransaction;
import org.zhiqim.kernel.transaction.Transaction;
import org.zhiqim.kernel.transaction.TransactionManager;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Htmls;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Urls;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.kernel.util.codes.MD5;
import org.zhiqim.kernel.util.consts.Int;

public class RmiService
implements HttpExecutor,
ZmlContextConstants {
    private int timeDifference = 600000;
    private HashSet<String> innerObjs = new HashSet();
    private HashMap<String, Class<?>> classMap = new HashMap();
    private HashMap<String, Object> instanceMap = new HashMap();

    public RmiService() {
        this.innerObjs.add("context");
        this.innerObjs.add("session");
        this.innerObjs.add("sessionUser");
        this.innerObjs.add("log");
    }

    @Override
    public boolean isMatch(String pathInContext) {
        return "/service/rmi".equals(pathInContext);
    }

    @Override
    public void handle(HttpRequest request, HttpResponse response) throws IOException {
        boolean ipDefaultPermission;
        String ipBlackList;
        String ipWhiteList;
        if (!"POST".equals(request.getMethod()) || !"text/plain".equals(request.getMimeType()) && !"application/x-www-form-urlencoded".equals(request.getMimeType()) || !"UTF-8".equalsIgnoreCase(request.getCharacterEncodingHeader())) {
            response.sendError(403);
            return;
        }
        String serviceId = Strings.trim((String)request.getHeader("X-RMI-Service"), (String)"");
        String clazz = Strings.trim((String)request.getHeader("X-RMI-Class"), (String)"");
        String method = request.getHeader("X-RMI-Method");
        String key = request.getHeader("X-RMI-Key");
        String timestamp = request.getHeader("X-RMI-Timestamp");
        String authorization = request.getHeader("X-RMI-Authorization");
        if (Validates.isEmptyBlank((String)serviceId) && Validates.isEmptyBlank((String)clazz) || Validates.isEmptyBlank((String)method) || Validates.isEmptyBlank((String)key) || Validates.isEmptyBlank((String)authorization) || !Validates.isDateTime((String)timestamp)) {
            response.sendError(400);
            return;
        }
        long diffTime = System.currentTimeMillis() - DateTimes.toLong((String)timestamp);
        if (diffTime > 0L && diffTime > (long)this.timeDifference || diffTime < 0L && diffTime < (long)(-this.timeDifference)) {
            response.sendError(400);
            return;
        }
        HttpContext context = request.getContext();
        String secret = context.getAttributeString("rmi." + key);
        if (Validates.isEmptyBlank((String)secret)) {
            response.sendError(403);
            return;
        }
        String sign = MD5.encodeUTF8((String)(String.valueOf(key) + timestamp + clazz + method + serviceId + secret));
        if (!authorization.equalsIgnoreCase(sign)) {
            response.sendError(401);
            return;
        }
        String remoteIp = request.getRemoteAddr();
        if (!Validates.isIPAllowByWhiteBlackList((String)remoteIp, (String)(ipWhiteList = context.getAttributeString("rmi." + key + ".ipWhiteList")), (String)(ipBlackList = context.getAttributeString("rmi." + key + ".ipBlackList")), (boolean)(ipDefaultPermission = context.getAttributeBoolean("rmi." + key + ".ipDefaultPermission", true)))) {
            response.sendError(403);
            return;
        }
        this.service(request, response);
    }

    void service(HttpRequest request, HttpResponse response) throws IOException {
        AnTransaction methodTx;
        int n;
        AnInterceptNot methodInterceptorNot;
        AnIntercept methodInterceptor;
        Context context = (Context)request.getContext();
        ZmlBootstrap bootstrap = context.getBootstrap();
        request.setResponseNoCache();
        request.setResponseEncodingUTF8();
        response.setContentType("text/plain");
        String serviceId = Strings.trim((String)request.getHeader("X-RMI-Service"), (String)"");
        String className = Strings.trim((String)request.getHeader("X-RMI-Class"), (String)"");
        String classNameId = Validates.isEmpty((String)className) ? serviceId : className;
        Class<?> curClass = this.getClass(request, serviceId, className);
        if (curClass == null) {
            if (Validates.isEmpty((String)serviceId)) {
                bootstrap.log(request, "[" + className + "\u7c7b\u540d\u548c\u522b\u540d\u4e0d\u5b58\u5728]");
                response.sendError(412, "[" + className + "]\u7c7b\u540d\u548c\u522b\u540d\u4e0d\u5b58\u5728");
            } else {
                bootstrap.log(request, "[\u672a\u627e\u5230" + serviceId + "\u5bf9\u5e94\u7684\u670d\u52a1]");
                response.sendError(412, "[\u672a\u627e\u5230" + serviceId + "\u5bf9\u5e94\u7684\u670d\u52a1]");
            }
            return;
        }
        String methodName = request.getHeader("X-RMI-Method");
        ArrayList<Object> paramList = new ArrayList<Object>();
        Method curMethod = this.getMethod(request, response, curClass, paramList);
        if (curMethod == null) {
            bootstrap.log(request, "[" + classNameId + "]\u4e2d\u7684[" + methodName + "]\u672a\u627e\u5230\u6216\u53c2\u6570\u4e0d\u5339\u914d");
            response.sendError(412, "[" + methodName + "]\u672a\u627e\u5230\u6216\u53c2\u6570\u4e0d\u5339\u914d");
            return;
        }
        AnIntercept classInterceptor = curClass.getAnnotation(AnIntercept.class);
        String interceptors = ZActionPackageLoader.getInterceptor(classInterceptor, methodInterceptor = curMethod.getAnnotation(AnIntercept.class), methodInterceptorNot = curMethod.getAnnotation(AnInterceptNot.class));
        if (Validates.isNotEmpty((String)interceptors) && !this.chkInterceptor(request, response, interceptors, classNameId, methodName)) {
            return;
        }
        Object[] curParams = paramList.toArray();
        if (!curMethod.isAnnotationPresent(AnFilterNot.class)) {
            int i = 0;
            while (i < curParams.length) {
                if (curParams[i] instanceof String) {
                    curParams[i] = Htmls.filterAll((String)((String)curParams[i]));
                }
                ++i;
            }
        }
        boolean hasTx = false;
        boolean allTx = false;
        ArrayList<String> txIdList = new ArrayList<String>();
        AnTransaction classTx = curClass.getAnnotation(AnTransaction.class);
        if (classTx != null) {
            hasTx = true;
            if (Validates.isEmpty((Object[])classTx.value())) {
                allTx = true;
            } else {
                String[] stringArray = classTx.value();
                n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    txIdList.add(id);
                    ++n2;
                }
            }
        }
        if (!allTx && (methodTx = curMethod.getAnnotation(AnTransaction.class)) != null) {
            hasTx = true;
            if (Validates.isEmpty((Object[])methodTx.value())) {
                allTx = true;
            } else {
                String[] stringArray = methodTx.value();
                int n3 = stringArray.length;
                n = 0;
                while (n < n3) {
                    String id = stringArray[n];
                    txIdList.add(id);
                    ++n;
                }
            }
        }
        Object result = null;
        Transaction tx = null;
        try {
            if (hasTx) {
                String[] ids = allTx ? new String[]{} : Arrays.toFilterSameList(txIdList);
                tx = TransactionManager.beginTransaction((String[])ids);
            }
            curMethod.setAccessible(true);
            if (Modifier.isStatic(curMethod.getModifiers())) {
                result = curMethod.invoke(null, curParams);
            } else if (Validates.isNotEmpty((String)serviceId) && Global.hasService((String)serviceId)) {
                Service instance = Global.getService((String)serviceId);
                result = curMethod.invoke((Object)instance, curParams);
            } else if (this.innerObjs.contains(className)) {
                Object instance = this.getInnerObject(request, className);
                result = curMethod.invoke(instance, curParams);
            } else if (context.hasActionInstance(className)) {
                Action instance = context.getActionInstance(className);
                result = curMethod.invoke((Object)instance, curParams);
            } else if (curClass.isAnnotationPresent(AnNew.class)) {
                Object instance = curClass.newInstance();
                result = curMethod.invoke(instance, curParams);
            } else if (curClass.isAnnotationPresent(AnGlobal.class)) {
                Object instance = Global.getWithoutNew(curClass);
                result = curMethod.invoke(instance, curParams);
            } else {
                Object instance = this.instanceMap.get(className);
                if (instance == null) {
                    instance = curClass.newInstance();
                    this.instanceMap.put(className, instance);
                }
                result = curMethod.invoke(instance, curParams);
            }
            if (tx != null) {
                try {
                    tx.commit();
                }
                catch (Exception e) {
                    bootstrap.log(request, "[" + classNameId + "][" + methodName + "][tx.commit()\u5f02\u5e38]", e);
                    throw new Exception();
                }
            }
            if (response.isCommitted()) {
                bootstrap.log(request, "[" + classNameId + "][" + methodName + "][Commited]");
                return;
            }
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    bootstrap.log(request, "[" + className + "][" + methodName + "][tx.rollback\u5f02\u5e38]", e1);
                }
            }
            if (response.isCommitted()) {
                bootstrap.log(request, "[" + classNameId + "][" + methodName + "][Commited]");
                return;
            }
            String error = e.getMessage();
            if (e.getCause() != null && (error = e.getCause().getMessage()) == null) {
                error = "\u672a\u77e5\u9519\u8bef[" + e.getCause().getClass().getName() + "]";
            }
            if (error == null) {
                error = "\u672a\u77e5\u9519\u8bef";
            }
            bootstrap.log(request, "[" + classNameId + "][" + methodName + "]\u8c03\u7528\u5f02\u5e38", e);
            response.sendError(500, error);
            return;
        }
        finally {
            if (tx != null) {
                try {
                    tx.close();
                }
                catch (Exception e) {
                    bootstrap.log(request, "[" + classNameId + "][" + methodName + "][tx.close\u5f02\u5e38]", e);
                }
            }
        }
        int status = request.getResponseStatus();
        String text = request.getResponseText();
        if (Void.TYPE == curMethod.getReturnType()) {
            result = text;
        } else if (Int.class == curMethod.getReturnType()) {
            Int ret = (Int)result;
            status = ret.value();
            result = ret.desc();
        }
        if (result == null) {
            result = "";
        }
        if (status == 0) {
            bootstrap.log(request, "[" + classNameId + "][" + methodName + "]");
            response.sendContent(200, result.toString());
        } else {
            bootstrap.log(request, "[" + classNameId + "][" + methodName + "][" + status + "]");
            if (status >= 601 && status <= 603) {
                response.sendContent(status, result.toString());
            } else {
                response.sendError(status, result.toString());
            }
        }
    }

    public boolean chkInterceptor(HttpRequest request, HttpResponse response, String interceptors, String classNameId, String methodName) throws IOException {
        if (Validates.isEmpty((String)interceptors)) {
            return true;
        }
        Context context = (Context)request.getContext();
        ZmlBootstrap bootstrap = context.getBootstrap();
        List<Interceptor> interceptorList = context.getInterceptorList(interceptors);
        for (Interceptor interceptor : interceptorList) {
            block6: {
                if (interceptor == null) {
                    bootstrap.log(request, "[" + classNameId + "][" + methodName + "][\u62e6\u622a\u5668(" + interceptors + ")]\u67d0\u4e2a\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ba1\u7406\u5458\u68c0\u67e5\u914d\u7f6e");
                    response.sendError(621, "[\u62e6\u622a\u5668(" + interceptors + ")]\u67d0\u4e2a\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ba1\u7406\u5458\u68c0\u67e5\u914d\u7f6e");
                    return false;
                }
                try {
                    interceptor.intercept(request);
                    if (!response.isCommitted()) break block6;
                    bootstrap.log(request, "[" + classNameId + "][" + methodName + "][\u62e6\u622a\u5668(" + interceptor + ")]\u76f4\u63a5\u5904\u7406\u7ed3\u679c");
                    return false;
                }
                catch (Exception e) {
                    bootstrap.log(request, "[" + classNameId + "][" + methodName + "][\u62e6\u622a\u5668(" + interceptor + ")]\u8c03\u7528\u5f02\u5e38," + e.getMessage(), e);
                    response.sendError(623, e.getMessage() == null ? "\u672a\u77e5\u9519\u8bef" : e.getMessage());
                    return false;
                }
            }
            if (request.isResponseSuccess()) continue;
            int status = request.getResponseStatus();
            String text = request.getResponseText();
            response.sendError(status, text);
            bootstrap.log(request, "[" + classNameId + "][" + methodName + "][\u62e6\u622a\u5668(" + interceptor + ")]\u62e6\u622a" + (request.isResponseRedirect() ? "\u5e76\u91cd\u5b9a\u5411" : ""));
            return false;
        }
        return true;
    }

    private Class<?> getClass(HttpRequest request, String serviceId, String className) {
        if (Validates.isNotEmpty((String)serviceId)) {
            Service service = Global.getService((String)serviceId);
            if (service == null) {
                return null;
            }
            Class<?> clazz = service.getClass();
            if (Validates.isEmpty((String)className) || className.equals(clazz.getName())) {
                return clazz;
            }
            return null;
        }
        Class<?> clazz = Global.getClass((String)className);
        if (clazz != null) {
            return clazz;
        }
        clazz = this.classMap.get(className);
        if (clazz != null) {
            return clazz;
        }
        clazz = this.getInnerClass(request, className);
        if (clazz != null) {
            return clazz;
        }
        clazz = Classes.forName((String)className);
        if (clazz == null) {
            return null;
        }
        this.classMap.put(className, clazz);
        return clazz;
    }

    private Method getMethod(HttpRequest request, HttpResponse response, Class<?> curClass, List<Object> curParams) {
        Method[] mtds;
        String methodName = request.getHeader("X-RMI-Method");
        List<String> paramList = this.parseParameters(request);
        Method[] methodArray = mtds = curClass.getMethods();
        int n = mtds.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            AnAlias alias = method.getAnnotation(AnAlias.class);
            if (methodName.equals(method.getName()) || alias != null && methodName.equals(alias.value())) {
                Class<?>[] paramTypes = method.getParameterTypes();
                int reqRespNum = 0;
                Class<?>[] classArray = paramTypes;
                int n3 = paramTypes.length;
                int n4 = 0;
                while (n4 < n3) {
                    Class<?> clazz = classArray[n4];
                    if (clazz == HttpRequest.class || clazz == HttpResponse.class) {
                        ++reqRespNum;
                    }
                    ++n4;
                }
                if (paramTypes.length - reqRespNum == paramList.size()) {
                    boolean isMatch = true;
                    Object[] paramValues = new Object[paramTypes.length];
                    int i = 0;
                    int ind = 0;
                    while (i < paramTypes.length) {
                        if (paramTypes[i] == HttpRequest.class) {
                            paramValues[i] = request;
                        } else if (paramTypes[i] == HttpResponse.class) {
                            paramValues[i] = response;
                        } else {
                            Object param = Strings.toObject(paramTypes[i], (String)paramList.get(ind));
                            if (param == null) {
                                isMatch = false;
                                break;
                            }
                            paramValues[i] = param;
                            ++ind;
                        }
                        ++i;
                    }
                    if (isMatch) {
                        Object[] objectArray = paramValues;
                        int n5 = paramValues.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            Object obj = objectArray[n6];
                            curParams.add(obj);
                            ++n6;
                        }
                        return method;
                    }
                }
            }
            ++n2;
        }
        return null;
    }

    private List<String> parseParameters(HttpRequest request) {
        if (request.isMimeForm()) {
            return new ArrayList<String>();
        }
        String parameters = request.getInputStreamString();
        if (Validates.isEmptyBlank((String)parameters)) {
            return new ArrayList<String>();
        }
        parameters = Urls.decodeUTF8((String)parameters);
        ArrayList<String> paramList = new ArrayList<String>();
        int i = 0;
        int start = 0;
        int end = parameters.indexOf(35);
        while (end != -1) {
            if (i % 2 != 0) {
                String param = parameters.substring(start + 1, end);
                if (param.indexOf("-%2-%-3%-") != -1) {
                    param = param.replaceAll("-%2-%-3%-", "#");
                }
                paramList.add(param);
            }
            ++i;
            start = end;
            end = parameters.indexOf(35, start + 1);
        }
        return paramList;
    }

    private Class<?> getInnerClass(HttpRequest request, String className) {
        if (!this.innerObjs.contains(className)) {
            return null;
        }
        if ("context".equals(className)) {
            return request.getContext().getClass();
        }
        if ("log".equals(className)) {
            return request.getLog().getClass();
        }
        if ("session".equals(className)) {
            return request.getSession() == null ? null : request.getSession().getClass();
        }
        return request.getSessionUser() == null ? null : request.getSessionUser().getClass();
    }

    private Object getInnerObject(HttpRequest request, String className) {
        if (!this.innerObjs.contains(className)) {
            return null;
        }
        if ("context".equals(className)) {
            return request.getContext();
        }
        if ("log".equals(className)) {
            return request.getLog();
        }
        if ("session".equals(className)) {
            return request.getSession();
        }
        return request.getSessionUser();
    }
}

