/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.context.config;

import org.zhiqim.httpd.context.ZmlConfig;
import org.zhiqim.httpd.context.ZmlContextConstants;
import org.zhiqim.httpd.context.config.ZAction;
import org.zhiqim.httpd.context.config.ZActionMap;
import org.zhiqim.httpd.context.config.ZActionPackageLoader;
import org.zhiqim.httpd.context.config.ZConfig;
import org.zhiqim.kernel.control.Filter;
import org.zhiqim.kernel.control.FilterEndsWith;
import org.zhiqim.kernel.control.FilterHandler;
import org.zhiqim.kernel.util.Resources;

public class ZActionPackage
implements ZmlContextConstants {
    private final ZmlConfig zmlConfig;
    private final String actionPackage;
    private final ZActionMap actionMap;

    public ZActionPackage(ZmlConfig zmlConfig, ZConfig config, String actionPackage) {
        this.zmlConfig = zmlConfig;
        this.actionPackage = actionPackage;
        this.actionMap = new ZActionMap(zmlConfig, config);
    }

    public void load() {
        Filter filter = new FilterEndsWith().param((Object)".class");
        ZActionPackageLoader handler = new ZActionPackageLoader(this);
        Resources.scanClassPath((Filter)filter, (FilterHandler)handler);
    }

    public String getActionPackage() {
        return this.actionPackage;
    }

    public void addActionOnPackage(ZAction action) {
        this.actionMap.addAction(action);
    }

    public ZmlConfig getConfig() {
        return this.zmlConfig;
    }

    public ZAction getInTurnAction(String path) {
        ZAction action = this.actionMap.getExactAction(path);
        if (action != null) {
            return action;
        }
        return this.actionMap.getFuzzyAction(path);
    }

    public ZAction getExactAction(String path) {
        return this.actionMap.getExactAction(path);
    }

    public ZAction getFuzzyAction(String path) {
        return this.actionMap.getFuzzyAction(path);
    }

    public ZAction getInTurnActionByClass(String clazz) {
        ZAction action = this.actionMap.getExactActionByClass(clazz);
        if (action != null) {
            return action;
        }
        return this.actionMap.getFuzzyActionByClass(clazz);
    }

    public ZAction getExactActionByClass(String clazz) {
        return this.actionMap.getExactActionByClass(clazz);
    }

    public ZAction getFuzzyActionByClass(String clazz) {
        return this.actionMap.getFuzzyActionByClass(clazz);
    }
}

