/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpdConstants;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Streams;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;

public class HttpUploader
implements HttpdConstants,
AutoCloseable {
    private static final String CONTENT_DISPOSITION = "Content-Disposition:";
    private static final String CONTENT_TYPE = "Content-Type:";
    private HashMap<String, String> parameters = new HashMap();
    private String name;
    private String fileContentType;
    private String fileName;
    private ByteArrayOutputStream fileContent = new ByteArrayOutputStream();

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public HashMap<String, String> getParameters() {
        return this.parameters;
    }

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileExt() {
        return Files.getFileExt((String)this.fileName);
    }

    public String getFileContentType() {
        return this.fileContentType;
    }

    public byte[] getBytes() {
        return this.fileContent.toByteArray();
    }

    public int getFileSize() {
        return this.fileContent.size();
    }

    public void writeTo(OutputStream out) throws IOException {
        this.fileContent.writeTo(out);
    }

    public void writeToFile(String filePath) throws IOException {
        Files.write((String)filePath, (byte[])this.fileContent.toByteArray());
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.fileContent.toByteArray());
    }

    @Override
    public void close() {
        try {
            this.fileContent.close();
        }
        catch (IOException iOException) {}
        this.fileContent = null;
    }

    public void parseHttpRequest(HttpRequest request, int maxSize) throws Exception {
        int contentLength = request.getContentLength();
        if (contentLength == 0) {
            throw new Exception("\u975e\u6cd5\u7684\u6587\u4ef6\u4e0a\u4f20\u4fe1\u606f[contentLength == 0]");
        }
        if (contentLength > maxSize) {
            throw new Exception("\u6587\u4ef6\u8d85\u8fc7\u5927\u5c0f[contentLength == " + contentLength + "]");
        }
        String contentType = request.getContentType();
        if (contentType == null) {
            throw new Exception("\u975e\u6cd5\u7684\u6587\u4ef6\u4e0a\u4f20\u4fe1\u606f[contentType == null]");
        }
        if (!contentType.startsWith("multipart/form-data")) {
            throw new Exception("\u975e\u6cd5\u7684\u6587\u4ef6\u4e0a\u4f20\u4fe1\u606f[contentType == " + contentType + "]");
        }
        int ind = contentType.indexOf("boundary=");
        if (ind == -1) {
            throw new Exception("\u975e\u6cd5\u7684\u6587\u4ef6\u4e0a\u4f20\u4fe1\u606f[contentType == " + contentType + "]");
        }
        String boundary = contentType.substring(ind + "boundary=".length());
        byte[] buffer = new byte[4096];
        InputStream input = request.getInputStream();
        int len = 0;
        String name = null;
        String curContentType = null;
        int type = 0;
        boolean isSkinEmptyLine = false;
        boolean isLastBR = false;
        while ((len = Streams.readLine((InputStream)input, (byte[])buffer, (int)buffer.length)) != -1) {
            String line = new String(buffer, 0, len, request.getCharacterEncoding());
            if (line.startsWith("--" + boundary + "--")) break;
            if (line.startsWith("--" + boundary)) {
                type = 0;
                isSkinEmptyLine = false;
                continue;
            }
            if (!isSkinEmptyLine && Validates.isEmptyBlank((String)line)) {
                isSkinEmptyLine = true;
                continue;
            }
            if (Strings.startsWithIgnoreCase((String)line, (String)CONTENT_DISPOSITION)) {
                String formData = line.substring(CONTENT_DISPOSITION.length()).trim();
                name = this.parseFormDataName(formData);
                if (name == null) {
                    isSkinEmptyLine = false;
                    continue;
                }
                String filename = this.parseFormDataFileName(formData);
                if (filename == null) {
                    type = 1;
                    if (this.parameters.containsKey(name)) continue;
                    this.parameters.put(name, null);
                    continue;
                }
                type = 2;
                this.name = name;
                this.fileName = filename;
                continue;
            }
            if (Strings.startsWithIgnoreCase((String)line, (String)CONTENT_TYPE)) {
                curContentType = line.substring(CONTENT_TYPE.length()).trim();
                if (type == 2) {
                    this.fileContentType = curContentType;
                }
                isSkinEmptyLine = false;
                continue;
            }
            if (type == 1) {
                this.parseFormValue(request, name, line);
                isSkinEmptyLine = false;
                continue;
            }
            if (type != 2) continue;
            if (isLastBR) {
                this.fileContent.write(_CRLF_);
                isLastBR = false;
            }
            if (!line.endsWith("\r\n")) {
                this.fileContent.write(buffer, 0, len);
                continue;
            }
            this.fileContent.write(buffer, 0, len - 2);
            isLastBR = true;
        }
    }

    private String parseFormDataName(String formData) {
        String key = "name=\"";
        int ind = formData.indexOf(key);
        if (ind == -1) {
            return null;
        }
        int ind2 = formData.indexOf("\"", ind + key.length());
        if (ind2 == -1) {
            return null;
        }
        return formData.substring(ind + key.length(), ind2);
    }

    private String parseFormDataFileName(String formData) {
        String key = "filename=\"";
        int ind = formData.indexOf(key);
        if (ind == -1) {
            return null;
        }
        int ind2 = formData.indexOf("\"", ind + key.length());
        if (ind2 == -1) {
            return null;
        }
        String name = formData.substring(ind + key.length(), ind2);
        return name;
    }

    private void parseFormValue(HttpRequest request, String name, String line) {
        line = line.replaceAll("\r", "");
        line = line.replaceAll("\n", "");
        String value = this.parameters.get(name);
        if (value == null) {
            this.parameters.put(name, line);
            request.setParameterOnCNT(name, line);
        } else {
            this.parameters.put(name, String.valueOf(value) + "," + line);
            request.setParameterOnCNT(name, String.valueOf(value) + "," + line);
        }
    }
}

