/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd;

import java.util.ArrayList;
import java.util.List;
import org.zhiqim.httpd.HttpRequestValidate;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Urls;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.kernel.util.consts.Int;

public abstract class HttpRequestResponse
extends HttpRequestValidate {
    private boolean isReturn;
    private int responseStatus;
    private String forward;
    private String redirect;
    private String view;
    private String include;
    private String executeMethod;
    private String alertMsg;
    private List<String[]> paramList;

    @Override
    public void setResponseConfig(String view, String include, String forward, String redirect, String method, String alert) {
        this.isReturn = !Validates.isEmptyBlank((String)view) || !Validates.isEmptyBlank((String)forward) || !Validates.isEmptyBlank((String)redirect);
        this.view = view;
        this.include = include;
        this.forward = forward;
        this.redirect = redirect;
        this.executeMethod = method;
        this.alertMsg = alert;
    }

    @Override
    public void setReturn(boolean isReturn) {
        this.isReturn = isReturn;
    }

    @Override
    public void setView(String view, String include) {
        this.responseStatus = 0;
        this.view = view;
        this.include = include;
        this.forward = null;
        this.redirect = null;
        this.isReturn = true;
    }

    @Override
    public void setForward(String forwardTo) {
        this.responseStatus = 0;
        this.forward = forwardTo;
        this.view = null;
        this.redirect = null;
        this.isReturn = true;
    }

    @Override
    public void setRedirect(String redirect) {
        this.responseStatus = 602;
        this.setRedirectInner(redirect);
    }

    @Override
    public void setRedirectInner(String redirect) {
        this.redirect = redirect;
        this.view = null;
        this.forward = null;
        this.isReturn = true;
    }

    @Override
    public void addParam(String key, Object value) {
        if (value == null) {
            value = "";
        }
        if (this.paramList == null) {
            this.paramList = new ArrayList<String[]>(2);
        }
        this.paramList.add(new String[]{key, String.valueOf(value)});
    }

    @Override
    public void setAlertMsg(String alert) {
        this.alertMsg = alert;
    }

    @Override
    public String getExecuteMethod() {
        return this.executeMethod;
    }

    @Override
    public String getAlertMsg() {
        return this.alertMsg;
    }

    @Override
    public boolean isReturn() {
        return this.isReturn ? Validates.isNotEmpty((String)this.view) || Validates.isNotEmpty((String)this.forward) || Validates.isNotEmpty((String)this.redirect) : false;
    }

    @Override
    public String getView() {
        return this.view;
    }

    @Override
    public String getInclude() {
        return this.include;
    }

    @Override
    public String getForward(String encoding) {
        if (Validates.isEmpty(this.paramList)) {
            return this.forward;
        }
        for (String[] param : this.paramList) {
            String value = Urls.encode((String)param[1], (String)encoding);
            this.forward = Urls.add((String)this.forward, (String)param[0], (String)value);
        }
        return this.forward;
    }

    @Override
    public String getRedirectInner() {
        return this.redirect;
    }

    @Override
    public String getRedirect(String encoding) {
        if (this.redirect == null) {
            return this.redirect;
        }
        if ("-1".equals(this.redirect)) {
            return this.redirect;
        }
        if ("closeWindow".equals(this.redirect)) {
            return this.redirect;
        }
        if ("closeDialog".equals(this.redirect)) {
            return this.redirect;
        }
        if (Strings.startsWith((String)this.redirect, (String)"javascript:")) {
            return this.redirect;
        }
        if (Validates.isEmpty(this.paramList)) {
            return this.redirect;
        }
        for (String[] param : this.paramList) {
            String value = Urls.encode((String)param[1], (String)encoding);
            this.redirect = Urls.add((String)this.redirect, (String)param[0], (String)value);
        }
        return this.redirect;
    }

    @Override
    public void returnHistory() {
        this.setRedirect("-1");
    }

    @Override
    public void returnHistory(String errorMsg) {
        this.setRedirect("-1");
        this.setAlertMsg(errorMsg);
    }

    @Override
    public void returnCloseWindow() {
        this.setRedirect("closeWindow");
    }

    @Override
    public void returnCloseWindow(String errorMsg) {
        this.setRedirect("closeWindow");
        this.setAlertMsg(errorMsg);
    }

    @Override
    public void returnCloseDialog() {
        this.setRedirect("closeDialog");
    }

    @Override
    public void returnCloseDialog(String errorMsg) {
        this.setRedirect("closeDialog");
        this.setAlertMsg(errorMsg);
    }

    @Override
    public boolean isForceReturn() {
        if (Validates.isNotEmpty((String)this.alertMsg)) {
            return true;
        }
        if ("-1".equals(this.redirect) || "closeWindow".equals(this.redirect) || "closeDialog".equals(this.redirect)) {
            return true;
        }
        if (Strings.startsWith((String)this.redirect, (String)"javascript:")) {
            return true;
        }
        if (this.responseStatus == 601 || this.responseStatus == 603) {
            return true;
        }
        return this.getParameterBoolean("zCallFrame");
    }

    @Override
    public int getForceReturnType() {
        if (this.redirect == null) {
            return -1;
        }
        if ("-1".equals(this.redirect)) {
            return 1;
        }
        if ("closeWindow".equals(this.redirect)) {
            return 2;
        }
        if ("closeDialog".equals(this.redirect)) {
            return 3;
        }
        if (Strings.startsWith((String)this.redirect, (String)"javascript:")) {
            return 4;
        }
        return 0;
    }

    @Override
    public int getResponseStatus() {
        return this.responseStatus;
    }

    @Override
    public String getResponseText() {
        if (!this.isResponseRedirect()) {
            return this.alertMsg;
        }
        if (Validates.isEmptyBlank((String)this.alertMsg)) {
            return this.getRedirect("UTF-8");
        }
        return String.valueOf(this.getRedirect("UTF-8")) + "#" + this.alertMsg;
    }

    @Override
    public boolean isResponseSuccess() {
        return this.responseStatus == 0;
    }

    @Override
    public boolean isResponseRedirect() {
        return this.responseStatus >= 601 && this.responseStatus <= 603;
    }

    @Override
    public void setResponseResult(int responseStatus, String responseText) {
        if (responseStatus < 0 || responseStatus >= 70 && responseStatus <= 699) {
            throw new RuntimeException("\u54cd\u5e94\u72b6\u6001\u7801\u4e0d\u5141\u8bb8\u5728(\u5c0f\u4e8e0\u548c100-300\u548c 304-699)\u4e4b\u95f4\u6570");
        }
        this.responseStatus = responseStatus;
        this.setAlertMsg(responseText);
    }

    @Override
    public void setResponseResult(Int result) {
        this.setResponseResult(result.value(), result.desc());
    }

    @Override
    public void setResponseResult(String responseText) {
        this.responseStatus = 0;
        this.setAlertMsg(responseText);
    }

    @Override
    public void setResponseError(String responseText) {
        this.responseStatus = 699;
        this.setAlertMsg(responseText);
    }

    @Override
    public void setRedirectParent(String redirect) {
        this.responseStatus = 601;
        this.setRedirectInner(redirect);
    }

    @Override
    public void setRedirectTop(String redirect) {
        this.responseStatus = 603;
        this.setRedirectInner(redirect);
    }

    @Override
    public void setRedirect(String redirect, String error) {
        if (Validates.isEmptyBlank((String)error)) {
            this.setRedirect(redirect);
            return;
        }
        this.setRedirect(redirect);
        this.setAlertMsg(error);
    }

    @Override
    public void setRedirectParent(String redirect, String error) {
        if (Validates.isEmptyBlank((String)error)) {
            this.setRedirectParent(redirect);
            return;
        }
        this.responseStatus = 601;
        this.setRedirectInner(redirect);
        this.setAlertMsg(error);
    }

    @Override
    public void setRedirectTop(String redirect, String error) {
        if (Validates.isEmptyBlank((String)error)) {
            this.setRedirectTop(redirect);
            return;
        }
        this.responseStatus = 603;
        this.setRedirectInner(redirect);
        this.setAlertMsg(error);
    }

    @Override
    protected void destroy() {
        super.destroy();
        if (this.paramList != null) {
            this.paramList.clear();
            this.paramList = null;
        }
        this.forward = null;
        this.redirect = null;
        this.view = null;
        this.executeMethod = null;
        this.alertMsg = null;
    }
}

