/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util.codes;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.zhiqim.kernel.constants.CodeConstants;
import org.zhiqim.kernel.extend.KV;
import org.zhiqim.kernel.extend.SS;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Hexs;
import org.zhiqim.kernel.util.codes.Base64;

public class RSA
implements CodeConstants {
    public static SS buildKeyPair() {
        return RSA.buildKeyPairBase64(1024);
    }

    public static SS buildKeyPairBase64(int keySize) {
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
            keyPairGen.initialize(keySize);
            KeyPair keyPair = keyPairGen.generateKeyPair();
            String publicKey = Base64.encode(keyPair.getPublic().getEncoded());
            String privateKey = Base64.encode(keyPair.getPrivate().getEncoded());
            return new SS(publicKey, privateKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw Asserts.exception(e);
        }
    }

    public static KV<byte[], byte[]> buildKeyPair(int keySize) {
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
            keyPairGen.initialize(keySize);
            KeyPair keyPair = keyPairGen.generateKeyPair();
            return new KV<byte[], byte[]>(keyPair.getPublic().getEncoded(), keyPair.getPrivate().getEncoded());
        }
        catch (NoSuchAlgorithmException e) {
            throw Asserts.exception(e);
        }
    }

    public static byte[] encrypt(byte[] src, String publicKey) throws Exception {
        return RSA.encrypt(src, Base64.decode(publicKey));
    }

    public static byte[] encrypt(byte[] src, byte[] publicKey) throws Exception {
        int keySize = 0;
        switch (publicKey.length) {
            case 94: {
                keySize = 512;
                break;
            }
            case 162: {
                keySize = 1024;
                break;
            }
            case 294: {
                keySize = 2048;
                break;
            }
            case 422: {
                keySize = 3072;
                break;
            }
            case 550: {
                keySize = 4096;
            }
        }
        Asserts.as(keySize != 0 ? null : "\u65e0\u6cd5\u5339\u914d\u5bc6\u94a5\u957f\u5ea6\uff0c\u8bf7\u8c03\u7528encrypt(byte[] src, byte[] publicKey, int keySize)\u65b9\u6cd5");
        return RSA.encrypt(src, publicKey, keySize);
    }

    public static byte[] encrypt(byte[] src, byte[] publicKey, int keySize) throws Exception {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKey);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey key = keyFactory.generatePublic(keySpec);
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, key);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int length = src.length;
        int chunkSize = keySize / 8 - 11;
        int i = 0;
        while (i * chunkSize < length) {
            int count = length > (i + 1) * chunkSize ? chunkSize : length - i * chunkSize;
            out.write(cipher.doFinal(src, i * chunkSize, count));
            ++i;
        }
        return out.toByteArray();
    }

    public static byte[] decrypt(byte[] src, String privateKey) throws Exception {
        return RSA.decrypt(src, Base64.decode(privateKey));
    }

    public static byte[] decrypt(byte[] src, byte[] privateKey) throws Exception {
        int keyLen = privateKey.length;
        int keySize = 0;
        if (keyLen >= 330 && keyLen <= 360) {
            keySize = 512;
        } else if (keyLen >= 620 && keyLen <= 650) {
            keySize = 1024;
        } else if (keyLen >= 1200 && keyLen <= 1230) {
            keySize = 2048;
        } else if (keyLen >= 1780 && keyLen <= 1710) {
            keySize = 3072;
        } else if (keyLen >= 2360 && keyLen <= 2390) {
            keySize = 4096;
        }
        Asserts.as(keySize != 0 ? null : "\u65e0\u6cd5\u5339\u914d\u5bc6\u94a5\u957f\u5ea6\uff0c\u8bf7\u8c03\u7528decrypt(byte[] src, byte[] keyBytes, int keySize)\u65b9\u6cd5");
        return RSA.decrypt(src, privateKey, keySize);
    }

    public static byte[] decrypt(byte[] src, byte[] privateKey, int keySize) throws Exception {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKey);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey key = keyFactory.generatePrivate(keySpec);
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, key);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int length = src.length;
        int chunkSize = keySize / 8;
        int i = 0;
        while (i * chunkSize < length) {
            int count = length > (i + 1) * chunkSize ? chunkSize : length - i * chunkSize;
            out.write(cipher.doFinal(src, i * chunkSize, count));
            ++i;
        }
        return out.toByteArray();
    }

    public static byte[] encrypt(String src, Charset charset, String publicKey) throws Exception {
        return RSA.encrypt(src.getBytes(charset), publicKey);
    }

    public static byte[] encrypt(String src, String encoding, String publicKey) throws Exception {
        return RSA.encrypt(src, Charset.forName(encoding), publicKey);
    }

    public static String decrypt(byte[] src, String privateKey, Charset charset) throws Exception {
        return new String(RSA.decrypt(src, privateKey), charset);
    }

    public static String decrypt(byte[] src, String privateKey, String encoding) throws Exception {
        return RSA.decrypt(src, privateKey, Charset.forName(encoding));
    }

    public static String encryptBase64UTF8(String src, String publicKey) throws Exception {
        return RSA.encryptBase64(src, _UTF_8_C_, publicKey);
    }

    public static String encryptBase64(String src, String encoding, String publicKey) throws Exception {
        return RSA.encryptBase64(src, Charset.forName(encoding), publicKey);
    }

    public static String encryptBase64(String src, Charset charset, String publicKey) throws Exception {
        return Base64.encode(RSA.encrypt(src.getBytes(charset), publicKey));
    }

    public static String decryptBase64UTF8(String src, String privateKey) throws Exception {
        return RSA.decryptBase64(src, privateKey, _UTF_8_C_);
    }

    public static String decryptBase64(String src, String privateKey, String encoding) throws Exception {
        return RSA.decryptBase64(src, privateKey, Charset.forName(encoding));
    }

    public static String decryptBase64(String src, String privateKey, Charset charset) throws Exception {
        byte[] bytes = Base64.decode(src);
        return new String(RSA.decrypt(bytes, privateKey), charset);
    }

    public static String encryptHexUTF8(String src, String publicKey) throws Exception {
        return RSA.encryptHex(src, _UTF_8_C_, publicKey);
    }

    public static String encryptHex64(String src, String encoding, String publicKey) throws Exception {
        return RSA.encryptHex(src, Charset.forName(encoding), publicKey);
    }

    public static String encryptHex(String src, Charset charset, String publicKey) throws Exception {
        return Hexs.toHexString(RSA.encrypt(src.getBytes(charset), publicKey));
    }

    public static String decryptHexUTF8(String src, String privateKey) throws Exception {
        return RSA.decryptHex(src, privateKey, _UTF_8_C_);
    }

    public static String decryptHex(String src, String privateKey, String encoding) throws Exception {
        return RSA.decryptHex(src, privateKey, Charset.forName(encoding));
    }

    public static String decryptHex(String src, String privateKey, Charset charset) throws Exception {
        byte[] bytes = Hexs.toBytes(src);
        return new String(RSA.decrypt(bytes, privateKey), charset);
    }
}

