/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util;

import java.security.SecureRandom;
import java.util.Random;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.SignConstants;

@AnAlias(value={"Randoms"})
public class Randoms
implements SignConstants {
    public static String digits(int length) {
        return Randoms.random(length, "0123456789", false);
    }

    public static String digitsSecure(int length, boolean secure) {
        return Randoms.random(length, "0123456789", true);
    }

    public static String upperLetters(int length) {
        return Randoms.random(length, "ABCDEFGHIJKLMNOPQRSTUVWXYZ", false);
    }

    public static String upperLettersSecure(int length) {
        return Randoms.random(length, "ABCDEFGHIJKLMNOPQRSTUVWXYZ", true);
    }

    public static String lowerLetters(int length) {
        return Randoms.random(length, "abcdefghijklmnopqrstuvwxyz", false);
    }

    public static String lowerLettersSecure(int length) {
        return Randoms.random(length, "abcdefghijklmnopqrstuvwxyz", true);
    }

    public static String lowerLettersDigits(int length) {
        return Randoms.random(length, "0123456789abcdefghijklmnopqrstuvwxyz", false);
    }

    public static String lowerLettersDigitsSecure(int length) {
        return Randoms.random(length, "0123456789abcdefghijklmnopqrstuvwxyz", true);
    }

    public static String letters(int length) {
        return Randoms.random(length, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz", false);
    }

    public static String lettersSecure(int length) {
        return Randoms.random(length, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz", true);
    }

    public static String lettersDigits(int length) {
        return Randoms.random(length, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", false);
    }

    public static String lettersDigitsSecure(int length) {
        return Randoms.random(length, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", true);
    }

    public static String symbol(int length) {
        return Randoms.random(length, ".`_~!@#$%", false);
    }

    public static String symbolSecure(int length) {
        return Randoms.random(length, ".`_~!@#$%", true);
    }

    public static String random(int length, String content) {
        return Randoms.random(length, content, false);
    }

    public static String random(int length, String content, boolean secure) {
        int len = content.length();
        StringBuilder strb = new StringBuilder();
        Random random = secure ? new SecureRandom() : new Random();
        int i = 0;
        while (i < length) {
            int index = random.nextInt(len);
            strb.append(content.charAt(index));
            ++i;
        }
        return strb.toString();
    }

    public static String random(int length, int type) {
        return Randoms.random(length, type, false);
    }

    public static String random(int length, int type, boolean secure) {
        if (length < 1) {
            return "";
        }
        String content = null;
        switch (type) {
            case 1: {
                content = "0123456789";
                break;
            }
            case 2: {
                content = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
                break;
            }
            case 3: {
                content = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
                break;
            }
            case 4: {
                content = "abcdefghijklmnopqrstuvwxyz";
                break;
            }
            case 5: {
                content = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
                break;
            }
            case 6: {
                content = "abcdefghijklmnopqrstuvwxyz0123456789";
                break;
            }
            default: {
                content = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
            }
        }
        return Randoms.random(length, content, secure);
    }
}

