/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.EnumConstants;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Ints;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;

@AnAlias(value={"DateTimes"})
public class DateTimes
implements EnumConstants {
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String MMDDHHMMSS = "MMddHHmmss";
    public static final String MMDDHHMM = "MMddHHmm";
    public static final String MMDD = "MMdd";

    public static Date nowDate() {
        return new Date();
    }

    public static Calendar toCalendar(String datetime) {
        int index = datetime.indexOf(32);
        String date = datetime.substring(0, index);
        String time = datetime.substring(index + 1);
        return DateTimes.toCalendar(date, time);
    }

    public static Calendar toCalendar(String date, String time) {
        Asserts.notEmptyBlank(date, "date");
        Asserts.notEmptyBlank(time, "time");
        int dateSlash1 = date.indexOf(45);
        int dateSlash2 = date.lastIndexOf(45);
        Asserts.as(dateSlash1 > 0 ? null : "\u975e\u6cd5\u7684\u53c2\u6570date[" + date + "]");
        Asserts.as(dateSlash2 > dateSlash1 ? null : "\u975e\u6cd5\u7684\u53c2\u6570date[" + date + "]");
        String year = date.substring(0, dateSlash1);
        String month = date.substring(dateSlash1 + 1, dateSlash2);
        String day = date.substring(dateSlash2 + 1);
        return DateTimes.toCalendar(year, month, day, time);
    }

    public static Calendar toCalendar(String year, String month, String day, String time) {
        int timeColon1 = time.indexOf(58);
        int timeColon2 = time.lastIndexOf(58);
        Asserts.as(timeColon1 > 0 ? null : "\u975e\u6cd5\u7684\u53c2\u6570time[" + time + "]");
        Asserts.as(timeColon2 > timeColon1 ? null : "\u975e\u6cd5\u7684\u53c2\u6570time[" + time + "]");
        String hour = time.substring(0, timeColon1);
        String minute = time.substring(timeColon1 + 1, timeColon2);
        String second = time.substring(timeColon2 + 1);
        return DateTimes.toCalendar(year, month, day, hour, minute, second);
    }

    public static Calendar toCalendar(String year, String month, String day, String hour, String minute, String second) {
        int yyyy = Integer.parseInt(year);
        int MM = Integer.parseInt(month);
        int dd = Integer.parseInt(day);
        int HH = Integer.parseInt(hour);
        int mm = Integer.parseInt(minute);
        int ss = Integer.parseInt(second);
        return DateTimes.toCalendar(yyyy, MM, dd, HH, mm, ss);
    }

    public static Calendar toCalendar(int year, int month, int day, int hour, int minute, int second) {
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, month - 1);
        c.set(5, day);
        c.set(11, hour);
        c.set(12, minute);
        c.set(13, second);
        c.set(14, 0);
        return c;
    }

    public static Calendar toCalendarHttp(String datetime) {
        Asserts.as(Validates.isLen(datetime, 29, 29) ? null : "\u53c2\u6570[" + datetime + "]\u4e0d\u662fHTTP GMT\u6807\u51c6\u683c\u5f0f");
        String week = datetime.substring(0, 3);
        Asserts.as(Validates.isContain(_WEEKS_, week) ? null : "\u53c2\u6570[" + datetime + "]\u4e0d\u662fHTTP GMT\u6807\u51c6\u683c\u5f0f");
        char comma = datetime.charAt(3);
        Asserts.as(comma == ',' ? null : "\u53c2\u6570[" + datetime + "]\u4e0d\u662fHTTP GMT\u6807\u51c6\u683c\u5f0f");
        char space = datetime.charAt(4);
        Asserts.as(space == ' ' ? null : "\u53c2\u6570[" + datetime + "]\u4e0d\u662fHTTP GMT\u6807\u51c6\u683c\u5f0f");
        String day = datetime.substring(5, 7);
        Asserts.as(Validates.isDay(day) ? null : "\u53c2\u6570[" + datetime + "]\u4e0d\u662fHTTP GMT\u6807\u51c6\u683c\u5f0f");
        space = datetime.charAt(7);
        Asserts.as(space == ' ' ? null : "\u53c2\u6570[" + datetime + "]\u4e0d\u662fHTTP GMT\u6807\u51c6\u683c\u5f0f");
        String month = datetime.substring(8, 11);
        Asserts.as(Validates.isContain(_MONTHS_, month) ? null : "\u53c2\u6570[" + datetime + "]\u4e0d\u662fHTTP GMT\u6807\u51c6\u683c\u5f0f");
        space = datetime.charAt(11);
        Asserts.as(space == ' ' ? null : "\u53c2\u6570[" + datetime + "]\u4e0d\u662fHTTP GMT\u6807\u51c6\u683c\u5f0f");
        String year = datetime.substring(12, 16);
        Asserts.as(Validates.isYear(year) ? null : "\u53c2\u6570[" + datetime + "]\u4e0d\u662fHTTP GMT\u6807\u51c6\u683c\u5f0f");
        space = datetime.charAt(16);
        Asserts.as(space == ' ' ? null : "\u53c2\u6570[" + datetime + "]\u4e0d\u662fHTTP GMT\u6807\u51c6\u683c\u5f0f");
        String time = datetime.substring(17, 25);
        Asserts.as(Validates.isTime(time) ? null : "\u53c2\u6570[" + datetime + "]\u4e0d\u662fHTTP GMT\u6807\u51c6\u683c\u5f0f");
        space = datetime.charAt(25);
        Asserts.as(space == ' ' ? null : "\u53c2\u6570[" + datetime + "]\u4e0d\u662fHTTP GMT\u6807\u51c6\u683c\u5f0f");
        String gmt = datetime.substring(26);
        Asserts.as("GMT".equals(gmt) ? null : "\u53c2\u6570[" + datetime + "]\u4e0d\u662fHTTP GMT\u6807\u51c6\u683c\u5f0f");
        int m = Arrays.indexOf(_MONTHS_, month) + 1;
        Calendar calendar = DateTimes.toCalendar(year, Strings.prefixZero(m, 2), day, time);
        calendar.setTimeZone(new SimpleTimeZone(0, "GMT"));
        return calendar;
    }

    public static String toDateTimeString(Calendar calendar, String format) {
        return new SimpleDateFormat(format).format(calendar.getTime());
    }

    public static String toDateTimeString(Calendar calendar) {
        return new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS).format(calendar.getTime());
    }

    public static String toDateString(Calendar calendar) {
        return new SimpleDateFormat(YYYY_MM_DD).format(calendar.getTime());
    }

    public static String toDateTimeStringHttp(String datetime) {
        Calendar calendar = DateTimes.toCalendarHttp(datetime);
        return DateTimes.toDateTimeString(calendar);
    }

    public static String toDateTimeString(long datetime) {
        return new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS).format(new Date(datetime));
    }

    public static String toDateTimeSSSString(long datetime) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS").format(new Date(datetime));
    }

    public static String toDateTimeString(long datetime, String format) {
        return new SimpleDateFormat(format).format(new Date(datetime));
    }

    public static long toLong(int year, int month, int day, int hour, int minute, int second) {
        return DateTimes.toCalendar(year, month, day, hour, minute, second).getTimeInMillis();
    }

    public static long toLong(String year, String month, String day, String hour, String minute, String second) {
        return DateTimes.toCalendar(year, month, day, hour, minute, second).getTimeInMillis();
    }

    public static long toLong(String datetime) {
        return DateTimes.toCalendar(datetime).getTimeInMillis();
    }

    public static long toLong(String date, String time) {
        return DateTimes.toCalendar(date, time).getTimeInMillis();
    }

    public static long toLongHttp(String datetime) {
        Calendar calendar = DateTimes.toCalendarHttp(datetime);
        return calendar.getTimeInMillis();
    }

    public static String toDateString(Date date) {
        return new SimpleDateFormat(YYYY_MM_DD).format(date);
    }

    public static String toDateString(int yearDay) {
        Calendar c = Calendar.getInstance();
        c.set(6, yearDay);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return DateTimes.toDateTimeString(c, MMDD);
    }

    public static String toDateTimeString(Date date, String format) {
        return new SimpleDateFormat(format).format(date);
    }

    public static String toDateTimeString(Date date) {
        return new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS).format(date);
    }

    public static Date toDate(String datetime) {
        return DateTimes.toCalendar(datetime).getTime();
    }

    public static Date toDate(String date, String time) {
        return DateTimes.toCalendar(date, time).getTime();
    }

    public static Date toDate(String year, String month, String day, String hour, String minute, String second) {
        return DateTimes.toCalendar(year, month, day, hour, minute, second).getTime();
    }

    public static Date toDate(int year, int month, int day, int hour, int minute, int second) {
        return DateTimes.toCalendar(year, month, day, hour, minute, second).getTime();
    }

    public static String toTimeString(int hour, int minute, int second) {
        String h = "" + hour;
        String m = "" + minute;
        String s = "" + second;
        if (hour < 10) {
            h = "0" + hour;
        }
        if (minute < 10) {
            m = "0" + minute;
        }
        if (second < 10) {
            s = "0" + second;
        }
        return String.valueOf(h) + ":" + m + ":" + s;
    }

    public static String toTimeString(Date date) {
        return new SimpleDateFormat("HH:mm:ss").format(date);
    }

    public static int toDateInt(String date) {
        StringBuilder strb = new StringBuilder();
        int i = 0;
        while (i < date.length()) {
            char c = date.charAt(i);
            if (Validates.isDigit(c)) {
                strb.append(c);
            }
            ++i;
        }
        return Ints.toInt(strb.toString());
    }

    public static int getMonthDays(String yearMonth) {
        int year = Integer.parseInt(yearMonth.substring(0, 4));
        int month = Integer.parseInt(yearMonth.substring(4));
        return DateTimes.getMonthDays(year, month);
    }

    public static int getMonthDays(int yearMonth) {
        int year = yearMonth / 100;
        int month = yearMonth % 100;
        return DateTimes.getMonthDays(year, month);
    }

    public static int getMonthDays(int year, int month) {
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return 31;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
        }
        return Validates.isLeapYear(year) ? 29 : 28;
    }

    public static int getNextYearMonth(int yearMonth) {
        int year = yearMonth / 100;
        int month = yearMonth % 100;
        if (month < 12) {
            ++month;
        } else {
            ++year;
            month = 1;
        }
        return year * 100 + month;
    }

    public static String getNextYearMonth(String yearMonth) {
        int curYearMonth = Ints.toInt(yearMonth);
        return String.valueOf(DateTimes.getNextYearMonth(curYearMonth));
    }

    public static String getNextYearMonthSpe(String yearMonth) {
        yearMonth = yearMonth.replace("-", "");
        String nextYearMonth = DateTimes.getNextYearMonth(yearMonth);
        return String.valueOf(nextYearMonth.substring(0, 4)) + "-" + nextYearMonth.substring(4);
    }

    public static int getNextDateInt(int date) {
        int day = date % 100;
        int yearMonth = date / 100;
        int monthDays = DateTimes.getMonthDays(yearMonth);
        if (day < monthDays) {
            ++day;
        } else {
            yearMonth = DateTimes.getNextYearMonth(yearMonth);
            day = 1;
        }
        return yearMonth * 100 + day;
    }

    public static long getNextHour(long curHour) {
        long yearMonthDay = curHour / 100L;
        long hour = curHour % 100L;
        if (hour < 23L) {
            ++hour;
        } else {
            yearMonthDay = DateTimes.getNextDateInt((int)yearMonthDay);
            hour = 0L;
        }
        return yearMonthDay * 100L + hour;
    }

    public static long getNextMinute(long curMinute) {
        long yearMonthDayHour = curMinute / 100L;
        long minute = curMinute % 100L;
        if (minute < 59L) {
            ++minute;
        } else {
            yearMonthDayHour = DateTimes.getNextHour((int)yearMonthDayHour);
            minute = 0L;
        }
        return yearMonthDayHour * 100L + minute;
    }

    public static String getPreviousYearMonth(String yearMonth) {
        int year = Integer.parseInt(yearMonth.substring(0, 4));
        int month = Integer.parseInt(yearMonth.substring(4));
        if (month == 1) {
            --year;
            month = 12;
        } else {
            --month;
        }
        StringBuilder strb = new StringBuilder().append(year);
        if (month > 9) {
            strb.append(month);
        } else {
            strb.append("0").append(month);
        }
        return strb.toString();
    }

    public static String getPreviousYearMonthSpe(String yearMonth) {
        yearMonth = yearMonth.replace("-", "");
        String prevYearMonth = DateTimes.getPreviousYearMonth(yearMonth);
        return String.valueOf(prevYearMonth.substring(0, 4)) + "-" + prevYearMonth.substring(4);
    }

    public static int getPreviousDateInt(int date) {
        int year = date / 10000;
        int month = date / 100 % 100;
        int day = date % 100;
        if (day == 1) {
            year = month == 1 ? year - 1 : year;
            month = month == 1 ? 12 : month - 1;
            day = DateTimes.getMonthDays(year, month);
            return year * 10000 + month * 100 + day;
        }
        return year * 10000 + month * 100 + --day;
    }

    public static String getLastMonthDay(String yearMonth) {
        String yearStr = yearMonth.substring(0, 4);
        String monthStr = yearMonth.substring(4);
        int year = Integer.parseInt(yearStr);
        int month = Integer.parseInt(monthStr);
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return String.valueOf(yearStr) + "-" + monthStr + "-31";
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return String.valueOf(yearStr) + "-" + monthStr + "-30";
            }
            case 2: {
                int day = Validates.isLeapYear(year) ? 29 : 28;
                return String.valueOf(yearStr) + "-" + monthStr + "-" + day;
            }
        }
        throw Asserts.exception("\u8bf7\u6c42\u53c2\u6570[" + yearMonth + "]\u683c\u5f0f\u4e0d\u5bf9\u6216\u6570\u636e\u4e0d\u5bf9");
    }

    public static int compareYear(Date date1, Date date2) {
        Asserts.notNull(date1, "date1");
        Asserts.notNull(date2, "date2");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date1);
        int year1 = calendar.get(1);
        calendar.setTime(date2);
        int year2 = calendar.get(1);
        return year1 - year2;
    }

    public static int compareMonth(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return 0;
        }
        int year = DateTimes.compareYear(date1, date2);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date1);
        int month1 = calendar.get(2);
        calendar.setTime(date2);
        int month2 = calendar.get(2);
        return 12 * year + (month1 - month2);
    }

    public static int compareMonth(String date1, String date2) {
        if (date1 == null || date2 == null) {
            return 0;
        }
        int year1 = Integer.parseInt(date1.substring(0, 4));
        int year2 = Integer.parseInt(date2.substring(0, 4));
        int month1 = Integer.parseInt(date1.substring(5, 7));
        int month2 = Integer.parseInt(date2.substring(5, 7));
        int day1 = Integer.parseInt(date1.substring(8, 10));
        int day2 = Integer.parseInt(date2.substring(8, 10));
        int value = (year1 - year2) * 12 + (month1 - month2);
        if (day1 < day2) {
            --value;
        }
        return value;
    }

    public static int compareDay(String date1str, String date2str) {
        if (date1str == null || date2str == null) {
            return 0;
        }
        Date date1 = DateTimes.toDate(date1str, "00:00:00");
        Date date2 = DateTimes.toDate(date2str, "00:00:00");
        return DateTimes.compareDay(date1, date2);
    }

    public static int compareDay(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return 0;
        }
        long time1 = date1.getTime();
        long time2 = date2.getTime();
        long margin = time1 - time2;
        int ret = (int)Math.floor((double)margin / 8.64E7);
        return ret;
    }

    public static int compareHour(String date1str, String date2str) {
        if (date1str == null || date2str == null) {
            return 0;
        }
        Date date1 = DateTimes.toDate(date1str);
        Date date2 = DateTimes.toDate(date2str);
        return DateTimes.compareHour(date1, date2);
    }

    public static int compareHour(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return 0;
        }
        long time1 = date1.getTime();
        long time2 = date2.getTime();
        long margin = time1 - time2;
        int ret = (int)Math.floor((double)margin / 3600000.0);
        return ret;
    }

    public static int compareMinute(String date1str, String date2str) {
        if (date1str == null || date2str == null) {
            return 0;
        }
        Date date1 = DateTimes.toDate(date1str);
        Date date2 = DateTimes.toDate(date2str);
        return DateTimes.compareMinute(date1, date2);
    }

    public static int compareMinute(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return 0;
        }
        long time1 = date1.getTime();
        long time2 = date2.getTime();
        long margin = time1 - time2;
        int ret = (int)Math.floor((double)margin / 60000.0);
        return ret;
    }

    public static int compareSecond(String date1str, String date2str) {
        if (date1str == null || date2str == null) {
            return 0;
        }
        Date date1 = DateTimes.toDate(date1str);
        Date date2 = DateTimes.toDate(date2str);
        return DateTimes.compareSecond(date1, date2);
    }

    public static int compareSecond(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return 0;
        }
        long time1 = date1.getTime();
        long time2 = date2.getTime();
        long margin = time1 - time2;
        Long longValue = new Long(margin / 1000L);
        return longValue.intValue();
    }

    public static String compareDateTime(Date date) {
        long dateTimeMs = date.getTime();
        return DateTimes.compareDateTime(dateTimeMs);
    }

    public static String compareDateTime(String datetime) {
        long dateTimeMs = DateTimes.toLong(datetime);
        return DateTimes.compareDateTime(dateTimeMs);
    }

    public static String compareDateTime(long dateTimeMs) {
        long cmpTime;
        long curTime = System.currentTimeMillis() / 1000L;
        if (curTime <= (cmpTime = dateTimeMs / 1000L)) {
            return "1\u79d2\u524d";
        }
        long des = curTime - cmpTime;
        long year = des / (long)_SECOND_IN_TIME_[0];
        if (year > 0L) {
            return String.valueOf(year) + "\u5e74\u524d";
        }
        long month = des / (long)_SECOND_IN_TIME_[1];
        if (month > 0L) {
            return String.valueOf(month) + "\u6708\u524d";
        }
        long day = des / (long)_SECOND_IN_TIME_[2];
        if (day > 0L) {
            return String.valueOf(day) + "\u5929\u524d";
        }
        long hour = des / (long)_SECOND_IN_TIME_[3];
        if (hour > 0L) {
            return String.valueOf(hour) + "\u5c0f\u65f6\u524d";
        }
        long minute = des / (long)_SECOND_IN_TIME_[4];
        if (minute > 0L) {
            return String.valueOf(minute) + "\u5206\u949f\u524d";
        }
        return String.valueOf(des) + "\u79d2\u524d";
    }

    public static String getDateTimeHttp() {
        Calendar calendar = Calendar.getInstance(new SimpleTimeZone(0, "GMT"));
        return DateTimes.getDateTimeHttp(calendar);
    }

    public static String getDateTimeHttp(long millis) {
        Calendar calendar = Calendar.getInstance(new SimpleTimeZone(0, "GMT"));
        calendar.setTimeInMillis(millis);
        return DateTimes.getDateTimeHttp(calendar);
    }

    public static String getDateTimeHttpNextHour() {
        Calendar calendar = Calendar.getInstance(new SimpleTimeZone(0, "GMT"));
        calendar.add(11, 1);
        return DateTimes.getDateTimeHttp(calendar);
    }

    public static String getDateTimeHttp(Calendar calendar) {
        StringBuilder buf = new StringBuilder();
        int week = calendar.get(7) - 1;
        int day = calendar.get(5);
        int month = calendar.get(2);
        int year = calendar.get(1);
        int epoch = (int)(calendar.getTimeInMillis() / 1000L % 86400L);
        int seconds = epoch % 60;
        int minutes = (epoch /= 60) % 60;
        int hours = epoch / 60;
        buf.append(_WEEKS_[week]);
        buf.append(',');
        buf.append(' ');
        buf.append(Strings.prefixZero(day, 2));
        buf.append(' ');
        buf.append(_MONTHS_[month]);
        buf.append(' ');
        buf.append(Strings.prefixZero(year, 4));
        buf.append(' ');
        buf.append(Strings.prefixZero(hours, 2));
        buf.append(':');
        buf.append(Strings.prefixZero(minutes, 2));
        buf.append(':');
        buf.append(Strings.prefixZero(seconds, 2));
        buf.append(" GMT");
        return buf.toString();
    }

    public static int getDateWeek(int date) {
        int year = date / 10000;
        int month = date / 100 % 100;
        int day = date % 100;
        return DateTimes.toCalendar(year, month, day, 0, 0, 1).get(7) - 1;
    }

    public static int getDateWeek7(int date) {
        int week = DateTimes.getDateWeek(date);
        return week == 0 ? 7 : week;
    }

    public static String getDateWeekString(int date) {
        int week = DateTimes.getDateWeek(date);
        return _WEEKS_ZH_[week];
    }

    public static int getDateWeek(int year, int month, int day) {
        return DateTimes.toCalendar(year, month, day, 0, 0, 1).get(7) - 1;
    }

    public static int getDateWeek7(int year, int month, int day) {
        int week = DateTimes.getDateWeek(year, month, day);
        return week == 0 ? 7 : week;
    }

    public static String getDateWeekString(int year, int month, int day) {
        int week = DateTimes.getDateWeek(year, month, day);
        return _WEEKS_ZH_[week];
    }

    public static int getDateWeek(String date) {
        return DateTimes.getDateTimeWeek(String.valueOf(date) + " 00:00:01");
    }

    public static int getDateWeek7(String date) {
        int week = DateTimes.getDateTimeWeek(String.valueOf(date) + " 00:00:01");
        return week == 0 ? 7 : week;
    }

    public static String getDateWeekString(String date) {
        int week = DateTimes.getDateWeek(date);
        return _WEEKS_ZH_[week];
    }

    public static int getDateTimeWeek(String datetime) {
        return DateTimes.toCalendar(datetime).get(7) - 1;
    }

    public static int getDateTimeWeek7(String datetime) {
        int week = DateTimes.getDateTimeWeek(datetime);
        return week == 0 ? 7 : week;
    }

    public static String getDateTimeWeekString(String datetime) {
        int week = DateTimes.getDateTimeWeek(datetime);
        return _WEEKS_ZH_[week];
    }

    public static int[] getCurrent() {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int min = calendar.get(12);
        int sec = calendar.get(13);
        int msec = calendar.get(14);
        int week = calendar.get(7);
        if (--week == 0) {
            week = 7;
        }
        int yearMonth = year * 100 + month;
        int monthDays = DateTimes.getMonthDays(year, month);
        return new int[]{year, month, day, hour, min, sec, msec, week, yearMonth, monthDays};
    }

    public static int getCurrentDate() {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        return year * 10000 + month * 100 + day;
    }

    public static int getCurrentYear() {
        return Calendar.getInstance().get(1);
    }

    public static int getCurrentMonth() {
        return Calendar.getInstance().get(2) + 1;
    }

    public static int getCurrentMonthDays() {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        return DateTimes.getMonthDays(year, month);
    }

    public static int getCurrentDay() {
        return Calendar.getInstance().get(5);
    }

    public static int getCurrentYearDay() {
        return Calendar.getInstance().get(6);
    }

    public static int getCurrentHour() {
        return Calendar.getInstance().get(11);
    }

    public static int getCurrentMinute() {
        return Calendar.getInstance().get(12);
    }

    public static int getCurrentSecond() {
        return Calendar.getInstance().get(13);
    }

    public static int getCurrentMillis() {
        return Calendar.getInstance().get(14);
    }

    public static int getCurrentWeek() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(7) - 1;
    }

    public static int getCurrentWeek7() {
        Calendar calendar = Calendar.getInstance();
        int week = calendar.get(7) - 1;
        return week == 0 ? 7 : week;
    }

    public static int getCurrentTime10() {
        Calendar calendar = Calendar.getInstance();
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int min = calendar.get(12);
        int sec = calendar.get(13);
        return month * 100000000 + day * 1000000 + hour * 10000 + min * 100 + sec;
    }

    public static String getDateTimeString(String format) {
        return new SimpleDateFormat(format).format(DateTimes.nowDate());
    }

    public static String getDateTimeString() {
        return new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS).format(DateTimes.nowDate());
    }

    public static String getDateTime17String() {
        return new SimpleDateFormat("yyyyMMddHHmmssSSS").format(DateTimes.nowDate());
    }

    public static String getDateTime14String() {
        return new SimpleDateFormat(YYYYMMDDHHMMSS).format(DateTimes.nowDate());
    }

    public static String getDateTime12String() {
        return new SimpleDateFormat("yyMMddHHmmss").format(DateTimes.nowDate());
    }

    public static String getDateTime10String() {
        return new SimpleDateFormat("yyMMddHHmm").format(DateTimes.nowDate());
    }

    public static String getDateTime10String2() {
        return new SimpleDateFormat(MMDDHHMMSS).format(DateTimes.nowDate());
    }

    public static String getDateTime8String() {
        return new SimpleDateFormat("yyyyMMdd").format(DateTimes.nowDate());
    }

    public static String getDateTime8String2() {
        return new SimpleDateFormat(MMDDHHMM).format(DateTimes.nowDate());
    }

    public static String getDateTime7String() {
        return new SimpleDateFormat("yyyy-MM").format(DateTimes.nowDate());
    }

    public static String getDateTime6String() {
        return new SimpleDateFormat("yyyyMM").format(DateTimes.nowDate());
    }

    public static String getDateString() {
        return new SimpleDateFormat(YYYY_MM_DD).format(DateTimes.nowDate());
    }

    public static String getTimeString() {
        return new SimpleDateFormat("HH:mm:ss").format(DateTimes.nowDate());
    }

    public static String getDateTimeSSSString() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS").format(DateTimes.nowDate());
    }

    public static String getDateTimeStringSlash() {
        return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(DateTimes.nowDate());
    }

    public static String getDateStringSlash() {
        return new SimpleDateFormat("yyyy/MM/dd").format(DateTimes.nowDate());
    }

    public static String getFirstMonthDay() {
        return String.valueOf(DateTimes.getDateTime7String()) + "-01";
    }

    public static String getLastMonthDay() {
        String curYearMonth = DateTimes.getDateTime6String();
        return DateTimes.getLastMonthDay(curYearMonth);
    }

    public static String getPreviousMonthFirstDay() {
        String curYearMonth = DateTimes.getDateTime6String();
        String yearMonth = DateTimes.getPreviousYearMonth(curYearMonth);
        return String.valueOf(yearMonth.substring(0, 4)) + "-" + yearMonth.substring(4) + "-01";
    }

    public static String getPreviousMonthLastDay() {
        String curYearMonth = DateTimes.getDateTime6String();
        String yearMonth = DateTimes.getPreviousYearMonth(curYearMonth);
        return DateTimes.getLastMonthDay(yearMonth);
    }

    public static String getNextMonthFirstDay() {
        String curYearMonth = DateTimes.getDateTime6String();
        String yearMonth = DateTimes.getNextYearMonth(curYearMonth);
        return String.valueOf(yearMonth.substring(0, 4)) + "-" + yearMonth.substring(4) + "-01";
    }

    public static String getNextMonthLastDay() {
        String curYearMonth = DateTimes.getDateTime6String();
        String yearMonth = DateTimes.getNextYearMonth(curYearMonth);
        return DateTimes.getLastMonthDay(yearMonth);
    }

    public static String getPreviousDateString() {
        return DateTimes.getPreviousDateTimeString(YYYY_MM_DD);
    }

    public static String getPreviousDateStringSlash() {
        return DateTimes.getPreviousDateTimeString("yyyy/MM/dd");
    }

    public static String getPreviousDateTimeString(String format) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        return DateTimes.toDateTimeString(calendar, format);
    }

    public static String getPreviousDateTimeString() {
        return DateTimes.getPreviousDateTimeString(YYYY_MM_DD_HH_MM_SS);
    }

    public static String getPreviousDateTimeStringSlash() {
        return DateTimes.getPreviousDateTimeString("yyyy/MM/dd HH:mm:ss");
    }

    public static String getPreviousDateString(int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -days);
        return DateTimes.toDateString(calendar);
    }

    public static String getPreviousDateStringByYear(int years) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, -years);
        return DateTimes.toDateString(calendar);
    }

    public static String getPreviousDateStringByMonth(int months) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -months);
        return DateTimes.toDateString(calendar);
    }

    public static String getPreviousDateStringByHour(int hours) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(11, -hours);
        return DateTimes.toDateString(calendar);
    }

    public static String getPreviousDateStringBySecond(int seconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, -seconds);
        return DateTimes.toDateString(calendar);
    }

    public static String getPreviousDateTimeString(int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -days);
        return DateTimes.toDateTimeString(calendar);
    }

    public static String getPreviousDateTimeStringByYear(int years) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, -years);
        return DateTimes.toDateTimeString(calendar);
    }

    public static String getPreviousDateTimeStringByMonth(int months) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -months);
        return DateTimes.toDateTimeString(calendar);
    }

    public static String getPreviousDateTimeStringByHour(int hours) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(11, -hours);
        return DateTimes.toDateTimeString(calendar);
    }

    public static String getPreviousDateTimeStringBySecond(int seconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, -seconds);
        return DateTimes.toDateTimeString(calendar);
    }

    public static String getPreviousDateString(String date) {
        return DateTimes.getPreviousDateString(date, 1);
    }

    public static String getPreviousDateString(String date, int days) {
        Calendar calendar = DateTimes.toCalendar(String.valueOf(date) + " 00:00:00");
        calendar.add(5, -days);
        return DateTimes.toDateString(calendar);
    }

    public static String getPreviousDateStringByYear(String datetime, int years) {
        Calendar calendar = DateTimes.toCalendar(datetime);
        calendar.add(1, -years);
        return DateTimes.toDateString(calendar);
    }

    public static String getPreviousDateStringByMonth(String datetime, int months) {
        Calendar calendar = DateTimes.toCalendar(datetime);
        calendar.add(2, -months);
        return DateTimes.toDateString(calendar);
    }

    public static String getPreviousDateStringByHour(String datetime, int hours) {
        Calendar calendar = DateTimes.toCalendar(datetime);
        calendar.add(11, -hours);
        return DateTimes.toDateString(calendar);
    }

    public static String getPreviousDateStringBySecond(String datetime, int seconds) {
        Calendar calendar = DateTimes.toCalendar(datetime);
        calendar.add(13, -seconds);
        return DateTimes.toDateString(calendar);
    }

    public static String getPreviousDateTimeString(String datetime, int days) {
        Calendar calendar = DateTimes.toCalendar(datetime);
        calendar.add(5, -days);
        return DateTimes.toDateTimeString(calendar);
    }

    public static String getPreviousDateTimeStringByYear(String datetime, int years) {
        Calendar calendar = DateTimes.toCalendar(datetime);
        calendar.add(1, -years);
        return DateTimes.toDateTimeString(calendar);
    }

    public static String getPreviousDateTimeStringByMonth(String datetime, int months) {
        Calendar calendar = DateTimes.toCalendar(datetime);
        calendar.add(2, -months);
        return DateTimes.toDateTimeString(calendar);
    }

    public static String getPreviousDateTimeStringByHour(String datetime, int hours) {
        Calendar calendar = DateTimes.toCalendar(datetime);
        calendar.add(11, -hours);
        return DateTimes.toDateTimeString(calendar);
    }

    public static String getPreviousDateTimeStringBySecond(String datetime, int second) {
        Calendar calendar = DateTimes.toCalendar(datetime);
        calendar.add(13, -second);
        return DateTimes.toDateTimeString(calendar);
    }

    public static String getNextDateString() {
        return DateTimes.getNextDateTimeString(YYYY_MM_DD);
    }

    public static String getNextDateTimeString() {
        return DateTimes.getNextDateTimeString(YYYY_MM_DD_HH_MM_SS);
    }

    public static String getNextDateTimeString(String format) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 1);
        return DateTimes.toDateTimeString(calendar, format);
    }

    public static Date getNextDate(int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, days);
        return calendar.getTime();
    }

    public static Date getNextDateByYeah(int years) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, years);
        return calendar.getTime();
    }

    public static Date getNextDateByMonth(int months) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, months);
        return calendar.getTime();
    }

    public static Date getNextDateByHour(int hours) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(11, hours);
        return calendar.getTime();
    }

    public static Date getNextDateBySecond(int seconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, seconds);
        return calendar.getTime();
    }

    public static String getNextDateString(int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, days);
        return DateTimes.toDateString(calendar);
    }

    public static String getNextDateStringByYeah(int years) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, years);
        return DateTimes.toDateString(calendar);
    }

    public static String getNextDateStringByMonth(int months) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, months);
        return DateTimes.toDateString(calendar);
    }

    public static String getNextDateStringByHour(int hours) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(11, hours);
        return DateTimes.toDateString(calendar);
    }

    public static String getNextDateStringBySecond(int seconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, seconds);
        return DateTimes.toDateString(calendar);
    }

    public static String getNextDateString(String date) {
        return DateTimes.getNextDateString(date, 1);
    }

    public static String getNextDateString(String date, int days) {
        Calendar calendar = DateTimes.toCalendar(String.valueOf(date) + " 00:00:00");
        calendar.add(5, days);
        return DateTimes.toDateString(calendar);
    }

    public static String getNextDateStringByYear(String date, int years) {
        Calendar calendar = DateTimes.toCalendar(String.valueOf(date) + " 00:00:00");
        calendar.add(1, years);
        return DateTimes.toDateString(calendar);
    }

    public static String getNextDateStringByMonth(String date, int months) {
        Calendar calendar = DateTimes.toCalendar(String.valueOf(date) + " 00:00:00");
        calendar.add(2, months);
        return DateTimes.toDateString(calendar);
    }

    public static String getNextDateStringByHour(String date, int hours) {
        Calendar calendar = DateTimes.toCalendar(String.valueOf(date) + " 00:00:00");
        calendar.add(11, hours);
        return DateTimes.toDateString(calendar);
    }

    public static String getNextDateStringBySecond(String date, int seconds) {
        Calendar calendar = DateTimes.toCalendar(String.valueOf(date) + " 00:00:00");
        calendar.add(13, seconds);
        return DateTimes.toDateString(calendar);
    }

    public static String getNextDateTimeString(int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, days);
        return DateTimes.toDateTimeString(calendar);
    }

    public static String getNextDateTimeStringByYear(int years) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, years);
        return DateTimes.toDateTimeString(calendar);
    }

    public static String getNextDateTimeStringByMonth(int months) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, months);
        return DateTimes.toDateTimeString(calendar);
    }

    public static String getNextDateTimeStringByHour(int hours) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(11, hours);
        return DateTimes.toDateTimeString(calendar);
    }

    public static String getNextDateTimeStringBySecond(int seconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, seconds);
        return DateTimes.toDateTimeString(calendar);
    }

    public static String getNextDateTimeString(String datetime, int days) {
        Calendar calendar = DateTimes.toCalendar(datetime);
        calendar.add(5, days);
        return DateTimes.toDateTimeString(calendar);
    }

    public static String getNextDateTimeStringByYear(String datetime, int years) {
        Calendar calendar = DateTimes.toCalendar(datetime);
        calendar.add(1, years);
        return DateTimes.toDateTimeString(calendar);
    }

    public static String getNextDateTimeStringByMonth(String datetime, int months) {
        Calendar calendar = DateTimes.toCalendar(datetime);
        calendar.add(2, months);
        return DateTimes.toDateTimeString(calendar);
    }

    public static String getNextDateTimeStringByHour(String datetime, int hours) {
        Calendar calendar = DateTimes.toCalendar(datetime);
        calendar.add(11, hours);
        return DateTimes.toDateTimeString(calendar);
    }

    public static String getNextDateTimeStringBySecond(String datetime, int seconds) {
        Calendar calendar = DateTimes.toCalendar(datetime);
        calendar.add(13, seconds);
        return DateTimes.toDateTimeString(calendar);
    }

    public static TimeZone getTimeZone() {
        return Calendar.getInstance().getTimeZone();
    }

    public static int getTimeZoneHour() {
        return Calendar.getInstance().getTimeZone().getRawOffset() / 3600000;
    }

    public static int getTimeZoneMinute() {
        return Calendar.getInstance().getTimeZone().getRawOffset() / 60000;
    }

    public static int getTimeZoneSecond() {
        return Calendar.getInstance().getTimeZone().getRawOffset() / 1000;
    }
}

