/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.json;

import java.util.ArrayList;
import java.util.List;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.AsciiConstants;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.extend.HashMapSS;
import org.zhiqim.kernel.extend.HashMapSV;
import org.zhiqim.kernel.extend.LinkedMapSO;
import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.kernel.json.Json;
import org.zhiqim.kernel.json.parser.ArrayParser;
import org.zhiqim.kernel.json.parser.MapParser;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;

@AnAlias(value={"Jsons"})
public class Jsons
implements AsciiConstants {
    public static String toString(Object obj) {
        return Json.json.toString(obj);
    }

    public static <T> T toObject(String str, Class<T> cls) {
        return Json.json.toObject(str, cls, true);
    }

    public static boolean isStartEndQuotation(String str) {
        return str != null && str.length() >= 2 && (str.startsWith("\"") && str.endsWith("\"") || str.startsWith("'") && str.endsWith("'"));
    }

    public static String removeStartEndQuotation(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() >= 2 && str.startsWith("\"") && str.endsWith("\"")) {
            str = str.substring(1, str.length() - 1);
            return str;
        }
        if (str.length() >= 2 && str.startsWith("'") && str.endsWith("'")) {
            str = str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static String addEscapeChar(String str, char quotation) {
        if (str == null) {
            return null;
        }
        StringBuilder strb = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            switch (c) {
                case '\\': {
                    strb.append("\\\\");
                    break;
                }
                case '\"': {
                    if (quotation == '\u0000' || quotation == '\"') {
                        strb.append("\\\"");
                        break;
                    }
                    strb.append(c);
                    break;
                }
                case '\'': {
                    if (quotation == '\u0000' || quotation == '\'') {
                        strb.append("\\'");
                        break;
                    }
                    strb.append(c);
                    break;
                }
                case '\b': {
                    strb.append("\\b");
                    break;
                }
                case '\f': {
                    strb.append("\\f");
                    break;
                }
                case '\r': {
                    strb.append("\\r");
                    break;
                }
                case '\n': {
                    strb.append("\\n");
                    break;
                }
                case '\t': {
                    strb.append("\\t");
                    break;
                }
                case '/': {
                    strb.append("\\/");
                    break;
                }
                default: {
                    strb.append(c);
                }
            }
            ++i;
        }
        return strb.toString();
    }

    public static String removeEscapeChar(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder strb = new StringBuilder();
        boolean isEscape = false;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (!isEscape) {
                if (c == '\\') {
                    isEscape = true;
                } else {
                    strb.append(c);
                }
            } else {
                switch (c) {
                    case '\\': {
                        strb.append('\\');
                        break;
                    }
                    case '\"': {
                        strb.append('\"');
                        break;
                    }
                    case '\'': {
                        strb.append('\'');
                        break;
                    }
                    case 'b': {
                        strb.append('\b');
                        break;
                    }
                    case 'f': {
                        strb.append('\f');
                        break;
                    }
                    case 'n': {
                        strb.append('\n');
                        break;
                    }
                    case 'r': {
                        strb.append('\r');
                        break;
                    }
                    case 't': {
                        strb.append('\t');
                        break;
                    }
                    case '/': {
                        strb.append('/');
                        break;
                    }
                    default: {
                        strb.append("\\").append(c);
                    }
                }
                isEscape = false;
            }
            ++i;
        }
        if (isEscape) {
            strb.append("\\");
        }
        return strb.toString();
    }

    public static String removeBlankSpace(String str) {
        if (str == null) {
            return null;
        }
        str = Strings.trim(str);
        StringBuilder strb = new StringBuilder();
        boolean isRemove = false;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (!isRemove || !Validates.isWhitespace(c)) {
                switch (c) {
                    case '[': 
                    case '{': {
                        isRemove = true;
                        break;
                    }
                    case ',': 
                    case ':': 
                    case ']': 
                    case '}': {
                        int count = 0;
                        int j = strb.length() - 1;
                        while (j >= 0) {
                            char cj = strb.charAt(j);
                            if (!Validates.isWhitespace(cj)) break;
                            ++count;
                            --j;
                        }
                        if (count > 0) {
                            strb.setLength(strb.length() - count);
                        }
                        isRemove = true;
                        break;
                    }
                    default: {
                        isRemove = false;
                    }
                }
                strb.append(c);
            }
            ++i;
        }
        return strb.toString();
    }

    public static int getIndex(String json, String field) {
        int fieldLen = field.length();
        int ind = json.indexOf("\"" + field + "\":");
        if (ind != -1) {
            return ind + 1 + fieldLen + 1 + 1;
        }
        ind = json.indexOf(String.valueOf(field) + ":");
        if (ind != -1) {
            return ind + fieldLen + 1;
        }
        ind = json.indexOf("'" + field + "':");
        if (ind != -1) {
            return ind + 1 + fieldLen + 1 + 1;
        }
        return -1;
    }

    public static final String getValue(String json, String field) {
        if (Validates.isEmpty(json = Jsons.removeBlankSpace(json))) {
            return null;
        }
        int ind = Jsons.getIndex(json, field);
        if (ind == -1) {
            return null;
        }
        char firstChar = json.charAt(ind);
        switch (firstChar) {
            case '{': {
                return Jsons.getObject(json, field);
            }
            case '[': {
                return Jsons.getArray(json, field);
            }
        }
        return Jsons.getString(json, field);
    }

    public static boolean isStringStart(char quotation, char c, char lastChar) {
        return !(quotation != '\u0000' || c != '\"' && c != '\'' || lastChar != ':' && lastChar != ',' && lastChar != '{' && lastChar != '[');
    }

    public static boolean isStringEnd(int i, int lastIndex, char quotation, char c, char lastChar, char last2Char) {
        return lastIndex < i - 1 && (c == ':' || c == ',' || c == '}' || c == ']') && lastChar == quotation && last2Char != '\\';
    }

    public static List<String> getFieldList(String str) {
        ArrayList<String> fieldList = new ArrayList<String>();
        int objNum = 0;
        int arrNum = 0;
        StringBuilder temp = new StringBuilder();
        boolean isString = false;
        char quotation = '\u0000';
        char lastChar = '\u0000';
        char last2Char = '\u0000';
        int lastIndex = 0;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (Jsons.isStringStart(quotation, c, lastChar)) {
                quotation = c;
                lastIndex = i;
                isString = true;
            }
            if (Jsons.isStringEnd(i, lastIndex, quotation, c, lastChar, last2Char)) {
                quotation = '\u0000';
                lastIndex = 0;
                isString = false;
            }
            last2Char = lastChar;
            lastChar = c;
            if (isString) {
                temp.append(c);
            } else {
                switch (c) {
                    case '{': {
                        ++objNum;
                        break;
                    }
                    case '}': {
                        --objNum;
                        break;
                    }
                    case '[': {
                        ++arrNum;
                        break;
                    }
                    case ']': {
                        --arrNum;
                    }
                }
                if (objNum > 0 || arrNum > 0) {
                    temp.append(c);
                } else if (c != ',') {
                    temp.append(c);
                } else {
                    if (temp.length() > 0) {
                        fieldList.add(temp.toString());
                    }
                    temp = null;
                    temp = new StringBuilder();
                }
            }
            ++i;
        }
        if (temp.length() > 0) {
            fieldList.add(temp.toString());
        }
        fieldList.trimToSize();
        return fieldList;
    }

    public static String getString(String json, String field) {
        String value;
        if (Validates.isEmpty(json = Jsons.removeBlankSpace(json))) {
            return null;
        }
        int ind = Jsons.getIndex(json, field);
        if (ind == -1) {
            return null;
        }
        int quotation = 0;
        char firstChar = json.charAt(ind);
        switch (firstChar) {
            case '{': {
                return Jsons.getObject(json, field);
            }
            case '[': {
                return Jsons.getArray(json, field);
            }
            case '\"': {
                quotation = 34;
                break;
            }
            case '\'': {
                quotation = 39;
            }
        }
        StringBuilder strb = new StringBuilder();
        boolean isEscape = false;
        if (firstChar == '\\') {
            isEscape = true;
        } else {
            strb.append(firstChar);
        }
        int i = ind + 1;
        while (i < json.length()) {
            char c = json.charAt(i);
            if (quotation == 0 && (c == ',' || c == '}')) {
                if (!isEscape) break;
                strb.append("\\");
                break;
            }
            if (!isEscape) {
                if (c == '\\') {
                    isEscape = true;
                } else {
                    strb.append(c);
                    if (c == '\"' && quotation == 34 || c == '\'' && quotation == 39) {
                        break;
                    }
                }
            } else {
                switch (c) {
                    case '\"': {
                        strb.append('\"');
                        break;
                    }
                    case '\'': {
                        strb.append('\'');
                        break;
                    }
                    case '\\': {
                        strb.append('\\');
                        break;
                    }
                    case 'b': {
                        strb.append('\b');
                        break;
                    }
                    case 'f': {
                        strb.append('\f');
                        break;
                    }
                    case 'n': {
                        strb.append('\n');
                        break;
                    }
                    case 'r': {
                        strb.append('\r');
                        break;
                    }
                    case 't': {
                        strb.append('\t');
                        break;
                    }
                    case '/': {
                        strb.append('/');
                        break;
                    }
                    default: {
                        strb.append("\\").append(c);
                    }
                }
                isEscape = false;
            }
            ++i;
        }
        if ("null".equals(value = strb.toString())) {
            return null;
        }
        return Jsons.removeStartEndQuotation(value);
    }

    public static final String getObject(String json, String field) {
        if (Validates.isEmpty(json = Jsons.removeBlankSpace(json))) {
            return null;
        }
        int ind = Jsons.getIndex(json, field);
        if (ind == -1) {
            return null;
        }
        if (json.charAt(ind) != '{') {
            return null;
        }
        StringBuilder strb = new StringBuilder();
        int num = 0;
        boolean isString = false;
        char quotation = '\u0000';
        char lastChar = '\u0000';
        char last2Char = '\u0000';
        int lastIndex = 0;
        int i = ind;
        while (i < json.length()) {
            char c = json.charAt(i);
            if (Jsons.isStringStart(quotation, c, lastChar)) {
                quotation = c;
                lastIndex = i;
                isString = true;
            }
            if (Jsons.isStringEnd(i, lastIndex, quotation, c, lastChar, last2Char)) {
                quotation = '\u0000';
                lastIndex = 0;
                isString = false;
            }
            last2Char = lastChar;
            lastChar = c;
            if (!isString) {
                switch (c) {
                    case '{': {
                        ++num;
                        break;
                    }
                    case '}': {
                        --num;
                    }
                }
            }
            strb.append(c);
            if (num == 0) break;
            ++i;
        }
        return strb.toString();
    }

    public static final String getArray(String json, String field) {
        if (Validates.isEmpty(json = Jsons.removeBlankSpace(json))) {
            return null;
        }
        int ind = Jsons.getIndex(json, field);
        if (ind == -1) {
            return null;
        }
        if (json.charAt(ind) != '[') {
            return null;
        }
        StringBuilder strb = new StringBuilder();
        int num = 0;
        boolean isString = false;
        char quotation = '\u0000';
        char lastChar = '\u0000';
        char last2Char = '\u0000';
        int lastIndex = 0;
        int i = ind;
        while (i < json.length()) {
            char c = json.charAt(i);
            if (Jsons.isStringStart(quotation, c, lastChar)) {
                quotation = c;
                lastIndex = i;
                isString = true;
            }
            if (Jsons.isStringEnd(i, lastIndex, quotation, c, lastChar, last2Char)) {
                quotation = '\u0000';
                lastIndex = 0;
                isString = false;
            }
            last2Char = lastChar;
            lastChar = c;
            if (!isString) {
                switch (c) {
                    case '[': {
                        ++num;
                        break;
                    }
                    case ']': {
                        --num;
                    }
                }
            }
            strb.append(c);
            if (num == 0) break;
            ++i;
        }
        return strb.toString();
    }

    public static List<String> getList(String json, String field) {
        String arrJson = Jsons.getArray(json, field);
        return ArrayParser.toFieldList(arrJson);
    }

    public static final long getLong(String json, String field, long defaultValue) {
        String num = Jsons.getString(json, field);
        if (!Validates.isInteger(num)) {
            return defaultValue;
        }
        return Long.parseLong(num);
    }

    public static final long getLong(String json, String field) {
        String num = Jsons.getString(json, field);
        if (!Validates.isInteger(num)) {
            return -1L;
        }
        return Long.parseLong(num);
    }

    public static final int getInt(String json, String field, int defaultValue) {
        String num = Jsons.getString(json, field);
        if (!Validates.isInteger(num)) {
            return defaultValue;
        }
        return Integer.parseInt(num);
    }

    public static final int getInt(String json, String field) {
        String num = Jsons.getString(json, field);
        if (!Validates.isInteger(num)) {
            return -1;
        }
        return Integer.parseInt(num);
    }

    public static final boolean getBoolean(String json, String field) {
        String str = Jsons.getString(json, field);
        return "true".equalsIgnoreCase(str);
    }

    public static final boolean getBoolean(String json, String field, boolean defaultValue) {
        String str = Jsons.getString(json, field);
        if (str == null) {
            return defaultValue;
        }
        return "true".equalsIgnoreCase(str);
    }

    public static HashMapSO toMapSO(String json) {
        return Json.json.toObject(json, HashMapSO.class, true);
    }

    public static HashMapSS toMapSS(String json) {
        return Json.json.toObject(json, HashMapSS.class, true);
    }

    public static <V> HashMapSV<V> toMapSV(String json, Class<V> genericsClass) {
        List<String> fieldList = MapParser.toFieldList(json);
        HashMapSV<V> map = new HashMapSV<V>();
        for (String field : fieldList) {
            int ind = field.indexOf(":");
            String key = Jsons.removeStartEndQuotation(field.substring(0, ind).trim());
            String value = field.substring(ind + 1).trim();
            if ("null".equals(value)) {
                map.put(key, null);
                continue;
            }
            V v = Jsons.toObject(value, genericsClass);
            map.put(key, v);
        }
        return map;
    }

    public static <T> List<T> toList(String json, Class<T> genericsClass) {
        List<String> fieldList = ArrayParser.toFieldList(json);
        ArrayList<T> list = new ArrayList<T>(fieldList.size());
        for (String field : fieldList) {
            T o = Jsons.toObject(field, genericsClass);
            list.add(o);
        }
        return list;
    }

    public static String toString(String key, Object value) {
        HashMapSO map = new HashMapSO(1);
        map.put(key, value);
        return Jsons.toString(map);
    }

    public static String toString(String key, Object value, String key2, Object value2) {
        LinkedMapSO map = new LinkedMapSO(2);
        ((MapSO)map).put(key, value);
        ((MapSO)map).put(key2, value2);
        return Jsons.toString(map);
    }

    public static String toStringAddOrUpdate(String json, String key, Object value) {
        HashMapSO jsonMap = Jsons.toMapSO(json);
        jsonMap.put(key, value);
        return Jsons.toString(jsonMap);
    }

    public static String toStringRemove(String json, String key) {
        HashMapSO jsonMap = Jsons.toMapSO(json);
        jsonMap.remove(key);
        return Jsons.toString(jsonMap);
    }
}

