/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.zhiqim.kernel.MultiInstance;
import org.zhiqim.kernel.Service;
import org.zhiqim.kernel.ZhiqimClasspath;
import org.zhiqim.kernel.ZhiqimI18n;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.config.Config;
import org.zhiqim.kernel.config.Group;
import org.zhiqim.kernel.config.Item;
import org.zhiqim.kernel.constants.ZhiqimConstants;
import org.zhiqim.kernel.extend.HashMapCO;
import org.zhiqim.kernel.extend.HashMapSC;
import org.zhiqim.kernel.extend.LinkedMapSV;
import org.zhiqim.kernel.extend.MapCO;
import org.zhiqim.kernel.extend.MapSC;
import org.zhiqim.kernel.extend.MapSV;
import org.zhiqim.kernel.logging.Logs;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.kernel.util.Ints;
import org.zhiqim.kernel.util.Longs;
import org.zhiqim.kernel.util.Validates;

@AnAlias(value={"Global"})
public final class Global
implements ZhiqimConstants {
    private static final MapSV<Config> configMap = new LinkedMapSV<Config>();
    private static final MapSV<Group> groupMap = new LinkedMapSV<Group>();
    private static final MapSV<Service> serviceMap = new LinkedMapSV<Service>();
    private static final MapCO objMap = new HashMapCO();
    private static final MapSC aliasMap = new HashMapSC();

    private Global() {
    }

    public static ClassLoader getClassLoader() {
        ZhiqimClasspath _classpath = Global.get(ZhiqimClasspath.class);
        if (_classpath == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return _classpath.getClassLoader();
    }

    public static boolean has(Class<?> cls) {
        return objMap.containsKey(cls);
    }

    public static <T> T get(Class<T> cls) {
        Object obj = objMap.get(cls);
        if (obj == null) {
            return null;
        }
        if (!Classes.isImplement(cls, MultiInstance.class)) {
            return (T)obj;
        }
        List list = (List)obj;
        return list.isEmpty() ? null : (T)list.get(0);
    }

    public static <T> T get(Class<T> cls, int idx) {
        Asserts.as(Classes.isImplement(cls, MultiInstance.class) ? null : "\u5168\u5c40\u53d8\u91cf\u8868\u4e2d\uff0c\u4e0d\u662f\u591a\u4f8b\u4e0d\u652f\u6301\u8c03\u7528\u8be5\u65b9\u6cd5[get(Class<T> cls, int idx)]");
        Object obj = objMap.get(cls);
        if (obj == null) {
            return null;
        }
        List list = (List)obj;
        return list.isEmpty() || list.size() < idx + 1 ? null : (T)list.get(idx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getWithoutNew(Class<T> cls) {
        T obj = Global.get(cls);
        if (obj != null) {
            return obj;
        }
        MapCO mapCO = objMap;
        synchronized (mapCO) {
            obj = Global.get(cls);
            if (obj != null) {
                return obj;
            }
            obj = Classes.newInstance(cls);
            Asserts.assertNotNull(obj, ZhiqimI18n.classDoesNotSupportNoParameterConstructors, cls.getName());
            if (!Classes.isImplement(cls, MultiInstance.class)) {
                objMap.put(cls, obj);
            } else {
                MultiInstance instance = (MultiInstance)obj;
                instance.setIndex(0);
                ArrayList<MultiInstance> list = new ArrayList<MultiInstance>();
                list.add(instance);
                list.trimToSize();
                objMap.put(cls, list);
            }
            return obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> boolean add(Class<T> cls, T obj) {
        if (!Classes.isImplement(cls, MultiInstance.class)) {
            MapCO mapCO = objMap;
            synchronized (mapCO) {
                block10: {
                    if (!objMap.containsKey(cls)) break block10;
                    return false;
                }
                objMap.put(cls, obj);
            }
        }
        MapCO mapCO = objMap;
        synchronized (mapCO) {
            ArrayList<MultiInstance> list = (ArrayList<MultiInstance>)objMap.get(cls);
            if (list == null) {
                list = new ArrayList<MultiInstance>();
                objMap.put(cls, list);
            }
            MultiInstance instance = (MultiInstance)obj;
            list.add(instance);
            list.trimToSize();
            if (instance != null) {
                instance.setIndex(list.size() - 1);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(Class<?> cls) {
        MapCO mapCO = objMap;
        synchronized (mapCO) {
            objMap.remove(cls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void remove(Class<T> cls, T obj) {
        List list;
        if (!objMap.containsKey(cls)) {
            return;
        }
        if (!Classes.isImplement(cls, MultiInstance.class)) {
            Global.remove(cls);
            return;
        }
        List list2 = list = (List)objMap.get(cls);
        synchronized (list2) {
            int i = 0;
            while (i < list.size()) {
                Object object = list.get(i);
                if (object == obj) {
                    list.set(i, null);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(Class<?> cls, int idx) {
        Asserts.as(cls != null ? null : "\u5220\u9664\u5168\u5c40\u53d8\u91cf\u65f6[\u7c7b\u7ed3\u6784\u53c2\u6570]\u4e0d\u80fd\u4e3anull");
        Asserts.as(idx >= 0 ? null : "\u5220\u9664\u5168\u5c40\u53d8\u91cf\u591a\u4f8b\u5bf9\u8c61\u65f6[\u7d22\u5f15\u53f7]\u4e0d\u6b63\u786e");
        if (!objMap.containsKey(cls)) {
            return;
        }
        if (!Classes.isImplement(cls, MultiInstance.class)) {
            Global.remove(cls);
            return;
        }
        List list = (List)objMap.get(cls);
        if (list.size() <= idx) {
            return;
        }
        List list2 = list;
        synchronized (list2) {
            list.set(idx, null);
        }
    }

    public static void addService(Service service) {
        Asserts.asserts(!serviceMap.containsKey(service.getId()), ZhiqimI18n.globalDuplicateServiceNotSupported);
        serviceMap.put(service.getId(), service);
    }

    public static void removeService(String id) {
        serviceMap.remove(id);
    }

    public static boolean hasService(String id) {
        return serviceMap.containsKey(id);
    }

    public static Service getService(String id) {
        return serviceMap.get(id);
    }

    public static <T> T getService(Class<T> cls, String id) {
        if (Validates.isEmptyBlank(id)) {
            return Global.getService(cls);
        }
        Service service = serviceMap.get(id);
        return (T)(service != null && cls == service.getClass() ? service : null);
    }

    public static <T> T getService(Class<T> cls) {
        List<T> list = Global.getServiceListPrivate(cls);
        return list.isEmpty() ? null : (T)list.get(0);
    }

    public static <T> T getService(Class<T> cls, int idx) {
        List<T> list = Global.getServiceListPrivate(cls);
        return list.isEmpty() ? null : (T)list.get(idx);
    }

    public static <T> List<T> getServiceList(Class<T> cls) {
        return Collections.unmodifiableList(Global.getServiceListPrivate(cls));
    }

    private static <T> List<T> getServiceListPrivate(Class<T> cls) {
        ArrayList<Service> list = new ArrayList<Service>();
        for (Service service : serviceMap.values()) {
            if (cls != service.getClass()) continue;
            list.add(service);
        }
        return list;
    }

    public static void removeServiceAll() {
        ArrayList<Service> serviceList = new ArrayList<Service>(serviceMap.values());
        int i = serviceList.size() - 1;
        while (i >= 0) {
            try {
                Service service = (Service)serviceList.get(i);
                service.destroy();
            }
            catch (Exception exception) {
                Logs.info((Object)"\u7cfb\u7edf[%s]-\u7248\u672c[%s]\u6e05\u7406\u65f6\u6709\u5f02\u5e38\u60c5\u51b5\u53d1\u751f\uff0c\u7531\u5f00\u53d1\u4eba\u5458\u5b9a\u4f4d\uff0c\u672c\u5730\u4e0d\u6253\u5370\u65e5\u5fd7", Global.getName(), Global.getVersion());
            }
            --i;
        }
    }

    public static String addConfig(Config config) {
        if (configMap.containsKey(config.getName())) {
            return config.getName();
        }
        configMap.put(config.getName(), config);
        for (Group group : config.getGroupList()) {
            if (groupMap.containsKey(group.getId())) {
                return group.getId();
            }
            groupMap.put(group.getId(), group);
        }
        return null;
    }

    public static void addConfigByGroup(Group group) {
        String groupId = group.getId();
        Asserts.as(Validates.isNotEmpty(groupId) ? null : "Group\u672a\u914d\u7f6e\u7ec4\u7f16\u53f7\u4e0d\u5141\u8bb8\u589e\u52a0\u5230\u5168\u5c40\u914d\u7f6e\u4e2d");
        Asserts.as(!configMap.containsKey(groupId) ? null : "Group\u7ec4\u7f16\u53f7[%s]\u4f5c\u4e3a\u914d\u7f6e\u540d\u65f6\u6709\u91cd\u590d", groupId);
        Asserts.as(!groupMap.containsKey(groupId) ? null : "Group\u7ec4\u7f16\u53f7[%s]\u6709\u91cd\u590d", groupId);
        Config config = new Config(group.getId());
        config.addGroup(group);
        configMap.put(groupId, config);
        groupMap.put(groupId, group);
    }

    public static void removeConfigByGroupId(String groupId) {
        configMap.remove(groupId);
        groupMap.remove(groupId);
    }

    public static Config getConfig(String name) {
        return configMap.get(name);
    }

    public static void saveConfig(String name) throws Exception {
        Config config = configMap.get(name);
        if (config == null) {
            throw new Exception("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u914d\u7f6e\u4fe1\u606f");
        }
        config.save();
    }

    public static void saveConfigByGroup(String id) throws Exception {
        Group group = groupMap.get(id);
        if (group == null) {
            throw new Exception("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u914d\u7f6e\u4fe1\u606f");
        }
        Config config = configMap.get(group.getName());
        if (config == null) {
            throw new Exception("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u914d\u7f6e\u4fe1\u606f");
        }
        config.save();
    }

    public static boolean hasGroup(String id) {
        return groupMap.containsKey(id);
    }

    public static Group getGroup(String id) {
        return groupMap.get(id);
    }

    public static Collection<Group> getGroupList() {
        return groupMap.values();
    }

    public static boolean hasItem(String id, String key) {
        Group group = groupMap.get(id);
        if (group == null) {
            return false;
        }
        return group.hasItem(key);
    }

    public static String getName() {
        return Global.getString("boot", "name", "\u77e5\u542f\u8499");
    }

    public static String getVersion() {
        return Global.getString("boot", "version", "V1.5.0");
    }

    public static int getPort() {
        return Global.getInt("boot", "port");
    }

    public static String getString(String id, String key) {
        Group group = groupMap.get(id);
        if (group == null) {
            return null;
        }
        return group.getString(key);
    }

    public static String getString(String id, String key, String defaultValue) {
        String value = Global.getString(id, key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static int getInt(String id, String key) {
        String value = Global.getString(id, key);
        if (value == null) {
            return -1;
        }
        return Ints.toInt(value, -1);
    }

    public static int getInt(String id, String key, int defaultValue) {
        int value = Global.getInt(id, key);
        if (value == -1) {
            return defaultValue;
        }
        return value;
    }

    public static long getLong(String id, String key) {
        String value = Global.getString(id, key);
        if (value == null) {
            return -1L;
        }
        return Longs.toLong(value, -1L);
    }

    public static long getLong(String id, String key, long defaultValue) {
        long value = Global.getLong(id, key);
        if (value == -1L) {
            return defaultValue;
        }
        return value;
    }

    public static boolean isTrue(String id, String key) {
        return "true".equalsIgnoreCase(Global.getString(id, key));
    }

    public static boolean isTrue(String id, String key, boolean defaultValue) {
        String value = Global.getString(id, key);
        if (value == null) {
            return defaultValue;
        }
        return "true".equalsIgnoreCase(value);
    }

    public static void setValue(String id, String key, String value) {
        Group group = groupMap.get(id);
        if (group == null) {
            return;
        }
        Item item = group.item(key);
        if (item != null) {
            item.setValue(value);
        }
    }

    public static void setInt(String id, String key, int value) {
        Global.setValue(id, key, String.valueOf(value));
    }

    public static void setLong(String id, String key, long value) {
        Global.setValue(id, key, String.valueOf(value));
    }

    public static void setBoolean(String id, String key, boolean value) {
        Global.setValue(id, key, String.valueOf(value));
    }

    static boolean hasClass(String alias) {
        return aliasMap.containsKey(alias);
    }

    public static void addClass(String alias, Class<?> clazz) {
        aliasMap.put(alias, clazz);
    }

    public static Class<?> getClass(String alias) {
        return aliasMap.get(alias);
    }

    public static Collection<Class<?>> getClassList() {
        return aliasMap.values();
    }

    public static MapSC getClassMap() {
        return aliasMap;
    }

    public static void clearAliasMap() {
        aliasMap.clear();
    }

    public static String getClassName(String className) {
        Object cls = aliasMap.get(className);
        return cls == null ? className : ((Class)cls).getName();
    }

    public static Class<?> forName(String className) {
        Class<?> cls = Global.getClass(className);
        if (cls != null) {
            return cls;
        }
        return Classes.forName(className);
    }

    public static Object newInstance(String className) {
        Class<?> cls = Global.getClass(className);
        if (cls != null) {
            return Classes.newInstance(cls);
        }
        return Classes.newInstance(className);
    }
}

