/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.zml.statement;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.zml.Expression;
import org.zhiqim.zml.ExpressionParser;
import org.zhiqim.zml.Statement;
import org.zhiqim.zml.ZmlVariable;
import org.zhiqim.zml.exception.ExpressionException;
import org.zhiqim.zml.exception.StatementException;
import org.zhiqim.zml.statement._Return;

public class _Interceptor
extends Statement {
    private Expression expression;

    @Override
    public boolean isNesting() {
        return false;
    }

    @Override
    public void parseStatement() throws StatementException {
        String s = Strings.trim((String)this.getStatement(), (String)"<#interceptor ", (String)"/>");
        if (Validates.isEmptyBlank((String)s)) {
            throw new StatementException(this, "<#interceptor>\u672a\u914d\u7f6e\u88ab\u5305\u542b\u7684\u6587\u4ef6\u8def\u5f84");
        }
        try {
            this.expression = ExpressionParser.parseExpression(s);
        }
        catch (ExpressionException e) {
            throw new StatementException(this, "<#interceptor>" + e.getMessage());
        }
    }

    @Override
    public String process(ZmlVariable variableMap) throws StatementException {
        Object request = variableMap.get("request");
        Object response = variableMap.get("response");
        if (request == null || response == null) {
            throw new StatementException(this, "<#interceptor>[request\u6216response]\u53d8\u91cf\u4e0d\u5b58\u5728\uff0c\u4e0d\u652f\u6301\u62e6\u622a\u5668");
        }
        try {
            String[] interceptorArr;
            Method isResponseSuccess = Classes.getMethodDeep(request.getClass(), (String)"isResponseSuccess", (Class[])new Class[0]);
            Method isCommitted = Classes.getMethodDeep(response.getClass(), (String)"isCommitted", (Class[])new Class[0]);
            String interceptors = String.valueOf(this.expression.build(variableMap));
            String[] stringArray = interceptorArr = Arrays.toStringArray((String)interceptors);
            int n = interceptorArr.length;
            int n2 = 0;
            while (n2 < n) {
                String interceptor = stringArray[n2];
                Class interceptorClass = Global.forName((String)interceptor);
                if (interceptorClass == null) {
                    throw new StatementException(this, "<#interceptor>\u914d\u7f6e\u7684\u62e6\u622a\u5668[" + interceptor + "]\u4e0d\u6b63\u786e");
                }
                Method method = null;
                Method[] methodArray = interceptorClass.getDeclaredMethods();
                int n3 = methodArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Class<?>[] paramTypes;
                    Method m = methodArray[n4];
                    if ("intercept".equals(m.getName()) && (paramTypes = m.getParameterTypes()) != null && paramTypes.length == 1) {
                        Class<?> paramType = paramTypes[0];
                        if (Classes.isImplement(request.getClass(), paramType) || request.getClass().isAssignableFrom(paramType)) {
                            method = m;
                            break;
                        }
                    }
                    ++n4;
                }
                if (method == null) {
                    throw new StatementException(this, "<#interceptor>\u914d\u7f6e\u7684\u62e6\u622a\u5668\u6ca1\u6709intercept(request)\u65b9\u6cd5");
                }
                Object obj = Global.getWithoutNew((Class)interceptorClass);
                method.invoke(obj, request);
                if (((Boolean)isCommitted.invoke(response, new Object[0])).booleanValue()) {
                    throw new _Return.ReturnException();
                }
                if (!((Boolean)isResponseSuccess.invoke(request, new Object[0])).booleanValue()) {
                    throw new _Return.ReturnException();
                }
                ++n2;
            }
            return null;
        }
        catch (_Return.ReturnException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                throw new StatementException(this, "<#interceptor>" + ((InvocationTargetException)e).getTargetException().getMessage());
            }
            if (e.getCause() != null) {
                throw new StatementException(this, "<#interceptor>" + e.getCause().getMessage());
            }
            throw new StatementException(this, "<#interceptor>" + e.getMessage());
        }
    }
}

