/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.zml.statement;

import java.util.Iterator;
import java.util.List;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.zml.Expression;
import org.zhiqim.zml.ExpressionParser;
import org.zhiqim.zml.Statement;
import org.zhiqim.zml.StatementNesting;
import org.zhiqim.zml.StatementParser;
import org.zhiqim.zml.ZmlVariable;
import org.zhiqim.zml.exception.StatementException;
import org.zhiqim.zml.statement._Break;
import org.zhiqim.zml.statement._Continue;

public class _For
extends Statement
implements StatementNesting {
    private String itemVariableName;
    private Expression _expression;
    private List<Statement> stmtList;
    private boolean isBeginExclusiveLine = false;
    private transient String content;
    private transient int contentBeginIndex;

    @Override
    public boolean isNesting() {
        return true;
    }

    @Override
    public boolean isExclusiveLine() throws StatementException {
        return super.isExclusiveLine() ? this.isBeginExclusiveLine : false;
    }

    @Override
    public void parseStatement() throws StatementException {
        int index;
        String s = Strings.trim((String)this.getStatement(), (String)"<#for ", (String)"</#for>");
        int ind = s.indexOf(">");
        if (ind == -1) {
            throw new StatementException(this, "<#for>\u672a\u627e\u5230\u5355\u884c\u7ed3\u675f\u7b26");
        }
        String forEach = s.substring(0, ind).trim();
        if (forEach.startsWith("(")) {
            forEach = Strings.trim((String)forEach, (String)"(", (String)")").trim();
        }
        if ((index = (forEach = Strings.trimLeft((String)forEach, (String)"var ").trim()).indexOf(":")) == -1) {
            throw new StatementException(this, "<#for>\u672a\u627e\u5230\u8282\u70b9\u5b9a\u4e49\u7b26");
        }
        this.itemVariableName = forEach.substring(0, index).trim();
        try {
            String expression = forEach.substring(index + ":".length()).trim();
            this._expression = ExpressionParser.parseExpression(expression);
        }
        catch (Exception e) {
            throw new StatementException(this, "<#for>" + e.getMessage());
        }
        this.content = s.substring(ind + 1);
        int brNum = Strings.getStartsWithBrNum((String)this.content);
        if (brNum > 0) {
            this.content = this.content.substring(brNum);
        }
        this.isBeginExclusiveLine = brNum > 0;
        this.contentBeginIndex = this.getBeginIndex() + "<#for ".length() + ind + 1 + brNum;
        this.content = Strings.removeRightMaybeEmptyBlank((String)this.content);
        this.stmtList = StatementParser.parseStatementNesting(this);
        this.content = null;
    }

    @Override
    public String process(ZmlVariable variableMap) throws StatementException {
        Object value = null;
        try {
            value = this._expression.build(variableMap);
        }
        catch (Exception e) {
            throw new StatementException(this, "<#for>" + e.getMessage(), e);
        }
        if (value == null) {
            return null;
        }
        if (!(value instanceof Iterator || value instanceof Iterable || value.getClass().isArray())) {
            throw new StatementException(this, "<#for>\u5bf9\u8c61\u4e0d\u652f\u6301\u8fed\u4ee3");
        }
        try {
            StringBuilder strb = new StringBuilder();
            if (value.getClass().isArray()) {
                Object[] objs = Arrays.toArray((Object)value);
                int i = 0;
                while (i < objs.length) {
                    int status = this.each(objs[i], i, variableMap, strb);
                    if (status != 1) {
                        if (status == 2) {
                            // empty if block
                        }
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                Iterator it = null;
                it = value instanceof Iterable ? ((Iterable)value).iterator() : (Iterator)value;
                int i = 0;
                while (it.hasNext()) {
                    Object obj = it.next();
                    int status = this.each(obj, i, variableMap, strb);
                    if (status != 1) {
                        if (status == 2) {
                            // empty if block
                        }
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            if (this.isEndBreak()) {
                int length = strb.length();
                if (length > 0 && (strb.charAt(length - 1) == '\r' || strb.charAt(length - 1) == '\n')) {
                    strb.setLength(length - 1);
                }
                if ((length = strb.length()) > 0 && (strb.charAt(length - 1) == '\r' || strb.charAt(length - 1) == '\n')) {
                    strb.setLength(length - 1);
                }
            }
            return strb.toString();
        }
        catch (Exception e) {
            throw new StatementException(this, "<#for>" + e.getMessage(), e);
        }
    }

    private int each(Object obj, int index, ZmlVariable variableMap, StringBuilder strb) throws StatementException {
        HashMapSO localMap = new HashMapSO(2);
        localMap.put(this.itemVariableName, obj);
        localMap.put(String.valueOf(this.itemVariableName) + "_index", (Object)index);
        variableMap.addLocalVariable((MapSO)localMap);
        try {
            try {
                StatementParser.processStatementList(this.stmtList, variableMap, strb);
            }
            catch (_Break.BreakException breakException) {
                variableMap.removeLocalVariable((MapSO)localMap);
                localMap.clear();
                localMap = null;
                return 1;
            }
            catch (_Continue.ContinueException continueException) {
                variableMap.removeLocalVariable((MapSO)localMap);
                localMap.clear();
                localMap = null;
                return 2;
            }
        }
        finally {
            variableMap.removeLocalVariable((MapSO)localMap);
            localMap.clear();
            localMap = null;
        }
        return 0;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public int getContentBeginIndex() {
        return this.contentBeginIndex;
    }

    @Override
    public String getPrevStatement(Statement stmt) throws StatementException {
        int ind = this.stmtList.indexOf(stmt);
        if (ind <= 0) {
            return null;
        }
        return this.stmtList.get(ind - 1).getStatement();
    }

    @Override
    public String getNextStatement(Statement stmt) throws StatementException {
        int ind = this.stmtList.indexOf(stmt);
        if (ind == -1 || ind >= this.stmtList.size() - 1) {
            return null;
        }
        return this.stmtList.get(ind + 1).getStatement();
    }
}

