/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.zml.expression.operator;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.kernel.util.Types;
import org.zhiqim.zml.Expression;
import org.zhiqim.zml.ExpressionParser;
import org.zhiqim.zml.ZmlEngine;
import org.zhiqim.zml.ZmlVariable;
import org.zhiqim.zml.exception.ExpressionException;
import org.zhiqim.zml.exception.StatementException;
import org.zhiqim.zml.expression.Operator;
import org.zhiqim.zml.expression.operator._Bracket;
import org.zhiqim.zml.expression.operator._New;
import org.zhiqim.zml.expression.primitive._Variable;
import org.zhiqim.zml.statement._Function;

public class _Method
extends Operator {
    private String methodName;
    private Expression obj;
    private ArrayList<Expression> paramList;

    public _Method(String methodName) {
        this.methodName = methodName;
        this.paramList = new ArrayList();
    }

    @Override
    public int getType() {
        return 40410;
    }

    @Override
    public Object build(ZmlVariable variableMap) throws ExpressionException {
        if (this.obj == null) {
            return ZmlVariable.chkDynamicVar(this.buildFunction(variableMap));
        }
        if (this.obj instanceof _New) {
            return ZmlVariable.chkDynamicVar(this.buildNewInstance(variableMap));
        }
        return ZmlVariable.chkDynamicVar(this.buildMethod(variableMap));
    }

    private Object buildFunction(ZmlVariable variableMap) throws ExpressionException {
        ZmlEngine engine;
        _Function _function = null;
        try {
            _function = variableMap.getFunction(this.methodName);
        }
        catch (StatementException e) {
            throw new ExpressionException("\u65b9\u6cd5\u8868\u8fbe\u5f0f{" + this + "}" + e.getMessage(), e);
        }
        if (_function == null && (engine = variableMap.getEngine()) != null) {
            try {
                _function = engine.getFunction(this.methodName);
            }
            catch (Exception e) {
                throw new ExpressionException("\u65b9\u6cd5\u8868\u8fbe\u5f0f{" + this + "}" + e.getMessage(), e);
            }
        }
        if (_function == null) {
            throw new ExpressionException("\u65b9\u6cd5\u8868\u8fbe\u5f0f{" + this + "}ZML\u5185\u90e8\u548c\u5168\u5c40\u51fd\u6570\u90fd\u672a\u627e\u5230\u8be5\u51fd\u6570\u7684\u5b9a\u4e49");
        }
        HashMapSO pageMap = new HashMapSO();
        pageMap.putAll(variableMap.getVariableMap());
        List<String> varList = _function.getVariableNameList();
        int i = 0;
        while (i < this.paramList.size()) {
            String key = varList.get(i);
            Object value = this.paramList.get(i).build(variableMap);
            pageMap.put(key, value);
            ++i;
        }
        try {
            ZmlVariable variable = new ZmlVariable();
            variable.setZml(variableMap.getZml());
            variable.setVariableMap((MapSO)pageMap);
            variable.setContextMap(variableMap.getContextMap());
            variable.setFunctionMap(variableMap.getFunctionMap());
            return _function.build(variable);
        }
        catch (StatementException e) {
            throw new ExpressionException("\u65b9\u6cd5\u8868\u8fbe\u5f0f{" + this + "}\u5bf9\u5e94\u7684\u5168\u5c40\u51fd\u6570\u5904\u7406\u5f02\u5e38", e);
        }
    }

    private Object buildNewInstance(ZmlVariable variableMap) throws ExpressionException {
        Constructor<?>[] constructors;
        Class newClass = ZmlEngine.getJavaClass(this.methodName);
        if (newClass == null) {
            newClass = Global.forName((String)this.methodName);
        }
        if (newClass == null) {
            throw new ExpressionException("\u65b9\u6cd5\u8868\u8fbe\u5f0f{" + this + "}\u5bf9\u5e94\u7684new\u6784\u9020\u51fd\u6570\u7c7b\u540d\u4e0d\u6b63\u786e");
        }
        Object[] paramArray = new Object[this.paramList.size()];
        int i = 0;
        while (i < this.paramList.size()) {
            paramArray[i] = this.paramList.get(i).build(variableMap);
            ++i;
        }
        Constructor<?> constructor = null;
        Constructor<?>[] constructorArray = constructors = newClass.getConstructors();
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> c = constructorArray[n2];
            Class<?>[] paramTypes = c.getParameterTypes();
            if (paramTypes.length == paramArray.length) {
                boolean isSuccess = true;
                int i2 = 0;
                while (i2 < paramTypes.length) {
                    Class<?> clazz = paramTypes[i2];
                    Object param = paramArray[i2];
                    if (param == null) {
                        if (Types.isPrimitive(clazz)) {
                            isSuccess = false;
                            break;
                        }
                    } else if (Types.isPrimitive(clazz)) {
                        if (Types.isInteger(clazz) && !Types.isInteger((Object)param) || Types.isDecimal(clazz) && !Types.isDecimal((Object)param) || Types.isBoolean(clazz) && !Types.isBoolean((Object)param) || Types.isChar(clazz) && !Types.isChar((Object)param)) {
                            isSuccess = false;
                            break;
                        }
                    } else if (clazz != param.getClass() && !clazz.isAssignableFrom(param.getClass())) {
                        isSuccess = false;
                        break;
                    }
                    ++i2;
                }
                if (isSuccess) {
                    constructor = c;
                    break;
                }
            }
            ++n2;
        }
        if (constructor == null) {
            throw new ExpressionException("\u65b9\u6cd5\u8868\u8fbe\u5f0f{" + this + "}\uff0c\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6784\u9020\u51fd\u6570");
        }
        Class<?>[] paramTypes = constructor.getParameterTypes();
        int i3 = 0;
        while (i3 < paramTypes.length) {
            Class<?> clazz = paramTypes[i3];
            if (Types.isNumber(clazz)) {
                Object param;
                if (Types.isDecimal(clazz)) {
                    param = paramArray[i3];
                    if (!Types.isDecimal((Object)param)) {
                        throw new ExpressionException("\u65b9\u6cd5\u8868\u8fbe\u5f0f{" + this + "}\uff0c\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u53c2\u6570\u4e0d\u5339\u914d\uff0c\u8981\u6c42\u5c0f\u6570");
                    }
                    paramArray[i3] = Types.isDouble(clazz) ? (Number)((Number)param).doubleValue() : (Number)Float.valueOf(((Double)param).floatValue());
                } else {
                    param = paramArray[i3];
                    if (!Types.isInteger((Object)param)) {
                        throw new ExpressionException("\u65b9\u6cd5\u8868\u8fbe\u5f0f{" + this + "}\uff0c\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u53c2\u6570\u4e0d\u5339\u914d\uff0c\u8981\u6c42\u6574\u6570");
                    }
                    paramArray[i3] = Types.isLong(clazz) ? (Number)((Number)param).longValue() : (Number)(Types.isInt(clazz) ? (Number)((Number)param).intValue() : (Number)(Types.isShort(clazz) ? (Number)((Number)param).shortValue() : (Number)((Number)param).byteValue()));
                }
            }
            ++i3;
        }
        try {
            constructor.setAccessible(true);
            return constructor.newInstance(paramArray);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                throw new ExpressionException("\u65b9\u6cd5\u8868\u8fbe\u5f0f{" + this + "}\uff0c\u8c03\u7528\u5931\u8d25{" + ((InvocationTargetException)e).getTargetException().getMessage() + "}");
            }
            throw new ExpressionException("\u65b9\u6cd5\u8868\u8fbe\u5f0f{" + this + "}\uff0c\u8c03\u7528\u5931\u8d25{" + e.getMessage() + "}");
        }
    }

    private Object buildMethod(ZmlVariable variableMap) throws ExpressionException {
        Object target = this.obj.build(variableMap);
        if (target != null) {
            return this.buildMethod(variableMap, target.getClass(), target);
        }
        if (!(this.obj instanceof _Variable)) {
            return null;
        }
        Class<?> targetClass = ((_Variable)this.obj).buildClass();
        if (targetClass == null) {
            return null;
        }
        return this.buildMethod(variableMap, targetClass, null);
    }

    private Object buildMethod(ZmlVariable variableMap, Class<?> targetClass, Object target) throws ExpressionException {
        boolean lastParamIsArray;
        Class[] paramTypes;
        ArrayList<Method> normalMethodList = new ArrayList<Method>();
        ArrayList<Method> arrayMethodList = new ArrayList<Method>();
        Method[] methods = targetClass.getMethods();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equals(this.methodName) && (target != null || Classes.isStaticMethod((Method)m))) {
                if (Classes.isMethodLastParamArray((Method)m)) {
                    arrayMethodList.add(m);
                } else {
                    normalMethodList.add(m);
                }
            }
            ++n2;
        }
        if (normalMethodList.isEmpty()) {
            throw new ExpressionException("\u65b9\u6cd5\u8868\u8fbe\u5f0f{" + this + "}\uff0c\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u65b9\u6cd5\u540d\u6216\u8981\u6c42\u662f\u9759\u6001\u65b9\u6cd5");
        }
        Object[] paramArray = new Object[this.paramList.size()];
        int i = 0;
        while (i < this.paramList.size()) {
            paramArray[i] = this.paramList.get(i).build(variableMap);
            ++i;
        }
        Method method = null;
        for (Method m : normalMethodList) {
            paramTypes = m.getParameterTypes();
            if (!Classes.isMethodParamMatch((Class[])paramTypes, (Object[])paramArray)) continue;
            method = m;
            break;
        }
        if (method == null) {
            for (Method m : arrayMethodList) {
                int arrayLen;
                paramTypes = m.getParameterTypes();
                int typeLen = paramTypes.length;
                if (typeLen > (arrayLen = paramArray.length)) continue;
                if (typeLen == arrayLen) {
                    if (!Classes.isMethodParamMatch((Class[])paramTypes, (Object[])paramArray)) continue;
                    method = m;
                    break;
                }
                Class<?> paramLastType = paramTypes[typeLen - 1].getComponentType();
                Class[] newParamTypes = new Class[arrayLen];
                int i2 = 0;
                while (i2 < typeLen - 1) {
                    newParamTypes[i2] = paramTypes[i2];
                    ++i2;
                }
                i2 = typeLen - 1;
                while (i2 < arrayLen) {
                    newParamTypes[i2] = paramLastType;
                    ++i2;
                }
                if (!Classes.isMethodParamMatch((Class[])newParamTypes, (Object[])paramArray)) continue;
                method = m;
                break;
            }
        }
        if (method == null) {
            throw new ExpressionException("\u65b9\u6cd5\u8868\u8fbe\u5f0f{" + this + "}\uff0c\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u65b9\u6cd5\u540d\u627e\u5230\uff0c\u4f46\u53c2\u6570\u4e2a\u6570\u672a\u5bf9\u5e94");
        }
        Class<?>[] paramTypes2 = method.getParameterTypes();
        int i3 = 0;
        while (i3 < paramTypes2.length) {
            Class<?> clazz = paramTypes2[i3];
            if (Types.isNumber(clazz)) {
                if (Types.isDecimal(clazz)) {
                    Object param = paramArray[i3];
                    if (!Types.isDecimal((Object)param)) {
                        throw new ExpressionException("\u65b9\u6cd5\u8868\u8fbe\u5f0f{" + this + "}\uff0c\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u65b9\u6cd5\u540d\u627e\u5230\u4e14\u53c2\u6570\u4e2a\u6570\u4e00\u81f4\uff0c\u53c2\u6570\u503c\u4e0d\u5339\u914d\uff0c\u8981\u6c42\u5c0f\u6570");
                    }
                    paramArray[i3] = Types.isDouble(clazz) ? (Number)((Number)param).doubleValue() : (Number)Float.valueOf(((Double)param).floatValue());
                } else {
                    Object param = paramArray[i3];
                    if (!Types.isInteger((Object)param)) {
                        throw new ExpressionException("\u65b9\u6cd5\u8868\u8fbe\u5f0f{" + this + "}\uff0c\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u65b9\u6cd5\u540d\u627e\u5230\u4e14\u53c2\u6570\u4e2a\u6570\u4e00\u81f4\uff0c\u53c2\u6570\u4e0d\u5339\u914d\uff0c\u8981\u6c42\u6574\u6570");
                    }
                    paramArray[i3] = Types.isLong(clazz) ? (Number)((Number)param).longValue() : (Number)(Types.isInt(clazz) ? (Number)((Number)param).intValue() : (Number)(Types.isShort(clazz) ? (Number)((Number)param).shortValue() : (Number)((Number)param).byteValue()));
                }
            }
            ++i3;
        }
        boolean bl = lastParamIsArray = paramTypes2.length > 0 && Types.isArray(paramTypes2[paramTypes2.length - 1]);
        if (lastParamIsArray && !Types.isArray((Object)paramArray[paramTypes2.length - 1])) {
            Class<?> paramLastType = paramTypes2[paramTypes2.length - 1].getComponentType();
            int num = paramArray.length - paramTypes2.length + 1;
            Object[] objs = Classes.newInstance(paramLastType, (int)num);
            int i4 = 0;
            while (i4 < num) {
                objs[i4] = paramArray[paramTypes2.length - 1 + i4];
                ++i4;
            }
            Object[] newParamArray = new Object[paramTypes2.length];
            int i5 = 0;
            while (i5 < newParamArray.length - 1) {
                newParamArray[i5] = paramArray[i5];
                ++i5;
            }
            newParamArray[newParamArray.length - 1] = objs;
            paramArray = newParamArray;
        }
        try {
            method.setAccessible(true);
            if (Classes.isStaticMethod((Method)method)) {
                return method.invoke(null, paramArray);
            }
            return method.invoke(target, paramArray);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                throw new ExpressionException("\u65b9\u6cd5\u8868\u8fbe\u5f0f{" + this + "}\uff0c\u8c03\u7528\u5931\u8d25{" + ((InvocationTargetException)e).getTargetException().getMessage() + "}");
            }
            throw new ExpressionException("\u65b9\u6cd5\u8868\u8fbe\u5f0f{" + this + "}\uff0c\u8c03\u7528\u5931\u8d25{" + e.getMessage() + "}");
        }
    }

    @Override
    public String toString() {
        StringBuilder strb = new StringBuilder();
        if (this.obj != null) {
            strb.append(this.obj);
            if (this.obj instanceof _New) {
                strb.append(" ");
            } else {
                strb.append(".");
            }
        }
        strb.append(this.methodName).append("(");
        if (!this.paramList.isEmpty()) {
            strb.append(this.paramList.get(0));
            int i = 1;
            while (i < this.paramList.size()) {
                strb.append(", ").append(this.paramList.get(i));
                ++i;
            }
        }
        strb.append(")");
        return strb.toString();
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Expression getObject() {
        return this.obj;
    }

    public void setObject(Expression obj) {
        this.obj = obj;
    }

    public void setNew(Expression obj, String className) {
        this.obj = obj;
        this.methodName = className;
    }

    public void parseBracketParamList(_Bracket bracket) throws ExpressionException {
        ArrayList<Expression> eList = bracket.getExpressionList();
        eList.trimToSize();
        eList.remove(0);
        eList.remove(eList.size() - 1);
        ExpressionParser.parse_Operator(eList);
        for (Expression expression : eList) {
            int type = expression.getType();
            if (type == 44) continue;
            this.paramList.add(expression);
        }
        eList = null;
        this.paramList.trimToSize();
    }
}

