/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.zml;

import java.io.StringWriter;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.SignConstants;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.extend.MapS;
import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.zml.Zml;

@AnAlias(value={"Zmls"})
public class Zmls
implements SignConstants {
    public static String format(String content) {
        if (content == null) {
            return "";
        }
        StringBuilder strb = new StringBuilder();
        int i = 0;
        while (i < content.length()) {
            char c = content.charAt(i);
            block0 : switch (c) {
                case '<': {
                    strb.append("&lt;");
                    break;
                }
                case '>': {
                    strb.append("&gt;");
                    break;
                }
                case '\'': {
                    strb.append("&apos;");
                    break;
                }
                case '\"': {
                    strb.append("&quot;");
                    break;
                }
                case '{': {
                    if (i == 0) {
                        strb.append(c);
                        break;
                    }
                    switch (content.charAt(i - 1)) {
                        case '$': {
                            strb.setLength(strb.length() - 1);
                            strb.append("&#x24;{");
                            break block0;
                        }
                        case '@': {
                            strb.setLength(strb.length() - 1);
                            strb.append("&#x40;{");
                            break block0;
                        }
                        case '#': {
                            strb.setLength(strb.length() - 1);
                            strb.append("&#x23;{");
                            break block0;
                        }
                    }
                    strb.append(c);
                    break;
                }
                default: {
                    strb.append(c);
                }
            }
            ++i;
        }
        return strb.toString();
    }

    public static String parse(String content, String key, Object value) throws Exception {
        return Zmls.parse(new Zml(content), key, value);
    }

    public static String parse(String content, MapSO variableMap, MapS ... contextMap) throws Exception {
        return Zmls.parse(new Zml(content), variableMap, contextMap);
    }

    public static String parseContext(String content, MapS ... contextMap) throws Exception {
        return Zmls.parseContext(new Zml(content), contextMap);
    }

    public static String parse(Zml zml, String key, Object value) throws Exception {
        return Zmls.parse(zml, (MapSO)new HashMapSO(key, value), new MapS[0]);
    }

    public static String parse(Zml zml, MapSO variableMap, MapS ... contextMap) throws Exception {
        StringWriter writer = new StringWriter();
        zml.process(writer, variableMap, contextMap);
        return writer.toString();
    }

    public static String parseContext(Zml zml, MapS ... contextMap) throws Exception {
        StringWriter writer = new StringWriter();
        zml.process(writer, null, contextMap);
        return writer.toString();
    }
}

