/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_project.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.project.dbo;

import java.io.Serializable;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.orm.annotation.*;

/**
 * 项目信息表 对应表《ZPM_PROJECT》
 */
@AnAlias("ZpmProject")
@AnTable(table="ZPM_PROJECT", key="PROJECT_ID", type="InnoDB")
public class ZpmProject implements Serializable
{
    private static final long serialVersionUID = 1L;

    @AnTableField(column="PROJECT_ID", type="long", notNull=true)    private long projectId;    //1.项目编号
    @AnTableField(column="PROJECT_NAME", type="string,64", notNull=true)    private String projectName;    //2.项目名称
    @AnTableField(column="PROJECT_STATUS", type="byte", notNull=true)    private int projectStatus;    //3.项目状态，0：正常，1：停用
    @AnTableField(column="PROJECT_SEQ", type="int", notNull=true)    private int projectSeq;    //4.项目排序数
    @AnTableField(column="PROJECT_MANAGER", type="string,32", notNull=true)    private String projectManager;    //5.项目组长
    @AnTableField(column="PROJECT_BEGIN_DATE", type="string,10,char", notNull=true)    private String projectBeginDate;    //6.项目开始时间
    @AnTableField(column="PROJECT_END_DATE", type="string,10,char", notNull=true)    private String projectEndDate;    //7.项目结束时间
    @AnTableField(column="PROJECT_CREATED", type="string,19,char", notNull=true)    private String projectCreated;    //8.项目创建时间
    @AnTableField(column="PROJECT_MODIFIED", type="string,19,char", notNull=true)    private String projectModified;    //9.项目修改时间
    @AnTableField(column="PROJECT_DESC", type="string,512", notNull=false)    private String projectDesc;    //10.项目描述

    public String toString()
    {
        return Jsons.toString(this);
    }

    public long getProjectId()
    {
        return projectId;
    }

    public void setProjectId(long projectId)
    {
        this.projectId = projectId;
    }

    public String getProjectName()
    {
        return projectName;
    }

    public void setProjectName(String projectName)
    {
        this.projectName = projectName;
    }

    public int getProjectStatus()
    {
        return projectStatus;
    }

    public void setProjectStatus(int projectStatus)
    {
        this.projectStatus = projectStatus;
    }

    public int getProjectSeq()
    {
        return projectSeq;
    }

    public void setProjectSeq(int projectSeq)
    {
        this.projectSeq = projectSeq;
    }

    public String getProjectManager()
    {
        return projectManager;
    }

    public void setProjectManager(String projectManager)
    {
        this.projectManager = projectManager;
    }

    public String getProjectBeginDate()
    {
        return projectBeginDate;
    }

    public void setProjectBeginDate(String projectBeginDate)
    {
        this.projectBeginDate = projectBeginDate;
    }

    public String getProjectEndDate()
    {
        return projectEndDate;
    }

    public void setProjectEndDate(String projectEndDate)
    {
        this.projectEndDate = projectEndDate;
    }

    public String getProjectCreated()
    {
        return projectCreated;
    }

    public void setProjectCreated(String projectCreated)
    {
        this.projectCreated = projectCreated;
    }

    public String getProjectModified()
    {
        return projectModified;
    }

    public void setProjectModified(String projectModified)
    {
        this.projectModified = projectModified;
    }

    public String getProjectDesc()
    {
        return projectDesc;
    }

    public void setProjectDesc(String projectDesc)
    {
        this.projectDesc = projectDesc;
    }

}
