/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_project.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.project.dbo;

import org.zhiqim.project.dbo.ZpmPersonReader;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.orm.annotation.*;

/**
 * 个人汇报视图 对应视图《ZPM_PERSON_READER_EX》
 */
@AnAlias("ZpmPersonReaderEx")
@AnView("ZPM_PERSON_READER,ZMR_OPERATOR a,ZMR_OPERATOR b")
@AnViewJoin({@AnViewJoinValue(type="EQUAL", lTable="ZPM_PERSON_READER", lColumn="OPERATOR_CODE", rTable="a", rColumn="OPERATOR_CODE"),
             @AnViewJoinValue(type="EQUAL", lTable="ZPM_PERSON_READER", lColumn="READER_CODE", rTable="b", rColumn="OPERATOR_CODE")})
public class ZpmPersonReaderEx extends ZpmPersonReader
{
    private static final long serialVersionUID = 1L;

    @AnViewField(table="a", column="OPERATOR_NAME")    private String operatorName;    //2.操作员名称
    @AnViewField(table="a", column="OPERATOR_AVATAR")    private long operatorAvatar;    //3.操作员头像编号
    @AnViewField(table="b", column="OPERATOR_NAME")    private String readerName;    //4.
    @AnViewField(table="b", column="OPERATOR_AVATAR")    private long readerAvatar;    //5.

    public String toString()
    {
        return Jsons.toString(this);
    }

    public String getOperatorName()
    {
        return operatorName;
    }

    public void setOperatorName(String operatorName)
    {
        this.operatorName = operatorName;
    }

    public long getOperatorAvatar()
    {
        return operatorAvatar;
    }

    public void setOperatorAvatar(long operatorAvatar)
    {
        this.operatorAvatar = operatorAvatar;
    }

    public String getReaderName()
    {
        return readerName;
    }

    public void setReaderName(String readerName)
    {
        this.readerName = readerName;
    }

    public long getReaderAvatar()
    {
        return readerAvatar;
    }

    public void setReaderAvatar(long readerAvatar)
    {
        this.readerAvatar = readerAvatar;
    }

}
