/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_project.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.project.dbo;

import org.zhiqim.project.dbo.ZpmProject;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.orm.annotation.*;

/**
 * 项目成员所有工程视图 对应视图《ZPM_MEMBER_PROJECT》
 */
@AnAlias("ZpmMemberProject")
@AnView("ZPM_MEMBER,ZPM_PROJECT")
@AnViewJoin({@AnViewJoinValue(type="EQUAL", lTable="ZPM_MEMBER", lColumn="PROJECT_ID", rTable="ZPM_PROJECT", rColumn="PROJECT_ID")})
public class ZpmMemberProject extends ZpmProject
{
    private static final long serialVersionUID = 1L;

    @AnViewField(table="ZPM_MEMBER", column="OPERATOR_CODE")    private String operatorCode;    //2.操作员编码

    public String toString()
    {
        return Jsons.toString(this);
    }

    public String getOperatorCode()
    {
        return operatorCode;
    }

    public void setOperatorCode(String operatorCode)
    {
        this.operatorCode = operatorCode;
    }

}
