/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_project.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.project.action;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.kernel.paging.PageResult;
import org.zhiqim.orm.ORM;
import org.zhiqim.orm.ZTable;
import org.zhiqim.orm.ZView;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.project.ZpmConstants;
import org.zhiqim.project.ZpmProjectDao;
import org.zhiqim.project.dbo.ZpmMemberEx;
import org.zhiqim.project.dbo.ZpmProject;

/**
 * 项目成员列表
 *
 * @version v1.0.0 @author huangsufang 2017-9-25 新建与整理
 */
public class MemberAction implements Action, ZpmConstants
{
    @Override
    public void execute(HttpRequest request) throws Exception
    {
        long projectId = ZpmProjectDao.getProjectId(request);
        ZpmProject project = ORM.get(ZTable.class, request).item(ZpmProject.class, projectId);
            
        int page = request.getParameterInt("page", 1);
        int pageSize = request.getContextAttributeInt("zmr_page_size", 10);
        
        PageResult<ZpmMemberEx> result = ORM.get(ZView.class, request).page(ZpmMemberEx.class, page, pageSize, new Selector("projectId", projectId).addOrderbyAsc("memberType"));
        result.addConditionMap(request.getParameterMap());
        
        request.setAttribute("project", project);
        request.setAttribute("result", result);
    }
}
