/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_project.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.project;

import java.sql.SQLException;
import java.util.List;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.util.Ids;
import org.zhiqim.kernel.util.Sqls;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.orm.ORM;
import org.zhiqim.orm.ORMException;
import org.zhiqim.orm.ZTable;
import org.zhiqim.orm.ZView;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.project.dbo.ZpmMember;
import org.zhiqim.project.dbo.ZpmMemberEx;
import org.zhiqim.project.dbo.ZpmReport;

/**
 * 项目成员数据访问对象
 *
 * @version v1.0.0 @author zouzhigang 2017-11-9 新建与整理
 */
@AnAlias("ZpmMemberDao")
public class ZpmMemberDao
{
    /**
     * 获取当前请求的成员列表
     * 
     * @param request       请求
     * @return              模块列表
     * @throws Exception    异常
     */
    public static List<ZpmMember> list(HttpRequest request) throws Exception
    {
        Selector selector = new Selector();
        selector.addMust("projectId", ZpmProjectDao.getProjectId(request));
        selector.addOrderbyAsc("memberType");
        
        return ORM.get(ZTable.class, request).list(ZpmMember.class, selector);
    }
    
    /**
     * 获取当前请求的成员扩展列表
     * 
     * @param request       请求
     * @return              模块列表
     * @throws Exception    异常
     */
    public static List<ZpmMemberEx> listx(HttpRequest request) throws Exception
    {
        Selector selector = new Selector();
        selector.addMust("projectId", ZpmProjectDao.getProjectId(request));
        selector.addOrderbyAsc("memberType");
        
        return ORM.get(ZView.class, request).list(ZpmMemberEx.class, selector);
    }
    

    /**
     * 记录项目成员动态，指定功能和功能目标
     * 
     * @param request       请求对象
     * @param projectId     项目编号
     * @param operatorCode  操作员编码
     * @param featrue       功能描述
     * @param target        功能目标
     * @throws SQLException 数据库异常
     * @throws ORMException 数据映射异常
     */
    public static void report(HttpRequest request, long projectId, String operatorCode, String featrue, Object target) throws SQLException, ORMException
    {
        String reportDesc = featrue + " $" + Strings.toString(target);
        report(request, projectId, operatorCode, reportDesc);
    }
    
    /**
     * 记录项目成员动态，指定功能和功能目标
     * 
     * @param request       请求对象
     * @param projectId     项目编号
     * @param operatorCode  操作员编码
     * @param featrue       功能描述
     * @param target        功能目标
     * @throws SQLException 数据库异常
     * @throws ORMException 数据映射异常
     */
    public static void report(HttpRequest request, String operatorCode, long projectId, String featrue, Object target) throws SQLException, ORMException
    {
        String reportDesc = featrue + " @" + Strings.toString(target);
        report(request, projectId, operatorCode, reportDesc);
    }
    
    /**
     * 记录项目成员动态，指定操作和功能及功能目标
     * 
     * @param request       请求对象
     * @param operatorCode  操作员编码
     * @param projectId     项目编号
     * @param target        功能目标
     * @param featrue       功能描述
     * @param issueSeq      问题排序
     * @throws SQLException 数据库异常
     * @throws ORMException 数据映射异常
     */
    public static void report(HttpRequest request, String operatorCode, long projectId, String target, String featrue, int issueSeq) throws SQLException, ORMException
    {
        String reportDesc = target + " " + featrue + " #" + issueSeq;
        report(request, projectId, operatorCode, reportDesc);
    }
    
    /**
     * 记录项目成员动态，指定功能和功能目标及被操作人
     * 
     * @param request       请求对象
     * @param projectId     项目编号
     * @param operatorCode  操作员编码
     * @param featrue       功能描述
     * @param target        功能目标
     * @param member        被操作人
     * @throws SQLException 数据库异常
     * @throws ORMException 数据映射异常
     */
    public static void report(HttpRequest request, long projectId, String operatorCode, String featrue, int target, String member) throws SQLException, ORMException
    {
        String reportDesc = featrue + " #" + target + "   @" + member;
        report(request, projectId, operatorCode, reportDesc);
    }
    
    
    
    /**
     * 记录项目成员动态
     * 
     * @param request       请求对象
     * @param projectId     项目编号
     * @param operatorCode  操作员编码
     * @param reportDesc    动态信息
     * @throws SQLException 数据库异常
     * @throws ORMException 数据映射异常
     * */
    public static void report(HttpRequest request, long projectId, String operatorCode, String reportDesc) throws SQLException, ORMException
    {
        ZpmReport report = new ZpmReport();
        report.setProjectId(projectId);
        report.setOperatorCode(operatorCode);
        report.setReportId(Ids.longId());
        report.setReportTime(Sqls.nowTimestamp());
        report.setReportDesc(reportDesc);
        
        ORM.get(ZTable.class, request).insert(report);
    }
}
