/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_project.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.project;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.core.Interceptor;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.manager.ZmrSessionUser;
import org.zhiqim.orm.ORM;
import org.zhiqim.orm.ZTable;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.project.dbo.ZpmProject;

@AnAlias("chkZpmProject")
public class ZpmInterceptor implements Interceptor, ZpmConstants
{
    @Override
    public void intercept(HttpRequest request) throws Exception
    {
        ZmrSessionUser sessionUser = request.getSessionUser(ZmrSessionUser.class);
        long projectId = sessionUser.getOperatorParamLong(FPM_PROJECT_ID_KEY);
        if (projectId == -1)
        {
            if (request.getParameterBoolean(_PARAM_DIALOG_FRAME_))
                request.returnCloseDialog("请选择一个有效的项目");
            else
                request.setRedirect(request.getRootPath("/zhiqim_project/project.htm"), "请选择一个有效的项目");
            return;
        }
        
        if (ORM.get(ZTable.class, request).count(ZpmProject.class, new Selector("projectId", projectId).addMust("projectStatus", 0)) == 0)
        {//当前项目已删除或被停用，或成员被删除
            
            //重新选择默认项目
            ZpmProjectDao.doActiveProject(request,sessionUser);
            projectId = sessionUser.getOperatorParamLong(FPM_PROJECT_ID_KEY);
            if (projectId == -1)
            {//仍没有项目
                if (request.getParameterBoolean(_PARAM_DIALOG_FRAME_))
                    request.returnCloseDialog("请选择一个有效的项目");
                else
                    request.setRedirect(request.getRootPath("/zhiqim_project/project.htm"), "请选择一个有效的项目");
                return;
            }
        }
    }
}
