/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_project.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.project;

import org.zhiqim.httpd.context.ZmlContextConstants;
import org.zhiqim.kernel.annotation.AnAlias;

/**
 * 凡狐项目常量定义表
 *
 * @version v1.0.0 @author zouzhigang 2017-10-14 新建与整理
 */
@AnAlias("ZpmConstants")
public interface ZpmConstants extends ZmlContextConstants
{
    /** 权限获取成功&失败 */
    public static final int FPM_RULE_INIT                   = 0;
    public static final int FPM_RULE_SUCC                   = 1;
    public static final int FPM_RULE_FAIL                   = 2;
    
    /*****************************************************************************/
    //项目存储KEY
    /*****************************************************************************/
    
    /** 操作员默认项目成员保存到会话中的KEY */
    public static final String FPM_MEMBER_KEY               = "zpmMember";
    
    /** 操作员存储到操作员参数字段的默认项目编号KEY */
    public static final String FPM_PROJECT_ID_KEY           = "zpmProjectId";
    
    /*****************************************************************************/
    //项目成员7种角色编码
    /*****************************************************************************/
    
    /** 管理 */
    public static final String FPM_ROLE_MANAGE              = "manage";
    
    /** 需求 */
    public static final String FPM_ROLE_DEMAND              = "demand";
    
    /** 观察 */
    public static final String FPM_ROLE_OBSERVER            = "observer";
    
    /** 设计 */
    public static final String FPM_ROLE_DESIGN              = "design";
    
    /** 开发 */
    public static final String FPM_ROLE_DEVELOPMENT         = "development";
    
    /** 测试 */
    public static final String FPM_ROLE_TEST                = "test";
    
    /** 运维 */
    public static final String FPM_ROLE_OPERATION           = "operation";
    
    
    /*****************************************************************************/
    //项目成员8种常用仓库编码
    /*****************************************************************************/
    
    /** 文档库 */
    public static final String FPM_REOP_DOCUMENT            = "document";
    
    /** 设计库 */
    public static final String FPM_REOP_DESIGN              = "design";
    
    /** 开发库 */
    public static final String FPM_REOP_DEVELOPMENT         = "development";
    
    /** 测试库 */
    public static final String FPM_REOP_TEST                = "test";
    
    /** 发布库 */
    public static final String FPM_REOP_RELEASE             = "release";
    
    /** 运维库 */
    public static final String FPM_REOP_PROJECT             = "operation";
    
    /** 管理库 */
    public static final String FPM_REOP_MANAGE              = "manage";
    
    /** 备份库 */
    public static final String FPM_REOP_BACKUP              = "backup";
}
