/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.orm.policy;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.extend.LinkedMapSO;
import org.zhiqim.kernel.extend.MapSS;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Ints;
import org.zhiqim.kernel.util.Lists;
import org.zhiqim.kernel.util.Sqls;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.orm.ORMException;
import org.zhiqim.orm.ORMI18n;
import org.zhiqim.orm.ORMPolicy;
import org.zhiqim.orm.ORMServer;
import org.zhiqim.orm.ORMType;
import org.zhiqim.orm.dbo.defined._Table;
import org.zhiqim.orm.dbo.defined._TableField;
import org.zhiqim.orm.dbo.defined._TableIndex;

public class _MySQL
implements ORMPolicy {
    private ORMServer server;

    public _MySQL(ORMServer server) {
        this.server = server;
    }

    @Override
    public boolean chkKeepTime(int maxKeepTime) {
        try {
            List<HashMapSO> list = this.server.sql().executeQuery("show session variables like 'wait_timeout';", HashMapSO.class);
            for (HashMapSO item : list) {
                if (!item.containsKey("Value")) continue;
                int timeout = Ints.toInt((String)((String)item.get("Value")));
                return timeout > maxKeepTime + 180;
            }
        }
        catch (SQLException | ORMException exception) {
            return false;
        }
        return true;
    }

    @Override
    public String toExistsSQL(String databaseName, String tableName) {
        return Strings.format((String)"select count(*) from information_schema.tables where table_schema='%s' and table_name='%s'", (Object[])new Object[]{databaseName, tableName});
    }

    @Override
    public String toAlertColumnAdd(String table, String column, String columnType, boolean notNull) {
        return "alter table " + table.toUpperCase() + " add column " + column.toUpperCase() + " " + columnType + (notNull ? " not null" : " default null");
    }

    @Override
    public String toColumnType(String type) {
        int ctype = ORMType.getColumnTypeMaybeLength(type);
        switch (ctype) {
            case 4: {
                return "tinyint(1)";
            }
            case 5: {
                return "tinyint(4)";
            }
            case 6: {
                return "smallint(6)";
            }
            case 2: {
                return "int";
            }
            case 3: {
                return "bigint";
            }
            case 7: {
                return "datetime";
            }
            case 8: {
                String[] values = Arrays.toStringArray((String)type);
                Asserts.asserts((values.length == 3 ? 1 : 0) != 0, (String)ORMI18n.ormFieldTypeIncorrect1, (Object[])new Object[]{type});
                Asserts.asserts((boolean)Validates.isIntegerPositive((String)values[1]), (String)ORMI18n.ormFieldTypeIncorrect1, (Object[])new Object[]{type});
                Asserts.asserts((boolean)Validates.isIntegerPositive((String)values[2]), (String)ORMI18n.ormFieldTypeIncorrect1, (Object[])new Object[]{type});
                return "decimal(" + values[1] + "," + values[2] + ")";
            }
            case 1: {
                String[] values = Arrays.toStringArray((String)type);
                Asserts.asserts((values.length > 1 ? 1 : 0) != 0, (String)ORMI18n.ormFieldTypeIncorrect1, (Object[])new Object[]{type});
                Asserts.asserts((boolean)Validates.isIntegerPositive((String)values[1]), (String)ORMI18n.ormFieldTypeIncorrect1, (Object[])new Object[]{type});
                if (values.length == 3 && "char".equals(values[2])) {
                    Asserts.asserts((boolean)Validates.isIntegerValue((String)values[1], (int)1, (int)255), (String)ORMI18n.ormFieldTypeIncorrect1, (Object[])new Object[]{type});
                    return "char(" + values[1] + ")";
                }
                int length = Ints.toInt((String)values[1]);
                if (length <= 2000) {
                    return "varchar(" + values[1] + ")";
                }
                if (length <= 20000) {
                    return "text";
                }
                if (length <= 5000000) {
                    return "mediumtext";
                }
                return "longtext";
            }
            case 9: {
                return "mediumblob";
            }
        }
        throw Asserts.exception((String)"\u4f20\u5165\u7684\u7c7b\u578b[%s]\u4e0d\u652f\u6301", (Object[])new Object[]{type});
    }

    @Override
    public String toColumnString(_TableField field) {
        String column = field.getColumn();
        String columnType = this.toColumnType(field.getTypeAndLength());
        boolean notNull = field.isNotNull();
        return column.toUpperCase() + " " + columnType + " " + (notNull ? "NOT NULL" : "NULL");
    }

    @Override
    public List<String> toTableString(_Table _table, MapSS replaceMap) {
        String type = _table.getType();
        String key = _table.getKey();
        String tableReplace = Sqls.formatReplaceMap((String)_table.getTable(), (MapSS)replaceMap);
        ArrayList<String> sqlList = new ArrayList<String>();
        StringBuilder strb = new StringBuilder();
        strb.append("create table if not exists ").append(tableReplace.toUpperCase()).append("\r\n").append("(");
        for (_TableField field : _table.getFieldList()) {
            strb.append("\r\n").append("    ").append(this.toColumnString(field)).append(",");
        }
        if (_table.getKeyArr().length == 0) {
            strb.setLength(strb.length() - 1);
        } else {
            strb.append("\r\n").append("    ").append("primary key (").append(key).append(")");
        }
        strb.append("\r\n").append(")engine=").append(Validates.isEmptyBlank((String)type) ? "InnoDB" : type).append(" default charset=utf8 collate=utf8_general_ci;").append("\r\n");
        sqlList.add(Sqls.formatSpace((String)strb.toString()));
        for (_TableIndex index : _table.getIndexList()) {
            String indexNameReplace = Sqls.formatReplaceMap((String)index.getName(), (MapSS)replaceMap);
            StringBuilder strbIndex = new StringBuilder("create ").append(index.getType()).append(" index ").append(indexNameReplace).append(" on ").append(tableReplace).append("(").append(index.getColumn()).append(");").append("\r\n");
            sqlList.add(Sqls.formatSpace((String)strbIndex.toString()));
        }
        return Lists.trim(sqlList);
    }

    @Override
    public String toItemSQL(String fieldSQL, String tableName, String whereSQL, String orderbySQL, String groupbySQL) {
        return "select " + fieldSQL + " from " + tableName + whereSQL + orderbySQL + groupbySQL + " limit 1";
    }

    @Override
    public String toPageSQL(String fieldSQL, String tableName, String whereSQL, String orderbySQL, String groupbySQL, int maxNum, int pageNo) {
        return "select " + fieldSQL + " from " + tableName + whereSQL + orderbySQL + groupbySQL + " limit #minSize#, #pageSize#";
    }

    @Override
    public String toPageViewSQL(StringBuilder innerTableSQL, int maxNum, int pageNo) {
        return "select * from " + innerTableSQL + " p_ limit #minSize#, #pageSize#";
    }

    @Override
    public void executeAlertColumnDrop(String table, String column) throws ORMException, SQLException {
        this.server.sql().execute("alter table " + table.toUpperCase() + " drop column " + column.toUpperCase());
    }

    @Override
    public void executeAlertColumnName(String table, String column, String newColumn) throws ORMException, SQLException {
        List<LinkedMapSO> result = this.server.sql().executeQuery("select COLUMN_TYPE,IS_NULLABLE from information_schema.columns where table_schema=? and table_name=? and column_name=?", LinkedMapSO.class, new String[]{this.server.getDatabaseName(), table, column});
        if (result.isEmpty()) {
            throw new ORMException("ZSQL[alterColumnRename][\u672a\u627e\u5230\u8868%s\u5217%s]", table, column);
        }
        LinkedMapSO item = result.get(0);
        String columnType = (String)item.get("COLUMN_TYPE");
        boolean notNull = "NO".equals(item.get("IS_NULLABLE"));
        this.server.sql().execute("alter table " + table.toUpperCase() + " change " + column.toUpperCase() + " " + newColumn.toUpperCase() + " " + columnType + (notNull ? " not null" : " default null"));
    }

    @Override
    public void executeAlertColumnType(String table, String column, String newColumnType, boolean newNotNull) throws ORMException, SQLException {
        String sql = "alter table " + table.toUpperCase() + " modify column " + column.toUpperCase() + " " + newColumnType + (newNotNull ? " not null" : " default null");
        this.server.sql().execute(sql);
    }

    @Override
    public void executeAlertColumnInfo(String table, String column, String newColumn, String newColumnType, boolean newNotNull) throws ORMException, SQLException {
        String sql = "alter table " + table.toUpperCase() + " change " + column.toUpperCase() + " " + newColumn.toUpperCase() + " " + newColumnType + (newNotNull ? " not null" : " default null");
        this.server.sql().execute(sql);
    }

    @Override
    public void executeAlertPrimaryKeyAdd(String table, String columns) throws SQLException {
        this.server.sql().execute("alter table " + table + " add primary key(" + columns + ")");
    }

    @Override
    public void executeAlertPrimaryKeyDrop(String table) throws SQLException {
        this.server.sql().execute("alter table " + table + " drop primary key");
    }
}

