/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.orm.impl;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.zhiqim.kernel.MultiInstancer;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.extend.LinkedMapSO;
import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.kernel.extend.MapSS;
import org.zhiqim.kernel.paging.PageBuilder;
import org.zhiqim.kernel.paging.PageResult;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.orm.ORMConstants;
import org.zhiqim.orm.ORMException;
import org.zhiqim.orm.ORMI18n;
import org.zhiqim.orm.ORMServer;
import org.zhiqim.orm.ORMType;
import org.zhiqim.orm.ZSQL;
import org.zhiqim.orm.ZTable;
import org.zhiqim.orm.ZTabler;
import org.zhiqim.orm.ZView;
import org.zhiqim.orm.annotation.AnTable;
import org.zhiqim.orm.annotation.AnTableField;
import org.zhiqim.orm.annotation.AnView;
import org.zhiqim.orm.annotation.AnViewField;
import org.zhiqim.orm.annotation.AnViewJoin;
import org.zhiqim.orm.annotation.AnViewJoinValue;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.orm.dbo.defined._Table;
import org.zhiqim.orm.dbo.defined._TableField;
import org.zhiqim.orm.dbo.defined._View;

public final class ZViewImplement
extends MultiInstancer
implements ZView,
ORMConstants {
    private ORMServer server;
    private ZSQL zSQL;
    private ZTabler zTabler;
    private ZTable zTable;
    private HashSet<String> existViewList;
    private HashMap<Class<?>, _View> viewMap;

    public ZViewImplement(ORMServer server) {
        this.server = server;
        this.zSQL = server.sql();
        this.zTabler = server.tabler();
        this.zTable = server.table();
        this.existViewList = new HashSet();
        this.viewMap = new HashMap();
    }

    public _View getView(Class<?> clazz) {
        int n;
        int n2;
        Object[] objectArray;
        _View _view = this.viewMap.get(clazz);
        if (_view != null) {
            return _view;
        }
        AnView anView = clazz.getAnnotation(AnView.class);
        if (anView == null) {
            return null;
        }
        String table = anView.value();
        _view = new _View(clazz.getName(), table);
        AnViewJoin join = clazz.getAnnotation(AnViewJoin.class);
        if (join != null) {
            AnViewJoinValue[] values = join.value();
            objectArray = values;
            n2 = values.length;
            n = 0;
            while (n < n2) {
                Object value = objectArray[n];
                _view.addJoin(value.type(), value.lTable(), value.lColumn(), value.rTable(), value.rColumn(), value.rValue());
                ++n;
            }
        }
        Field[] fields = clazz.getDeclaredFields();
        objectArray = fields;
        n2 = fields.length;
        n = 0;
        while (n < n2) {
            Object field = objectArray[n];
            if (!Classes.isStaticTransientField((Field)field)) {
                String fieldName = ((Field)field).getName();
                AnViewField vfield = ((Field)field).getAnnotation(AnViewField.class);
                if (vfield != null) {
                    _Table _table = this.zTable.getTableByTableName(_view.getTableName(vfield.table()));
                    Asserts.assertNotNull((Object)_table, (String)ORMI18n.ormViewNotFountTable2, (Object[])new Object[]{clazz.getName(), vfield.table()});
                    _TableField _field = _table.getField(vfield.column());
                    Asserts.assertNotNull((Object)_field, (String)ORMI18n.ormViewNotFoundField2, (Object[])new Object[]{clazz.getName(), fieldName});
                    _view.addField(fieldName, vfield.table(), vfield.column(), _field.getType());
                }
            }
            ++n;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != Object.class) {
            Field[] fieldArray = fields = superClass.getDeclaredFields();
            int n3 = fields.length;
            n2 = 0;
            while (n2 < n3) {
                Field field = fieldArray[n2];
                if (!Classes.isStaticTransientField((Field)field)) {
                    Class<?> fpclass;
                    AnTable t;
                    String fieldName = field.getName();
                    AnTableField tfield = field.getAnnotation(AnTableField.class);
                    if (tfield != null && (t = (fpclass = field.getDeclaringClass()).getAnnotation(AnTable.class)) != null) {
                        int type = ORMType.getColumnTypeMaybeLength(tfield.type());
                        _view.addField(fieldName, t.table(), tfield.column(), type);
                    }
                }
                ++n2;
            }
        }
        this.viewMap.put(clazz, _view);
        return _view;
    }

    @Override
    public int count(Class<?> clazz) throws ORMException, SQLException {
        return this.count(clazz, new Selector());
    }

    @Override
    public int count(Class<?> clazz, Selector selector) throws ORMException, SQLException {
        if (selector == null) {
            throw new ORMException("ZView[count][selector]\u4e0d\u5141\u8bb8\u4e3aNULL]");
        }
        _View _view = this.getView(clazz);
        if (_view == null) {
            throw new ORMException("ZView[count][" + clazz.getName() + "]\u672a\u627e\u5230\u76f8\u5e94\u7684\u914d\u7f6e]");
        }
        this.createJoinTable(_view, (MapSS)selector.getReplaceMap());
        HashMapSO paramMap = new HashMapSO();
        StringBuilder sql = new StringBuilder("select count(*) from ");
        sql.append(_view.getJoinTable(this.zTable, selector, (MapSO)paramMap));
        sql.append(_view.getEqualJoinSQL());
        sql.append(selector.getWhereSQL(_view, (MapSO)paramMap));
        List<Integer> list = this.zSQL.executeQuery(sql.toString(), Integer.class, paramMap, (MapSS)selector.getReplaceMap());
        return list.get(0);
    }

    @Override
    public long sum(Class<?> clazz, String field) throws ORMException, SQLException {
        return this.sum(clazz, field, new Selector());
    }

    @Override
    public long sum(Class<?> clazz, String field, Selector selector) throws ORMException, SQLException {
        if (selector == null) {
            throw new ORMException("ZView[sum][Selector]\u4e0d\u5141\u8bb8\u4e3aNULL]");
        }
        _View view = this.getView(clazz);
        if (view == null) {
            throw new ORMException("ZView[sum][" + clazz.getName() + "]\u672a\u627e\u5230\u76f8\u5e94\u7684\u914d\u7f6e]");
        }
        String column = view.getColumn(field);
        if (column == null) {
            throw new ORMException("ZView[sum][" + clazz.getName() + "]\u914d\u7f6e\u4e2d\u672a\u627e\u5230[" + field + "]\u5b57\u6bb5");
        }
        this.createJoinTable(view, (MapSS)selector.getReplaceMap());
        HashMapSO paramMap = new HashMapSO();
        StringBuilder sql = new StringBuilder("select sum(").append(column).append(")");
        sql.append(" from ").append(view.getJoinTable(this.zTable, selector, (MapSO)paramMap));
        sql.append(view.getEqualJoinSQL());
        sql.append(selector == null ? "" : selector.getWhereSQL(view, (MapSO)paramMap));
        List<Long> list = this.zSQL.executeQuery(sql.toString(), Long.class, paramMap, (MapSS)selector.getReplaceMap());
        return list.isEmpty() ? 0L : list.get(0);
    }

    @Override
    public long[] sum(Class<?> clazz, String[] fieldArr) throws ORMException, SQLException {
        return this.sum(clazz, fieldArr, new Selector());
    }

    @Override
    public long[] sum(Class<?> clazz, String[] fieldArr, Selector selector) throws ORMException, SQLException {
        if (selector == null) {
            throw new ORMException("ZView[sum][selector]\u4e0d\u5141\u8bb8\u4e3aNULL]");
        }
        if (fieldArr == null || fieldArr.length < 1) {
            throw new ORMException("ZView[sum][fieldArr]\u4e0d\u80fd\u4e3a\u7a7a]");
        }
        _View view = this.getView(clazz);
        if (view == null) {
            throw new ORMException("ZView[sum][" + clazz.getName() + "]\u672a\u627e\u5230\u76f8\u5e94\u7684\u914d\u7f6e]");
        }
        if (!view.hasAllField(fieldArr)) {
            throw new ORMException("ZView[sum][" + Arrays.toString(fieldArr) + "]\u6709\u672a\u627e\u5230\u7684\u5b57\u6bb5");
        }
        this.createJoinTable(view, (MapSS)selector.getReplaceMap());
        StringBuilder sql = new StringBuilder("select ");
        String column = view.getColumn(fieldArr[0]);
        sql.append(" sum(").append(column).append(") as ").append(fieldArr[0]);
        int i = 1;
        while (i < fieldArr.length) {
            column = view.getColumn(fieldArr[i]);
            sql.append(", sum(").append(column).append(") as ").append(fieldArr[i]);
            ++i;
        }
        HashMapSO paramMap = new HashMapSO();
        sql.append(" from ").append(view.getJoinTable(this.zTable, selector, (MapSO)paramMap)).append(view.getEqualJoinSQL()).append(selector == null ? "" : selector.getWhereSQL(view, (MapSO)paramMap));
        List<LinkedMapSO> list = this.zSQL.executeQuery(sql.toString(), LinkedMapSO.class, paramMap, (MapSS)(selector == null ? null : selector.getReplaceMap()));
        if (list.isEmpty()) {
            return new long[fieldArr.length];
        }
        LinkedMapSO item = list.get(0);
        long[] valueArr = new long[fieldArr.length];
        int i2 = 0;
        while (i2 < fieldArr.length) {
            BigDecimal value = (BigDecimal)item.get(fieldArr[i2]);
            valueArr[i2] = value == null ? 0L : value.longValue();
            ++i2;
        }
        return valueArr;
    }

    @Override
    public <T> T item(Class<T> clazz) throws ORMException, SQLException {
        return this.item(clazz, new Selector());
    }

    @Override
    public <T> T item(Class<T> clazz, Selector selector) throws ORMException, SQLException {
        if (selector == null) {
            throw new ORMException("ZView[item][Selector]\u4e0d\u5141\u8bb8\u4e3aNULL]");
        }
        _View _view = this.getView(clazz);
        if (_view == null) {
            throw new ORMException("ZView[item][" + clazz.getName() + "]\u672a\u627e\u5230\u76f8\u5e94\u7684\u914d\u7f6e]");
        }
        this.createJoinTable(_view, (MapSS)selector.getReplaceMap());
        HashMapSO paramMap = new HashMapSO();
        String whereSQL = selector.getWhereSQL(_view, (MapSO)paramMap);
        String orderbySQL = selector.getOrderbySQL(_view);
        String groupbySQL = selector.getGroupbySQL(_view);
        StringBuilder sql = new StringBuilder();
        switch (this.server.getDatabaseType()) {
            case 1: 
            case 5: {
                sql.append("select ").append(_view.getDefaultFieldSQL(selector.getFields())).append(" from ").append(_view.getJoinTable(this.zTable, selector, (MapSO)paramMap)).append(_view.getEqualJoinSQL()).append(whereSQL).append(orderbySQL).append(groupbySQL).append(" limit 1");
                break;
            }
            case 3: 
            case 6: {
                sql.append("select top 1 ").append(_view.getDefaultFieldSQL(selector.getFields())).append(" from ").append(_view.getJoinTable(this.zTable, selector, (MapSO)paramMap)).append(_view.getEqualJoinSQL()).append(whereSQL).append(orderbySQL).append(groupbySQL);
                break;
            }
            case 2: {
                sql.append("select * from (select ").append(_view.getDefaultFieldSQL(selector.getFields())).append(" from ").append(_view.getJoinTable(this.zTable, selector, (MapSO)paramMap)).append(_view.getEqualJoinSQL()).append(whereSQL).append(orderbySQL).append(groupbySQL).append(") where rownum = 1 ");
                break;
            }
            default: {
                throw new ORMException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b[" + this.server.getDatabaseType() + "]");
            }
        }
        List<T> list = this.zSQL.executeQuery(sql.toString(), clazz, paramMap);
        return list.isEmpty() ? null : (T)list.get(0);
    }

    @Override
    public <T> List<T> list(Class<T> clazz) throws ORMException, SQLException {
        return this.list(clazz, new Selector());
    }

    @Override
    public <T> List<T> list(Class<T> clazz, Selector selector) throws ORMException, SQLException {
        if (selector == null) {
            throw new ORMException("ZView[list][selector]\u4e0d\u5141\u8bb8\u4e3aNULL]");
        }
        _View _view = this.getView(clazz);
        if (_view == null) {
            throw new ORMException("ZView[list][" + clazz.getName() + "]\u672a\u627e\u5230\u76f8\u5e94\u7684\u914d\u7f6e]");
        }
        this.createJoinTable(_view, (MapSS)selector.getReplaceMap());
        HashMapSO paramMap = new HashMapSO();
        StringBuilder sql = new StringBuilder("select ").append(_view.getDefaultFieldSQL(selector.getFields()));
        sql.append(" from ").append(_view.getJoinTable(this.zTable, selector, (MapSO)paramMap));
        sql.append(_view.getEqualJoinSQL());
        sql.append(selector.getWhereSQL(_view, (MapSO)paramMap));
        sql.append(selector.getOrderbySQL(_view));
        sql.append(selector.getGroupbySQL(_view));
        return this.zSQL.executeQuery(sql.toString(), clazz, paramMap, (MapSS)selector.getReplaceMap());
    }

    @Override
    public <T> PageResult<T> page(Class<T> clazz, int pageNo, int pageSize) throws ORMException, SQLException {
        return this.page(clazz, pageNo, pageSize, new Selector());
    }

    @Override
    public <T> PageResult<T> page(Class<T> clazz, int pageNo, int pageSize, Selector selector) throws ORMException, SQLException {
        int totalRecord;
        if (selector == null) {
            throw new ORMException("ZView[page][selector]\u4e0d\u5141\u8bb8\u4e3aNULL]");
        }
        _View _view = this.getView(clazz);
        if (_view == null) {
            throw new ORMException("ZView[page][" + clazz.getName() + "]\u672a\u627e\u5230\u76f8\u5e94\u7684\u914d\u7f6e]");
        }
        this.createJoinTable(_view, (MapSS)selector.getReplaceMap());
        if (pageNo < 1) {
            pageNo = 1;
        }
        if (pageSize < 1) {
            pageSize = 10;
        }
        if ((totalRecord = this.count(clazz, selector)) == 0) {
            return PageBuilder.newResult((int)pageNo, (int)pageSize);
        }
        int minNum = (pageNo - 1) * pageSize + 1;
        int maxNum = pageNo * pageSize;
        HashMapSO paramMap = new HashMapSO();
        paramMap.put("minNum", (Object)new Integer(minNum));
        paramMap.put("maxNum", (Object)new Integer(maxNum));
        paramMap.put("minSize", (Object)new Integer(minNum - 1));
        paramMap.put("pageSize", (Object)new Integer(pageSize));
        String whereSQL = selector.getWhereSQL(_view, (MapSO)paramMap);
        String orderbySQL = selector.getOrderbySQL(_view);
        String groupbySQL = selector.getGroupbySQL(_view);
        StringBuilder innerTableSQL = new StringBuilder(" ( select ");
        innerTableSQL.append(_view.getDefaultFieldSQL(selector.getFields()));
        innerTableSQL.append(" from ").append(_view.getJoinTable(this.zTable, selector, (MapSO)paramMap));
        innerTableSQL.append(_view.getEqualJoinSQL());
        innerTableSQL.append(whereSQL);
        innerTableSQL.append(orderbySQL);
        innerTableSQL.append(groupbySQL);
        innerTableSQL.append(" ) ");
        String sql = this.server.getPolicy().toPageViewSQL(innerTableSQL, maxNum, pageNo);
        List<T> list = this.zSQL.executeQuery(sql, clazz, paramMap, (MapSS)selector.getReplaceMap());
        return PageBuilder.newResult((int)totalRecord, (int)pageNo, (int)pageSize, list);
    }

    private void createJoinTable(_View _view, MapSS replaceMap) throws SQLException, ORMException {
        String viewName = _view.getName();
        if (replaceMap != null) {
            StringBuilder strb = new StringBuilder(viewName);
            for (Map.Entry entry : replaceMap.entrySet()) {
                strb.append("_").append((String)entry.getKey()).append("_").append((String)entry.getValue());
            }
            viewName = strb.toString();
        }
        if (this.existViewList.contains(viewName)) {
            return;
        }
        List<String> tableList = _view.getTableNoAliasList();
        for (String table : tableList) {
            _Table _table = this.zTable.getTableByTableName(table);
            if (_table == null) {
                throw new ORMException("ZView[createJoinTable][" + _view.getName() + "]\u672a\u627e\u5230\u76f8\u5e94[" + table + "]\u7684\u914d\u7f6e");
            }
            this.zTabler.create(_table, replaceMap);
        }
        this.existViewList.add(viewName);
    }
}

